/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.node.KtBreakingCntx;
import com.whitemagicsoftware.keentype.node.KtNetDimen;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import java.util.Vector;

public class KtVertSplit
extends KtNodeList {
    protected static final int INF_BAD = 10000;
    protected static final int DEPLORABLE = 100000;
    protected static final int AWFUL_BAD = 0x3FFFFFFF;
    public KtDimen goal;
    protected KtDimen maxDepth;
    public KtNetDimen soFar;
    public KtDimen depth;
    private int currIndex;
    private int bestIndex;
    private int leastCost;

    public void setNullSpecs() {
        this.goal = KtDimen.MAX_VALUE;
        this.maxDepth = KtDimen.ZERO;
        this.soFar = new KtNetDimen();
        this.depth = KtDimen.ZERO;
    }

    private void restart() {
        this.currIndex = 0;
        this.bestIndex = 0;
        this.leastCost = 0x3FFFFFFF;
    }

    public KtVertSplit() {
        this.setNullSpecs();
        this.restart();
    }

    public KtVertSplit(int initCap) {
        super(initCap);
        this.setNullSpecs();
        this.restart();
    }

    public KtVertSplit(int initCap, int capIncrement) {
        super(initCap, capIncrement);
        this.setNullSpecs();
        this.restart();
    }

    public KtVertSplit(KtNodeEnum nodes) {
        super(nodes);
        this.setNullSpecs();
        this.restart();
    }

    public KtVertSplit(KtNode[] nodes) {
        super(nodes);
        this.setNullSpecs();
        this.restart();
    }

    public KtVertSplit(KtNode[] nodes, int offset, int count) {
        super(nodes, offset, count);
        this.setNullSpecs();
        this.restart();
    }

    public boolean allConsumed() {
        return this.currIndex >= this.length();
    }

    protected KtNodeEnum currPageList() {
        return this.nodes(0, this.currIndex);
    }

    protected KtNodeEnum contribList() {
        return this.nodes(this.currIndex);
    }

    protected boolean findBreak() {
        KtBreakingContext brkContext = new KtBreakingContext();
        while (this.currIndex < this.length()) {
            KtNode node = this.nodeAt(this.currIndex);
            this.passWhileBreaking(node);
            boolean tryThisBreak = true;
            if (node.isKernBreak()) {
                if (this.currIndex + 1 < this.length()) {
                    tryThisBreak = this.nodeAt(this.currIndex + 1).canFollowKernBreak();
                } else {
                    if (this.waitingForMore()) {
                        return false;
                    }
                    tryThisBreak = false;
                }
            }
            if (tryThisBreak) {
                brkContext.atSkip = this.currIndex > 0 && this.nodeAt(this.currIndex - 1).canPrecedeSkipBreak();
                int pen = node.breakPenalty(brkContext);
                if (this.tryBreak(pen)) {
                    return true;
                }
            }
            if (!node.sizeIgnored()) {
                this.soFar.add(this.depth);
                this.soFar.add(node.getHeight());
                this.soFar.addShrink(node.getHshr());
                this.soFar.addStretch(node.getHstrOrd(), node.getHstr());
                this.depth = node.getDepth();
            }
            this.adjustDepth();
            ++this.currIndex;
        }
        return false;
    }

    protected void passWhileBreaking(KtNode node) {
    }

    protected boolean waitingForMore() {
        return false;
    }

    protected void adjustDepth() {
        if (this.depth.moreThan(this.maxDepth)) {
            this.soFar.add(this.depth);
            this.depth = this.maxDepth;
            this.soFar.sub(this.depth);
        }
    }

    protected boolean tryBreak(int pen) {
        if (pen < 10000) {
            int cost;
            KtDimen diff = this.goal.minus(this.soFar.getNatural());
            int badness = diff.moreThan(0) ? (this.soFar.getMaxStrOrder() > 0 ? 0 : diff.badness(this.soFar.getStretch((byte)0))) : ((diff = diff.negative()).moreThan(this.soFar.getShrink()) ? 0x3FFFFFFF : diff.badness(this.soFar.getShrink()));
            int extra = this.extraPenalty();
            int n = badness < 0x3FFFFFFF ? (pen <= -10000 ? pen : (badness < 10000 ? badness + pen + extra : 100000)) : (cost = badness);
            if (extra >= 10000) {
                cost = 0x3FFFFFFF;
            }
            if (cost <= this.leastCost) {
                this.bestIndex = this.currIndex;
                this.leastCost = cost;
                this.markBestPlace();
                this.traceCost(pen, badness, cost, true);
            } else {
                this.traceCost(pen, badness, cost, false);
            }
            return cost == 0x3FFFFFFF || pen <= -10000;
        }
        return false;
    }

    protected int extraPenalty() {
        return 0;
    }

    protected void markBestPlace() {
    }

    protected void traceCost(int pen, int bad, int cost, boolean best) {
    }

    public KtNode breakNode() {
        return this.bestIndex < this.length() ? this.nodeAt(this.bestIndex) : KtNode.NULL;
    }

    public KtNodeList makeSplitting(KtDimen height, KtDimen depth) {
        this.goal = height;
        this.maxDepth = depth;
        if (!this.findBreak()) {
            this.tryBreak(-10000);
        }
        return this.split();
    }

    protected KtNodeList split() {
        KtNodeList list = new KtNodeList(new Vector<KtNode>(this.data.subList(0, this.bestIndex)));
        this.data = new Vector(this.data.subList(this.bestIndex, this.length()));
        this.restart();
        return list;
    }

    public boolean pruneTop() {
        while (this.currIndex < this.length()) {
            KtNode node = this.nodeAt(this.currIndex);
            this.passWhilePrunning(node);
            if (node.discardable()) {
                this.data.remove(this.currIndex);
                continue;
            }
            if (node.sizeIgnored()) {
                ++this.currIndex;
                continue;
            }
            KtNode adj = this.topAdjustment(this.nodeAt(this.currIndex).getHeight());
            if (adj != KtNode.NULL) {
                this.data.add(this.currIndex, adj);
            }
            return true;
        }
        return false;
    }

    protected void passWhilePrunning(KtNode node) {
    }

    protected KtNode topAdjustment(KtDimen height) {
        return KtNode.NULL;
    }

    protected static class KtBreakingContext
    implements KtBreakingCntx {
        public boolean atSkip = true;

        protected KtBreakingContext() {
        }

        @Override
        public boolean spaceBreaking() {
            return true;
        }

        @Override
        public boolean allowedAtSkip() {
            return this.atSkip;
        }

        @Override
        public int hyphenPenalty() {
            return 0;
        }

        @Override
        public int exHyphenPenalty() {
            return 0;
        }
    }
}

