/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tex;

import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtContextDisplay;
import com.whitemagicsoftware.keentype.io.KtBufferLineOutput;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtStandardLog;
import com.whitemagicsoftware.keentype.tex.KtConfig;

public class KtTeXContextDisplay
implements KtContextDisplay {
    private final KtConfig config;
    private final KtBufferLineOutput leftOut;
    private final KtBufferLineOutput rightOut;
    private final KtLog leftLog;
    private final KtLog rightLog;
    private int origin = 0;

    public KtTeXContextDisplay(KtConfig config, KtCharCode.KtMaker maker, KtStandardLog.KtEscape esc) {
        this.config = config;
        this.leftOut = new KtBufferLineOutput(50, 0, maker);
        this.rightOut = new KtBufferLineOutput(79, 79, maker);
        this.leftLog = new KtStandardLog(this.leftOut, esc);
        this.rightLog = new KtStandardLog(this.rightOut, esc);
        if (this.normal() != KtLog.NULL) {
            this.origin = this.normal().getCount();
        }
    }

    @Override
    public void reset() {
        this.leftOut.reset();
        this.rightOut.reset();
        this.origin = this.normal().getCount();
    }

    @Override
    public int lines() {
        return this.config.errContextLines();
    }

    @Override
    public KtLog normal() {
        return KtCommand.normLog;
    }

    @Override
    public KtLog left() {
        return this.leftLog;
    }

    @Override
    public KtLog right() {
        return this.rightLog;
    }

    @Override
    public void show() {
        int n;
        int intro = this.normal().getCount() - this.origin;
        int half = intro + this.leftOut.size();
        if (half <= 50) {
            this.leftOut.addOn(this.normal());
        } else {
            this.normal().add("...");
            half = 50;
            n = half - intro - 3;
            if (n > 0) {
                this.leftOut.addOn(this.normal(), this.leftOut.size() - n, this.leftOut.size());
            }
        }
        this.normal().endLine().add(' ', half);
        if (half + this.rightOut.size() <= 79) {
            this.rightOut.addOn(this.normal());
        } else {
            n = 79 - half - 3;
            if (n > 0) {
                this.rightOut.addOn(this.normal(), 0, n);
            }
            this.normal().add("...");
        }
    }
}

