/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.typo.KtTypoAssignPrim;
import java.util.Vector;

public class KtHyphenationPrim
extends KtTypoAssignPrim {
    public KtHyphenationPrim(String name) {
        super(name);
    }

    @Override
    protected void assign(KtToken src, boolean glob) {
        KtHyphenationPrim.scanLeftBrace();
        StringBuilder buf = new StringBuilder();
        Vector<Integer> hyphBuf = new Vector<Integer>();
        int index = 0;
        while (true) {
            KtToken tok;
            KtCommand cmd;
            KtCharCode code;
            if ((code = (cmd = KtHyphenationPrim.meaningOf(tok = KtHyphenationPrim.nextExpToken())).charCodeToAdd()) != KtCharCode.NULL) {
                if (code.match('-')) {
                    hyphBuf.add(index);
                    continue;
                }
                char letter = code.toCanonicalLetter();
                if (letter != '\uffff') {
                    buf.append(letter);
                    ++index;
                    continue;
                }
                KtHyphenationPrim.error("NonLetterInHyph");
                continue;
            }
            if (cmd.isSpacer() || cmd.isRightBrace()) {
                if (index > 1) {
                    int[] positions = new int[hyphBuf.size()];
                    for (int i = 0; i < positions.length; ++i) {
                        positions[i] = (Integer)hyphBuf.get(i);
                    }
                    KtHyphenationPrim.getTypoConfig().getLanguage().setHyphException(buf.toString(), positions);
                    index = 0;
                    buf.setLength(0);
                    hyphBuf.clear();
                }
                if (!cmd.isRightBrace()) continue;
                break;
            }
            KtHyphenationPrim.error("ImproperHyphen", this);
        }
    }
}

