/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.GraphvizFormatter;
import org.apache.lucene.analysis.ja.Token;
import org.apache.lucene.analysis.ja.dict.CharacterDefinition;
import org.apache.lucene.analysis.ja.dict.ConnectionCosts;
import org.apache.lucene.analysis.ja.dict.Dictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoDictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.analysis.ja.dict.UnknownDictionary;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.ja.tokenattributes.BaseFormAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.InflectionAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.util.RollingCharBuffer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;

public final class JapaneseTokenizer
extends Tokenizer {
    public static final Mode DEFAULT_MODE = Mode.SEARCH;
    private final EnumMap<Type, Dictionary> dictionaryMap = new EnumMap(Type.class);
    private final TokenInfoFST fst;
    private final TokenInfoDictionary dictionary;
    private final UnknownDictionary unkDictionary;
    private final ConnectionCosts costs;
    private final UserDictionary userDictionary;
    private final CharacterDefinition characterDefinition;
    private final FST.Arc<Long> arc = new FST.Arc();
    private final FST.BytesReader fstReader;
    private final IntsRef wordIdRef = new IntsRef();
    private final FST.BytesReader userFSTReader;
    private final TokenInfoFST userFST;
    private final RollingCharBuffer buffer = new RollingCharBuffer();
    private final WrappedPositionArray positions = new WrappedPositionArray();
    private final boolean discardPunctuation;
    private final boolean searchMode;
    private final boolean extendedMode;
    private final boolean outputCompounds;
    private boolean outputNBest = false;
    private int nBestCost = 0;
    private boolean end;
    private int lastBackTracePos;
    private int lastTokenPos;
    private int pos;
    private final List<Token> pending = new ArrayList<Token>();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = this.addAttribute(PositionLengthAttribute.class);
    private final BaseFormAttribute basicFormAtt = this.addAttribute(BaseFormAttribute.class);
    private final PartOfSpeechAttribute posAtt = this.addAttribute(PartOfSpeechAttribute.class);
    private final ReadingAttribute readingAtt = this.addAttribute(ReadingAttribute.class);
    private final InflectionAttribute inflectionAtt = this.addAttribute(InflectionAttribute.class);
    private GraphvizFormatter dotOut;
    private Lattice lattice = null;

    public JapaneseTokenizer(UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, userDictionary, discardPunctuation, discardCompoundToken, mode);
    }

    public JapaneseTokenizer(AttributeFactory factory, UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        this(factory, TokenInfoDictionary.getInstance(), UnknownDictionary.getInstance(), ConnectionCosts.getInstance(), userDictionary, discardPunctuation, discardCompoundToken, mode);
    }

    public JapaneseTokenizer(AttributeFactory factory, TokenInfoDictionary systemDictionary, UnknownDictionary unkDictionary, ConnectionCosts connectionCosts, UserDictionary userDictionary, boolean discardPunctuation, boolean discardCompoundToken, Mode mode) {
        super(factory);
        this.dictionary = systemDictionary;
        this.fst = this.dictionary.getFST();
        this.unkDictionary = unkDictionary;
        this.characterDefinition = unkDictionary.getCharacterDefinition();
        this.userDictionary = userDictionary;
        this.costs = connectionCosts;
        this.fstReader = this.fst.getBytesReader();
        if (userDictionary != null) {
            this.userFST = userDictionary.getFST();
            this.userFSTReader = this.userFST.getBytesReader();
        } else {
            this.userFST = null;
            this.userFSTReader = null;
        }
        this.discardPunctuation = discardPunctuation;
        switch (mode) {
            case SEARCH: {
                this.searchMode = true;
                this.extendedMode = false;
                this.outputCompounds = !discardCompoundToken;
                break;
            }
            case EXTENDED: {
                this.searchMode = true;
                this.extendedMode = true;
                this.outputCompounds = !discardCompoundToken;
                break;
            }
            default: {
                this.searchMode = false;
                this.extendedMode = false;
                this.outputCompounds = false;
            }
        }
        this.buffer.reset(this.input);
        this.resetState();
        this.dictionaryMap.put(Type.KNOWN, this.dictionary);
        this.dictionaryMap.put(Type.UNKNOWN, unkDictionary);
        this.dictionaryMap.put(Type.USER, userDictionary);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.buffer.reset(this.input);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.buffer.reset(this.input);
        this.resetState();
    }

    private void resetState() {
        this.positions.reset();
        this.pos = 0;
        this.end = false;
        this.lastBackTracePos = 0;
        this.lastTokenPos = -1;
        this.pending.clear();
        this.positions.get(0).add(0, 0, -1, -1, -1, Type.KNOWN);
    }

    @Override
    public void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.pos);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    private int computeSecondBestThreshold(int pos, int length) throws IOException {
        return this.computePenalty(pos, length);
    }

    private int computePenalty(int pos, int length) throws IOException {
        if (length > 2) {
            boolean allKanji = true;
            int endPos = pos + length;
            for (int pos2 = pos; pos2 < endPos; ++pos2) {
                if (this.characterDefinition.isKanji((char)this.buffer.get(pos2))) continue;
                allKanji = false;
                break;
            }
            if (allKanji) {
                return (length - 2) * 3000;
            }
            if (length > 7) {
                return (length - 7) * 1700;
            }
        }
        return 0;
    }

    private void add(Dictionary dict, Position fromPosData, int endPos, int wordID, Type type, boolean addPenalty) throws IOException {
        int wordCost = dict.getWordCost(wordID);
        int leftID = dict.getLeftId(wordID);
        int leastCost = Integer.MAX_VALUE;
        int leastIDX = -1;
        assert (fromPosData.count > 0);
        for (int idx = 0; idx < fromPosData.count; ++idx) {
            int cost = fromPosData.costs[idx] + this.costs.get(fromPosData.lastRightID[idx], leftID);
            if (cost >= leastCost) continue;
            leastCost = cost;
            leastIDX = idx;
        }
        leastCost += wordCost;
        if (addPenalty && type != Type.USER) {
            int penalty = this.computePenalty(fromPosData.pos, endPos - fromPosData.pos);
            leastCost += penalty;
        }
        assert (leftID == dict.getRightId(wordID));
        this.positions.get(endPos).add(leastCost, leftID, fromPosData.pos, leastIDX, wordID, type);
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (this.pending.size() == 0) {
            if (this.end) {
                return false;
            }
            this.parse();
        }
        Token token = this.pending.remove(this.pending.size() - 1);
        int position = token.getPosition();
        int length = token.getLength();
        this.clearAttributes();
        assert (length > 0);
        this.termAtt.copyBuffer(token.getSurfaceForm(), token.getOffset(), length);
        this.offsetAtt.setOffset(this.correctOffset(position), this.correctOffset(position + length));
        this.basicFormAtt.setToken(token);
        this.posAtt.setToken(token);
        this.readingAtt.setToken(token);
        this.inflectionAtt.setToken(token);
        if (token.getPosition() == this.lastTokenPos) {
            this.posIncAtt.setPositionIncrement(0);
            this.posLengthAtt.setPositionLength(token.getPositionLength());
        } else if (this.outputNBest) {
            assert (token.getPosition() > this.lastTokenPos);
            this.posIncAtt.setPositionIncrement(1);
            this.posLengthAtt.setPositionLength(token.getPositionLength());
        } else {
            assert (token.getPosition() > this.lastTokenPos);
            this.posIncAtt.setPositionIncrement(1);
            this.posLengthAtt.setPositionLength(1);
        }
        this.lastTokenPos = token.getPosition();
        return true;
    }

    private void parse() throws IOException {
        int leastIDX;
        int unknownWordEndIndex = -1;
        while (this.buffer.get(this.pos) != -1) {
            int ch;
            int output;
            boolean isFrontier;
            Position posData = this.positions.get(this.pos);
            boolean bl = isFrontier = this.positions.getNextPos() == this.pos + 1;
            if (posData.count == 0) {
                ++this.pos;
                continue;
            }
            if (this.pos > this.lastBackTracePos && posData.count == 1 && isFrontier) {
                if (this.outputNBest) {
                    this.backtraceNBest(posData, false);
                }
                this.backtrace(posData, 0);
                if (this.outputNBest) {
                    this.fixupPendingList();
                }
                posData.costs[0] = 0;
                if (this.pending.size() != 0) {
                    return;
                }
            }
            if (this.pos - this.lastBackTracePos >= 1024) {
                Position posData2;
                int pos2;
                leastIDX = -1;
                int leastCost = Integer.MAX_VALUE;
                Position leastPosData = null;
                for (pos2 = this.pos; pos2 < this.positions.getNextPos(); ++pos2) {
                    posData2 = this.positions.get(pos2);
                    for (int idx = 0; idx < posData2.count; ++idx) {
                        int cost = posData2.costs[idx];
                        if (cost >= leastCost) continue;
                        leastCost = cost;
                        leastIDX = idx;
                        leastPosData = posData2;
                    }
                }
                assert (leastIDX != -1);
                if (this.outputNBest) {
                    this.backtraceNBest(leastPosData, false);
                }
                for (pos2 = this.pos; pos2 < this.positions.getNextPos(); ++pos2) {
                    posData2 = this.positions.get(pos2);
                    if (posData2 != leastPosData) {
                        posData2.reset();
                        continue;
                    }
                    if (leastIDX != 0) {
                        posData2.costs[0] = posData2.costs[leastIDX];
                        posData2.lastRightID[0] = posData2.lastRightID[leastIDX];
                        posData2.backPos[0] = posData2.backPos[leastIDX];
                        posData2.backIndex[0] = posData2.backIndex[leastIDX];
                        posData2.backID[0] = posData2.backID[leastIDX];
                        posData2.backType[0] = posData2.backType[leastIDX];
                    }
                    posData2.count = 1;
                }
                this.backtrace(leastPosData, 0);
                if (this.outputNBest) {
                    this.fixupPendingList();
                }
                Arrays.fill(leastPosData.costs, 0, leastPosData.count, 0);
                if (this.pos != leastPosData.pos) {
                    assert (this.pos < leastPosData.pos);
                    this.pos = leastPosData.pos;
                }
                if (this.pending.size() == 0) continue;
                return;
            }
            boolean anyMatches = false;
            if (this.userFST != null) {
                this.userFST.getFirstArc(this.arc);
                output = 0;
                int posAhead = posData.pos;
                while ((ch = this.buffer.get(posAhead)) != -1 && this.userFST.findTargetArc(ch, this.arc, this.arc, posAhead == posData.pos, this.userFSTReader) != null) {
                    output += this.arc.output().intValue();
                    if (this.arc.isFinal()) {
                        this.add(this.userDictionary, posData, posAhead + 1, output + this.arc.nextFinalOutput().intValue(), Type.USER, false);
                        anyMatches = true;
                    }
                    ++posAhead;
                }
            }
            if (!anyMatches) {
                this.fst.getFirstArc(this.arc);
                output = 0;
                int posAhead = posData.pos;
                while ((ch = this.buffer.get(posAhead)) != -1 && this.fst.findTargetArc(ch, this.arc, this.arc, posAhead == posData.pos, this.fstReader) != null) {
                    output += this.arc.output().intValue();
                    if (this.arc.isFinal()) {
                        this.dictionary.lookupWordIds(output + this.arc.nextFinalOutput().intValue(), this.wordIdRef);
                        for (int ofs = 0; ofs < this.wordIdRef.length; ++ofs) {
                            this.add(this.dictionary, posData, posAhead + 1, this.wordIdRef.ints[this.wordIdRef.offset + ofs], Type.KNOWN, false);
                            anyMatches = true;
                        }
                    }
                    ++posAhead;
                }
            }
            if (!this.searchMode && unknownWordEndIndex > posData.pos) {
                ++this.pos;
                continue;
            }
            char firstCharacter = (char)this.buffer.get(this.pos);
            if (!anyMatches || this.characterDefinition.isInvoke(firstCharacter)) {
                int unknownWordLength;
                byte characterId = this.characterDefinition.getCharacterClass(firstCharacter);
                boolean isPunct = JapaneseTokenizer.isPunctuation(firstCharacter);
                if (!this.characterDefinition.isGroup(firstCharacter)) {
                    unknownWordLength = 1;
                } else {
                    int ch2;
                    unknownWordLength = 1;
                    int posAhead = this.pos + 1;
                    while (unknownWordLength < 1024 && (ch2 = this.buffer.get(posAhead)) != -1 && characterId == this.characterDefinition.getCharacterClass((char)ch2) && JapaneseTokenizer.isPunctuation((char)ch2) == isPunct) {
                        ++unknownWordLength;
                        ++posAhead;
                    }
                }
                this.unkDictionary.lookupWordIds(characterId, this.wordIdRef);
                for (int ofs = 0; ofs < this.wordIdRef.length; ++ofs) {
                    this.add(this.unkDictionary, posData, posData.pos + unknownWordLength, this.wordIdRef.ints[this.wordIdRef.offset + ofs], Type.UNKNOWN, false);
                }
                unknownWordEndIndex = posData.pos + unknownWordLength;
            }
            ++this.pos;
        }
        this.end = true;
        if (this.pos > 0) {
            Position endPosData = this.positions.get(this.pos);
            int leastCost = Integer.MAX_VALUE;
            leastIDX = -1;
            for (int idx = 0; idx < endPosData.count; ++idx) {
                int cost = endPosData.costs[idx] + this.costs.get(endPosData.lastRightID[idx], 0);
                if (cost >= leastCost) continue;
                leastCost = cost;
                leastIDX = idx;
            }
            if (this.outputNBest) {
                this.backtraceNBest(endPosData, true);
            }
            this.backtrace(endPosData, leastIDX);
            if (this.outputNBest) {
                this.fixupPendingList();
            }
        }
    }

    private void pruneAndRescore(int startPos, int endPos, int bestStartIDX) throws IOException {
        Position posData;
        int pos;
        for (pos = endPos; pos > startPos; --pos) {
            posData = this.positions.get(pos);
            for (int arcIDX = 0; arcIDX < posData.count; ++arcIDX) {
                int backPos = posData.backPos[arcIDX];
                if (backPos < startPos) continue;
                this.positions.get(backPos).addForward(pos, arcIDX, posData.backID[arcIDX], posData.backType[arcIDX]);
            }
            if (pos == startPos) continue;
            posData.count = 0;
        }
        for (pos = startPos; pos < endPos; ++pos) {
            posData = this.positions.get(pos);
            if (posData.count == 0) {
                posData.forwardCount = 0;
                continue;
            }
            if (pos == startPos) {
                int rightID = startPos == 0 ? 0 : this.getDict(posData.backType[bestStartIDX]).getRightId(posData.backID[bestStartIDX]);
                int pathCost = posData.costs[bestStartIDX];
                for (int forwardArcIDX = 0; forwardArcIDX < posData.forwardCount; ++forwardArcIDX) {
                    Type forwardType = posData.forwardType[forwardArcIDX];
                    Dictionary dict2 = this.getDict(forwardType);
                    int wordID = posData.forwardID[forwardArcIDX];
                    int toPos = posData.forwardPos[forwardArcIDX];
                    int newCost = pathCost + dict2.getWordCost(wordID) + this.costs.get(rightID, dict2.getLeftId(wordID)) + this.computePenalty(pos, toPos - pos);
                    this.positions.get(toPos).add(newCost, dict2.getRightId(wordID), pos, bestStartIDX, wordID, forwardType);
                }
            } else {
                for (int forwardArcIDX = 0; forwardArcIDX < posData.forwardCount; ++forwardArcIDX) {
                    Type forwardType = posData.forwardType[forwardArcIDX];
                    int toPos = posData.forwardPos[forwardArcIDX];
                    this.add(this.getDict(forwardType), posData, toPos, posData.forwardID[forwardArcIDX], forwardType, true);
                }
            }
            posData.forwardCount = 0;
        }
    }

    private void registerNode(int node, char[] fragment) {
        int left = this.lattice.nodeLeft[node];
        int right = this.lattice.nodeRight[node];
        Type type = this.lattice.nodeDicType[node];
        if (!this.discardPunctuation || !JapaneseTokenizer.isPunctuation(fragment[left])) {
            if (type == Type.USER) {
                int[] wordIDAndLength = this.userDictionary.lookupSegmentation(this.lattice.nodeWordID[node]);
                int wordID = wordIDAndLength[0];
                this.pending.add(new Token(wordID, fragment, left, right - left, Type.USER, this.lattice.rootBase + left, this.userDictionary));
                int current = 0;
                for (int j = 1; j < wordIDAndLength.length; ++j) {
                    int len = wordIDAndLength[j];
                    if (len < right - left) {
                        this.pending.add(new Token(wordID + j - 1, fragment, current + left, len, Type.USER, this.lattice.rootBase + current + left, this.userDictionary));
                    }
                    current += len;
                }
            } else {
                this.pending.add(new Token(this.lattice.nodeWordID[node], fragment, left, right - left, type, this.lattice.rootBase + left, this.getDict(type)));
            }
        }
    }

    private void fixupPendingList() {
        Collections.sort(this.pending, new Comparator<Token>(){

            @Override
            public int compare(Token a, Token b) {
                int bLen;
                int bOff;
                int aOff = a.getOffset();
                if (aOff != (bOff = b.getOffset())) {
                    return aOff - bOff;
                }
                int aLen = a.getLength();
                if (aLen != (bLen = b.getLength())) {
                    return aLen - bLen;
                }
                return b.getType().ordinal() - a.getType().ordinal();
            }
        });
        for (int i = 1; i < this.pending.size(); ++i) {
            Token a = this.pending.get(i - 1);
            Token b = this.pending.get(i);
            if (a.getOffset() != b.getOffset() || a.getLength() != b.getLength()) continue;
            this.pending.remove(i);
            --i;
        }
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Token t : this.pending) {
            map.put(t.getOffset(), 0);
            map.put(t.getOffset() + t.getLength(), 0);
        }
        Object[] offsets = map.keySet().toArray(new Integer[0]);
        Arrays.sort(offsets);
        for (int i = 0; i < offsets.length; ++i) {
            map.put(offsets[i], i);
        }
        for (Token t : this.pending) {
            t.setPositionLength((Integer)map.get(t.getOffset() + t.getLength()) - (Integer)map.get(t.getOffset()));
        }
        Collections.reverse(this.pending);
    }

    private void backtraceNBest(Position endPosData, boolean useEOS) throws IOException {
        int cost;
        List<Integer> nbest;
        if (this.lattice == null) {
            this.lattice = new Lattice();
        }
        int endPos = endPosData.pos;
        char[] fragment = this.buffer.get(this.lastBackTracePos, endPos - this.lastBackTracePos);
        this.lattice.setup(fragment, this.dictionaryMap, this.positions, this.lastBackTracePos, endPos, useEOS);
        this.lattice.markUnreachable();
        this.lattice.calcLeftCost(this.costs);
        this.lattice.calcRightCost(this.costs);
        int bestCost = this.lattice.bestCost();
        for (int node : this.lattice.bestPathNodeList()) {
            this.registerNode(node, fragment);
        }
        int n = 2;
        while (!(nbest = this.lattice.nBestNodeList(n)).isEmpty() && bestCost + this.nBestCost >= (cost = this.lattice.cost(nbest.get(0)))) {
            for (int node : nbest) {
                this.registerNode(node, fragment);
            }
            ++n;
        }
    }

    private void backtrace(Position endPosData, int fromIDX) throws IOException {
        int endPos = endPosData.pos;
        if (endPos == this.lastBackTracePos) {
            return;
        }
        char[] fragment = this.buffer.get(this.lastBackTracePos, endPos - this.lastBackTracePos);
        if (this.dotOut != null) {
            this.dotOut.onBacktrace(this, this.positions, this.lastBackTracePos, endPosData, fromIDX, fragment, this.end);
        }
        int pos = endPos;
        int bestIDX = fromIDX;
        Token altToken = null;
        int lastLeftWordID = -1;
        int backCount = 0;
        while (pos > this.lastBackTracePos) {
            int penalty;
            Position posData = this.positions.get(pos);
            assert (bestIDX < posData.count);
            int backPos = posData.backPos[bestIDX];
            assert (backPos >= this.lastBackTracePos) : "backPos=" + backPos + " vs lastBackTracePos=" + this.lastBackTracePos;
            int length = pos - backPos;
            Type backType = posData.backType[bestIDX];
            int backID = posData.backID[bestIDX];
            int nextBestIDX = posData.backIndex[bestIDX];
            if (this.searchMode && altToken == null && backType != Type.USER && (penalty = this.computeSecondBestThreshold(backPos, pos - backPos)) > 0) {
                int maxCost = posData.costs[bestIDX] + penalty;
                if (lastLeftWordID != -1) {
                    maxCost += this.costs.get(this.getDict(backType).getRightId(backID), lastLeftWordID);
                }
                this.pruneAndRescore(backPos, pos, posData.backIndex[bestIDX]);
                int leastCost = Integer.MAX_VALUE;
                int leastIDX = -1;
                for (int idx = 0; idx < posData.count; ++idx) {
                    int cost = posData.costs[idx];
                    if (lastLeftWordID != -1) {
                        cost += this.costs.get(this.getDict(posData.backType[idx]).getRightId(posData.backID[idx]), lastLeftWordID);
                    }
                    if (cost >= leastCost) continue;
                    leastCost = cost;
                    leastIDX = idx;
                }
                if (leastIDX != -1 && leastCost <= maxCost && posData.backPos[leastIDX] != backPos) {
                    assert (posData.backPos[leastIDX] != backPos);
                    altToken = new Token(backID, fragment, backPos - this.lastBackTracePos, length, backType, backPos, this.getDict(backType));
                    bestIDX = leastIDX;
                    nextBestIDX = posData.backIndex[bestIDX];
                    backPos = posData.backPos[bestIDX];
                    length = pos - backPos;
                    backType = posData.backType[bestIDX];
                    backID = posData.backID[bestIDX];
                    backCount = 0;
                }
            }
            int offset = backPos - this.lastBackTracePos;
            assert (offset >= 0);
            if (altToken != null && altToken.getPosition() >= backPos) {
                if (this.outputCompounds) {
                    assert (altToken.getPosition() == backPos) : altToken.getPosition() + " vs " + backPos;
                    if (backCount > 0) {
                        altToken.setPositionLength(++backCount);
                        this.pending.add(altToken);
                    } else assert (this.discardPunctuation);
                }
                altToken = null;
            }
            Dictionary dict = this.getDict(backType);
            if (backType == Type.USER) {
                int[] wordIDAndLength = this.userDictionary.lookupSegmentation(backID);
                int wordID = wordIDAndLength[0];
                int current = 0;
                for (int j = 1; j < wordIDAndLength.length; ++j) {
                    int len = wordIDAndLength[j];
                    this.pending.add(new Token(wordID + j - 1, fragment, current + offset, len, Type.USER, current + backPos, dict));
                    current += len;
                }
                Collections.reverse(this.pending.subList(this.pending.size() - (wordIDAndLength.length - 1), this.pending.size()));
                backCount += wordIDAndLength.length - 1;
            } else if (this.extendedMode && backType == Type.UNKNOWN) {
                int unigramTokenCount = 0;
                for (int i = length - 1; i >= 0; --i) {
                    int charLen = 1;
                    if (i > 0 && Character.isLowSurrogate(fragment[offset + i])) {
                        --i;
                        charLen = 2;
                    }
                    if (this.discardPunctuation && JapaneseTokenizer.isPunctuation(fragment[offset + i])) continue;
                    this.pending.add(new Token(CharacterDefinition.NGRAM, fragment, offset + i, charLen, Type.UNKNOWN, backPos + i, this.unkDictionary));
                    ++unigramTokenCount;
                }
                backCount += unigramTokenCount;
            } else if (!this.discardPunctuation || length == 0 || !JapaneseTokenizer.isPunctuation(fragment[offset])) {
                this.pending.add(new Token(backID, fragment, offset, length, backType, backPos, dict));
                ++backCount;
            }
            lastLeftWordID = dict.getLeftId(backID);
            pos = backPos;
            bestIDX = nextBestIDX;
        }
        this.lastBackTracePos = endPos;
        this.buffer.freeBefore(endPos);
        this.positions.freeBefore(endPos);
    }

    Dictionary getDict(Type type) {
        return this.dictionaryMap.get((Object)type);
    }

    private static boolean isPunctuation(char ch) {
        switch (Character.getType(ch)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    private static final class Lattice {
        char[] fragment;
        EnumMap<Type, Dictionary> dictionaryMap;
        boolean useEOS;
        int rootCapacity = 0;
        int rootSize = 0;
        int rootBase = 0;
        int[] lRoot;
        int[] rRoot;
        int capacity = 0;
        int nodeCount = 0;
        Type[] nodeDicType;
        int[] nodeWordID;
        int[] nodeMark;
        int[] nodeLeftID;
        int[] nodeRightID;
        int[] nodeWordCost;
        int[] nodeLeftCost;
        int[] nodeRightCost;
        int[] nodeLeftNode;
        int[] nodeRightNode;
        int[] nodeLeft;
        int[] nodeRight;
        int[] nodeLeftChain;
        int[] nodeRightChain;

        private Lattice() {
        }

        private void setupRoot(int baseOffset, int lastOffset) {
            assert (baseOffset <= lastOffset);
            int size = lastOffset - baseOffset + 1;
            if (this.rootCapacity < size) {
                int oversize = ArrayUtil.oversize(size, 4);
                this.lRoot = new int[oversize];
                this.rRoot = new int[oversize];
                this.rootCapacity = oversize;
            }
            Arrays.fill(this.lRoot, 0, size, -1);
            Arrays.fill(this.rRoot, 0, size, -1);
            this.rootSize = size;
            this.rootBase = baseOffset;
        }

        private void reserve(int n) {
            if (this.capacity < n) {
                int oversize = ArrayUtil.oversize(n, 4);
                this.nodeDicType = new Type[oversize];
                this.nodeWordID = new int[oversize];
                this.nodeMark = new int[oversize];
                this.nodeLeftID = new int[oversize];
                this.nodeRightID = new int[oversize];
                this.nodeWordCost = new int[oversize];
                this.nodeLeftCost = new int[oversize];
                this.nodeRightCost = new int[oversize];
                this.nodeLeftNode = new int[oversize];
                this.nodeRightNode = new int[oversize];
                this.nodeLeft = new int[oversize];
                this.nodeRight = new int[oversize];
                this.nodeLeftChain = new int[oversize];
                this.nodeRightChain = new int[oversize];
                this.capacity = oversize;
            }
        }

        private void setupNodePool(int n) {
            this.reserve(n);
            this.nodeCount = 0;
        }

        private int addNode(Type dicType, int wordID, int left, int right) {
            assert (this.nodeCount < this.capacity);
            assert (left == -1 || right == -1 || left < right);
            assert (left == -1 || 0 <= left && left < this.rootSize);
            assert (right == -1 || 0 <= right && right < this.rootSize);
            int node = this.nodeCount++;
            this.nodeDicType[node] = dicType;
            this.nodeWordID[node] = wordID;
            this.nodeMark[node] = 0;
            if (wordID < 0) {
                this.nodeWordCost[node] = 0;
                this.nodeLeftCost[node] = 0;
                this.nodeRightCost[node] = 0;
                this.nodeLeftID[node] = 0;
                this.nodeRightID[node] = 0;
            } else {
                Dictionary dic = this.dictionaryMap.get((Object)dicType);
                this.nodeWordCost[node] = dic.getWordCost(wordID);
                this.nodeLeftID[node] = dic.getLeftId(wordID);
                this.nodeRightID[node] = dic.getRightId(wordID);
            }
            this.nodeLeft[node] = left;
            this.nodeRight[node] = right;
            if (0 <= left) {
                this.nodeLeftChain[node] = this.lRoot[left];
                this.lRoot[left] = node;
            } else {
                this.nodeLeftChain[node] = -1;
            }
            if (0 <= right) {
                this.nodeRightChain[node] = this.rRoot[right];
                this.rRoot[right] = node;
            } else {
                this.nodeRightChain[node] = -1;
            }
            return node;
        }

        private int positionCount(WrappedPositionArray positions, int beg, int end) {
            int count = 0;
            for (int i = beg; i < end; ++i) {
                count += positions.get((int)i).count;
            }
            return count;
        }

        void setup(char[] fragment, EnumMap<Type, Dictionary> dictionaryMap, WrappedPositionArray positions, int prevOffset, int endOffset, boolean useEOS) {
            assert (positions.get((int)prevOffset).count == 1);
            this.fragment = fragment;
            this.dictionaryMap = dictionaryMap;
            this.useEOS = useEOS;
            this.setupRoot(prevOffset, endOffset);
            this.setupNodePool(this.positionCount(positions, prevOffset + 1, endOffset + 1) + 2);
            Position first = positions.get(prevOffset);
            if (this.addNode(first.backType[0], first.backID[0], -1, 0) != 0) assert (false);
            if (this.addNode(Type.KNOWN, -1, endOffset - this.rootBase, -1) != 1) assert (false);
            for (int offset = endOffset; prevOffset < offset; --offset) {
                int right = offset - this.rootBase;
                if (0 > this.lRoot[right]) continue;
                Position pos = positions.get(offset);
                for (int i = 0; i < pos.count; ++i) {
                    this.addNode(pos.backType[i], pos.backID[i], pos.backPos[i] - this.rootBase, right);
                }
            }
        }

        void markUnreachable() {
            for (int index = 1; index < this.rootSize - 1; ++index) {
                if (this.rRoot[index] >= 0) continue;
                int node = this.lRoot[index];
                while (0 <= node) {
                    this.nodeMark[node] = -1;
                    node = this.nodeLeftChain[node];
                }
            }
        }

        int connectionCost(ConnectionCosts costs, int left, int right) {
            int leftID = this.nodeLeftID[right];
            return leftID == 0 && !this.useEOS ? 0 : costs.get(this.nodeRightID[left], leftID);
        }

        void calcLeftCost(ConnectionCosts costs) {
            for (int index = 0; index < this.rootSize; ++index) {
                int node = this.lRoot[index];
                while (0 <= node) {
                    if (0 <= this.nodeMark[node]) {
                        int leastNode = -1;
                        int leastCost = Integer.MAX_VALUE;
                        int leftNode = this.rRoot[index];
                        while (0 <= leftNode) {
                            int cost;
                            if (0 <= this.nodeMark[leftNode] && (cost = this.nodeLeftCost[leftNode] + this.nodeWordCost[leftNode] + this.connectionCost(costs, leftNode, node)) < leastCost) {
                                leastCost = cost;
                                leastNode = leftNode;
                            }
                            leftNode = this.nodeRightChain[leftNode];
                        }
                        assert (0 <= leastNode);
                        this.nodeLeftNode[node] = leastNode;
                        this.nodeLeftCost[node] = leastCost;
                    }
                    node = this.nodeLeftChain[node];
                }
            }
        }

        void calcRightCost(ConnectionCosts costs) {
            for (int index = this.rootSize - 1; 0 <= index; --index) {
                int node = this.rRoot[index];
                while (0 <= node) {
                    if (0 <= this.nodeMark[node]) {
                        int leastNode = -1;
                        int leastCost = Integer.MAX_VALUE;
                        int rightNode = this.lRoot[index];
                        while (0 <= rightNode) {
                            int cost;
                            if (0 <= this.nodeMark[rightNode] && (cost = this.nodeRightCost[rightNode] + this.nodeWordCost[rightNode] + this.connectionCost(costs, node, rightNode)) < leastCost) {
                                leastCost = cost;
                                leastNode = rightNode;
                            }
                            rightNode = this.nodeLeftChain[rightNode];
                        }
                        assert (0 <= leastNode);
                        this.nodeRightNode[node] = leastNode;
                        this.nodeRightCost[node] = leastCost;
                    }
                    node = this.nodeRightChain[node];
                }
            }
        }

        void markSameSpanNode(int refNode, int value) {
            int left = this.nodeLeft[refNode];
            int right = this.nodeRight[refNode];
            int node = this.lRoot[left];
            while (0 <= node) {
                if (this.nodeRight[node] == right) {
                    this.nodeMark[node] = value;
                }
                node = this.nodeLeftChain[node];
            }
        }

        List<Integer> bestPathNodeList() {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int node = this.nodeRightNode[0];
            while (node != 1) {
                list.add(node);
                this.markSameSpanNode(node, 1);
                node = this.nodeRightNode[node];
            }
            return list;
        }

        private int cost(int node) {
            return this.nodeLeftCost[node] + this.nodeWordCost[node] + this.nodeRightCost[node];
        }

        List<Integer> nBestNodeList(int N) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int leastCost = Integer.MAX_VALUE;
            int leastLeft = -1;
            int leastRight = -1;
            for (int node = 2; node < this.nodeCount; ++node) {
                if (this.nodeMark[node] != 0) continue;
                int cost = this.cost(node);
                if (cost < leastCost) {
                    leastCost = cost;
                    leastLeft = this.nodeLeft[node];
                    leastRight = this.nodeRight[node];
                    list.clear();
                    list.add(node);
                    continue;
                }
                if (cost != leastCost || this.nodeLeft[node] == leastLeft && this.nodeRight[node] == leastRight) continue;
                list.add(node);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int node = (Integer)iterator.next();
                this.markSameSpanNode(node, N);
            }
            return list;
        }

        int bestCost() {
            return this.nodeLeftCost[1];
        }
    }

    static final class WrappedPositionArray {
        private Position[] positions = new Position[8];
        private int nextWrite;
        private int nextPos;
        private int count;

        public WrappedPositionArray() {
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = new Position();
            }
        }

        public void reset() {
            --this.nextWrite;
            while (this.count > 0) {
                if (this.nextWrite == -1) {
                    this.nextWrite = this.positions.length - 1;
                }
                this.positions[this.nextWrite--].reset();
                --this.count;
            }
            this.nextWrite = 0;
            this.nextPos = 0;
            this.count = 0;
        }

        public Position get(int pos) {
            while (pos >= this.nextPos) {
                if (this.count == this.positions.length) {
                    Position[] newPositions = new Position[ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    System.arraycopy(this.positions, this.nextWrite, newPositions, 0, this.positions.length - this.nextWrite);
                    System.arraycopy(this.positions, 0, newPositions, this.positions.length - this.nextWrite, this.nextWrite);
                    for (int i = this.positions.length; i < newPositions.length; ++i) {
                        newPositions[i] = new Position();
                    }
                    this.nextWrite = this.positions.length;
                    this.positions = newPositions;
                }
                if (this.nextWrite == this.positions.length) {
                    this.nextWrite = 0;
                }
                assert (this.positions[this.nextWrite].count == 0);
                ++this.nextWrite;
                ++this.nextPos;
                this.positions[this.nextWrite].pos = this.positions[this.nextWrite].pos;
                ++this.count;
            }
            assert (this.inBounds(pos));
            int index = this.getIndex(pos);
            assert (this.positions[index].pos == pos);
            return this.positions[index];
        }

        public int getNextPos() {
            return this.nextPos;
        }

        private boolean inBounds(int pos) {
            return pos < this.nextPos && pos >= this.nextPos - this.count;
        }

        private int getIndex(int pos) {
            int index = this.nextWrite - (this.nextPos - pos);
            if (index < 0) {
                index += this.positions.length;
            }
            return index;
        }

        public void freeBefore(int pos) {
            int toFree = this.count - (this.nextPos - pos);
            assert (toFree >= 0);
            assert (toFree <= this.count);
            int index = this.nextWrite - this.count;
            if (index < 0) {
                index += this.positions.length;
            }
            for (int i = 0; i < toFree; ++i) {
                if (index == this.positions.length) {
                    index = 0;
                }
                this.positions[index].reset();
                ++index;
            }
            this.count -= toFree;
        }
    }

    static final class Position {
        int pos;
        int count;
        int[] costs = new int[8];
        int[] lastRightID = new int[8];
        int[] backPos = new int[8];
        int[] backIndex = new int[8];
        int[] backID = new int[8];
        Type[] backType = new Type[8];
        int forwardCount;
        int[] forwardPos = new int[8];
        int[] forwardID = new int[8];
        int[] forwardIndex = new int[8];
        Type[] forwardType = new Type[8];

        Position() {
        }

        public void grow() {
            this.costs = ArrayUtil.grow(this.costs, 1 + this.count);
            this.lastRightID = ArrayUtil.grow(this.lastRightID, 1 + this.count);
            this.backPos = ArrayUtil.grow(this.backPos, 1 + this.count);
            this.backIndex = ArrayUtil.grow(this.backIndex, 1 + this.count);
            this.backID = ArrayUtil.grow(this.backID, 1 + this.count);
            Type[] newBackType = new Type[this.backID.length];
            System.arraycopy(this.backType, 0, newBackType, 0, this.backType.length);
            this.backType = newBackType;
        }

        public void growForward() {
            this.forwardPos = ArrayUtil.grow(this.forwardPos, 1 + this.forwardCount);
            this.forwardID = ArrayUtil.grow(this.forwardID, 1 + this.forwardCount);
            this.forwardIndex = ArrayUtil.grow(this.forwardIndex, 1 + this.forwardCount);
            Type[] newForwardType = new Type[this.forwardPos.length];
            System.arraycopy(this.forwardType, 0, newForwardType, 0, this.forwardType.length);
            this.forwardType = newForwardType;
        }

        public void add(int cost, int lastRightID, int backPos, int backIndex, int backID, Type backType) {
            if (this.count == this.costs.length) {
                this.grow();
            }
            this.costs[this.count] = cost;
            this.lastRightID[this.count] = lastRightID;
            this.backPos[this.count] = backPos;
            this.backIndex[this.count] = backIndex;
            this.backID[this.count] = backID;
            this.backType[this.count] = backType;
            ++this.count;
        }

        public void addForward(int forwardPos, int forwardIndex, int forwardID, Type forwardType) {
            if (this.forwardCount == this.forwardID.length) {
                this.growForward();
            }
            this.forwardPos[this.forwardCount] = forwardPos;
            this.forwardIndex[this.forwardCount] = forwardIndex;
            this.forwardID[this.forwardCount] = forwardID;
            this.forwardType[this.forwardCount] = forwardType;
            ++this.forwardCount;
        }

        public void reset() {
            this.count = 0;
            assert (this.forwardCount == 0) : "pos=" + this.pos + " forwardCount=" + this.forwardCount;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type KNOWN = new Type();
        public static final /* enum */ Type UNKNOWN = new Type();
        public static final /* enum */ Type USER = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        static {
            $VALUES = new Type[]{KNOWN, UNKNOWN, USER};
        }
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NORMAL = new Mode();
        public static final /* enum */ Mode SEARCH = new Mode();
        public static final /* enum */ Mode EXTENDED = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        static {
            $VALUES = new Mode[]{NORMAL, SEARCH, EXTENDED};
        }
    }
}

