/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.command.KtFilePos;
import com.whitemagicsoftware.keentype.command.KtSequenceTokenizer;
import com.whitemagicsoftware.keentype.command.KtTokenizer;
import com.whitemagicsoftware.keentype.io.KtInputLine;
import com.whitemagicsoftware.keentype.io.KtLineInput;

public class KtLineInputTokenizer
extends KtSequenceTokenizer {
    private final KtLineInput mLineInput;
    private final KtInputHandler mInputHandler;
    private final KtFileName mFileName;
    private boolean forceEOF;
    private boolean used;
    private int lineNum;

    public KtLineInputTokenizer(KtLineInput lineInput, KtInputHandler inputHandler, KtFileName fileName) {
        assert (lineInput != null);
        assert (inputHandler != null);
        assert (fileName != null);
        this.mLineInput = lineInput;
        this.mInputHandler = inputHandler;
        this.mFileName = fileName;
    }

    @Override
    public boolean close() {
        this.mLineInput.close();
        this.mInputHandler.closeInput();
        return true;
    }

    @Override
    public boolean endInput() {
        this.forceEOF = true;
        return true;
    }

    @Override
    public KtTokenizer nextTokenizer() {
        if (this.forceEOF) {
            return KtTokenizer.NULL;
        }
        KtInputLine line = this.mLineInput.readLine();
        this.lineNum = this.mLineInput.getLineNumber();
        if (line == KtLineInput.EOF) {
            if (this.used) {
                return KtTokenizer.NULL;
            }
            line = this.mInputHandler.emptyLine();
            this.lineNum = 1;
        }
        this.used = true;
        line = this.mInputHandler.confirmLine(line);
        return this.mInputHandler.makeTokenizer(line, "l." + this.lineNum + " ", true);
    }

    @Override
    public boolean enoughContext() {
        return true;
    }

    @Override
    public KtFilePos filePos() {
        return new KtFilePos(this.mFileName, this.lineNum);
    }

    public static interface KtInputHandler {
        public void closeInput();

        public KtInputLine emptyLine();

        public KtInputLine confirmLine(KtInputLine var1);

        public KtTokenizer makeTokenizer(KtInputLine var1, String var2, boolean var3);
    }
}

