/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.math;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtSimpleGroup;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.math.KtFormulaBuilder;
import com.whitemagicsoftware.keentype.math.KtMathBuilder;
import com.whitemagicsoftware.keentype.math.KtMathPrim;
import com.whitemagicsoftware.keentype.math.KtMathShiftToken;
import com.whitemagicsoftware.keentype.noad.KtConvStyle;
import com.whitemagicsoftware.keentype.noad.KtConversion;
import com.whitemagicsoftware.keentype.noad.KtDelimiter;
import com.whitemagicsoftware.keentype.noad.KtMathOffNode;
import com.whitemagicsoftware.keentype.noad.KtMathOnNode;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtMathWordBuilder;
import com.whitemagicsoftware.keentype.node.KtNamedHSkipNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtTreatNode;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;

public class KtFormulaGroup
extends KtSimpleGroup {
    protected KtMathBuilder builder;
    public static final int DIMP_MATH_SURROUND = KtFormulaGroup.newDimParam();
    public static final int INTP_DELIMITER_FACTOR = KtFormulaGroup.newIntParam();
    public static final int DIMP_NULL_DELIMITER_SPACE = KtFormulaGroup.newDimParam();
    public static final int DIMP_DELIMITER_SHORTFALL = KtFormulaGroup.newDimParam();
    public static final int DIMP_SCRIPT_SPACE = KtFormulaGroup.newDimParam();
    public static final byte TEXT_SIZE = 0;
    public static final byte SCRIPT_SIZE = 1;
    public static final byte SCRIPT_SCRIPT_SIZE = 2;
    public static final byte NUMBER_OF_FONT_SIZES = 3;

    protected KtFormulaGroup(KtMathBuilder builder) {
        this.builder = builder;
    }

    public KtFormulaGroup(KtFormulaBuilder builder) {
        this((KtMathBuilder)builder);
    }

    public KtFormulaGroup() {
        this(new KtFormulaBuilder(KtFormulaGroup.currLineNumber()));
    }

    @Override
    public void start() {
        KtBuilder.push(this.builder);
    }

    @Override
    public void stop() {
        KtBuilder.pop();
        KtDimen surr = KtFormulaGroup.getConfig().getDimParam(DIMP_MATH_SURROUND);
        KtBuilder bld = KtTypoCommand.getBld();
        bld.addNode(new KtMathOnNode(surr));
        if (KtFormulaGroup.necessaryParamsDefined()) {
            bld.addNodes(KtConversion.madeOf(this.builder.getList().noads(), new KtFormulaStyle(1, bld.willBeBroken())).nodes());
        }
        bld.addNode(new KtMathOffNode(surr));
        bld.resetSpaceFactor();
    }

    @Override
    public KtToken expectedToken() {
        return KtMathShiftToken.TOKEN;
    }

    public static boolean expectAnotherMathShift() {
        KtToken tok = KtFormulaGroup.nextExpToken();
        if (!KtFormulaGroup.meaningOf(tok).isMathShift()) {
            KtFormulaGroup.backToken(tok);
            KtFormulaGroup.error("BadFormulaEnd");
            return false;
        }
        return true;
    }

    private static boolean isScriptSize(byte size) {
        return size >= 1;
    }

    public static boolean necessaryParamsDefined() {
        if (!KtFormulaGroup.necessaryParamsDefined((byte)2, KtFontMetric.ALL_MATH_SYMBOL_DIMEN_PARAMS)) {
            KtFormulaGroup.error("InsufSymFonts");
            return false;
        }
        if (!KtFormulaGroup.necessaryParamsDefined((byte)3, KtFontMetric.ALL_MATH_EXTENSION_DIMEN_PARAMS)) {
            KtFormulaGroup.error("InsufExtFonts");
            return false;
        }
        return true;
    }

    public static boolean necessaryParamsDefined(byte fam, int[] idxs) {
        for (byte s = 0; s < 3; s = (byte)(s + 1)) {
            if (KtMathPrim.getMathConfig().familyFont(s, fam).definesDimenParams(idxs)) continue;
            return false;
        }
        return true;
    }

    protected static class KtFormulaStyle
    extends KtConvStyle {
        protected byte fontSize;
        protected final boolean penalties;

        protected KtFormulaStyle(byte style, boolean cramped, boolean penalties) {
            super(style, cramped);
            this.penalties = penalties;
        }

        public KtFormulaStyle(byte style, boolean penalties) {
            this(style, false, penalties);
        }

        @Override
        protected void setupFontSize() {
            switch (this.style) {
                case 3: {
                    this.fontSize = (byte)2;
                    break;
                }
                case 2: {
                    this.fontSize = 1;
                    break;
                }
                default: {
                    this.fontSize = 0;
                }
            }
        }

        @Override
        protected KtFontMetric fetchFontMetric(byte fam) {
            return KtMathPrim.getMathConfig().familyFont(this.fontSize, fam);
        }

        private void metricError(byte fam, KtCharCode code) {
            KtCommandBase.error("UndefFamily", KtCommandBase.esc(KtMathPrim.getMathConfig().familyName(this.fontSize, fam)), KtCommandBase.num(fam), code);
        }

        @Override
        public KtNode fetchCharNode(byte fam, KtCharCode code) {
            KtFontMetric metric = this.fetchFontMetric(fam);
            if (metric.isNull()) {
                this.metricError(fam, code);
                return KtNode.NULL;
            }
            KtNode node = metric.getCharNode(code);
            if (node == KtNode.NULL) {
                KtMathPrim.charWarning(metric, code);
            }
            return node;
        }

        @Override
        public KtNode fetchLargerNode(byte fam, KtCharCode code) {
            KtFontMetric metric = this.fetchFontMetric(fam);
            if (metric.isNull()) {
                this.metricError(fam, code);
                return KtNode.NULL;
            }
            KtNode node = metric.getLargerNode(code);
            if (node == KtNode.NULL) {
                KtMathPrim.charWarning(metric, code);
            }
            return node;
        }

        @Override
        public KtBox fetchFittingWidthBox(byte fam, KtCharCode code, KtDimen desired) {
            KtFontMetric metric = this.fetchFontMetric(fam);
            if (metric.isNull()) {
                this.metricError(fam, code);
                return KtBox.NULL;
            }
            KtBox box = metric.getFittingWidthBox(code, desired);
            if (box == KtBox.NULL) {
                KtMathPrim.charWarning(metric, code);
            }
            return box;
        }

        @Override
        public KtNode fetchSufficientNode(KtDelimiter delimiter, KtDimen desired) {
            KtDimen maxSize = KtDimen.ZERO;
            KtNode maxNode = KtNode.NULL;
            boolean large = false;
            byte fam = delimiter.getSmallFam();
            KtCharCode code = delimiter.getSmallCode();
            block0: while (true) {
                if (code != KtCharCode.NULL) {
                    for (byte s = this.fontSize; s >= 0; s = (byte)(s - 1)) {
                        KtDimen size;
                        KtFontMetric metric = KtMathPrim.getMathConfig().familyFont(s, fam);
                        KtNode node = metric.getSufficientNode(code, desired);
                        if (node == KtNode.NULL || !(size = node.getHeight().plus(node.getDepth())).moreThan(maxSize)) continue;
                        maxSize = size;
                        maxNode = node;
                        if (!size.lessThan(desired)) break block0;
                    }
                }
                if (large) break;
                large = true;
                fam = delimiter.getLargeFam();
                code = delimiter.getLargeCode();
            }
            return maxNode != KtNode.NULL ? maxNode : new KtHBoxNode(new KtBoxSizes(KtDimen.ZERO, KtCommandBase.getConfig().getDimParam(DIMP_NULL_DELIMITER_SPACE), KtDimen.ZERO, KtDimen.ZERO), KtGlueSetting.NATURAL, KtNodeList.EMPTY);
        }

        @Override
        public KtDimen getXHeight(byte fam) {
            return this.fetchFontMetric(fam).getDimenParam(4);
        }

        @Override
        public KtDimen skewAmount(byte fam, KtCharCode code) {
            KtDimen skew;
            KtCharCode skewCode;
            KtFontMetric metric = this.fetchFontMetric(fam);
            KtNum skewCharNum = metric.getNumParam(1);
            if (skewCharNum != KtNum.NULL && (skewCode = KtToken.makeCharCode(skewCharNum.intVal())) != KtCharCode.NULL && (skew = metric.getKernBetween(code, skewCode)) != KtDimen.NULL) {
                return skew;
            }
            return KtDimen.ZERO;
        }

        @Override
        public KtDimen delimiterSize(KtDimen height, KtDimen depth) {
            KtDimen max = height.max(depth);
            KtDimen size = max.over(500).times(KtCommandBase.getConfig().getIntParam(INTP_DELIMITER_FACTOR));
            max = max.times(2).minus(KtCommandBase.getConfig().getDimParam(DIMP_DELIMITER_SHORTFALL));
            return max.max(size);
        }

        @Override
        public KtDimen scriptSpace() {
            return KtCommandBase.getConfig().getDimParam(DIMP_SCRIPT_SPACE);
        }

        @Override
        public KtNode getSpacing(byte left, byte right) {
            KtMathPrim.KtMathSpacer spacer = KtMathPrim.getMathConfig().mathSpacing(left, right);
            KtGlue space = spacer.getGlue(this.fontSize);
            return space.isZero() ? KtNode.NULL : new KtNamedHSkipNode(this.muToPt(space), spacer.getName());
        }

        @Override
        public KtNum getPenalty(byte left, byte right) {
            return this.penalties ? KtMathPrim.getMathConfig().mathPenalty(left, right) : KtNum.NULL;
        }

        @Override
        public boolean isScript() {
            return KtFormulaGroup.isScriptSize(this.fontSize);
        }

        @Override
        public KtConvStyle makeNew(byte style) {
            return new KtFormulaStyle(style, false, this.penalties);
        }

        @Override
        protected KtConvStyle deriveNew(byte style, boolean cramped) {
            return new KtFormulaStyle(style, cramped, false);
        }

        @Override
        public KtMathWordBuilder getWordBuilder(byte fam, KtTreatNode proc) {
            KtFontMetric metric = this.fetchFontMetric(fam);
            return metric.isNull() ? KtMathWordBuilder.NULL : metric.getMathWordBuilder(proc);
        }

        @Override
        public boolean forcedItalCorr(byte fam) {
            return this.fetchFontMetric(fam).getDimenParam(1).isZero();
        }
    }
}

