/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.command.KtCtrlSeqToken;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.command.KtPrefixPrim;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.typo.KtNullFontMetric;
import com.whitemagicsoftware.keentype.typo.KtSetFont;
import com.whitemagicsoftware.keentype.typo.KtTypoAssignPrim;

public class KtFontPrim
extends KtTypoAssignPrim
implements KtTokenList.KtProvider {
    private static final KtName NAME_FONT = KtToken.makeName("FONT");

    public KtFontPrim(String name) {
        super(name);
    }

    @Override
    protected void assign(KtToken src, boolean glob) {
        KtFontPrim.ensureOpenLog();
        KtToken tok = KtPrefixPrim.definableToken();
        KtName ident = this.makeIdent(tok);
        tok.define(KtNullFontMetric.COMMAND, glob);
        KtFontPrim.skipOptEquals();
        boolean inpEnbl = KtFontPrim.getConfig().enableInput(false);
        KtFileName name = KtFontPrim.scanFileName();
        KtDimen size = this.scanSizeSpec();
        KtNum scale = size != KtDimen.NULL ? KtNum.NULL : this.scanScaleSpec();
        KtFontPrim.getConfig().enableInput(inpEnbl);
        KtFontMetric metric = KtFontPrim.getTypoHandler().getMetric(name, size, scale, ident, tok);
        if (metric != KtFontMetric.NULL) {
            tok.define(new KtSetFont(metric), glob);
        }
    }

    private KtName makeIdent(KtToken tok) {
        KtName ident = tok.controlName();
        if (ident == KtName.NULL) {
            KtCharCode code = tok.charCode();
            if (code != KtCharCode.NULL) {
                KtName.KtBuffer buf = new KtName.KtBuffer(NAME_FONT.length() + 1);
                buf.append(NAME_FONT).append(code);
                ident = buf.toName();
            }
        } else if (ident.length() == 0) {
            ident = NAME_FONT;
        }
        return ident;
    }

    private KtDimen scanSizeSpec() {
        KtDimen size = KtDimen.NULL;
        if (!(!KtFontPrim.scanKeyword("at") || (size = KtFontPrim.scanDimen()).moreThan(0) && size.lessThan(2048))) {
            KtFontPrim.error("ImproperAt", KtFontPrim.str(size));
            size = KtDimen.valueOf(10);
        }
        return size;
    }

    private KtNum scanScaleSpec() {
        KtNum scale = KtNum.NULL;
        if (KtFontPrim.scanKeyword("scaled") && (!(scale = KtFontPrim.scanNum()).moreThan(0) || scale.moreThan(32768))) {
            KtFontPrim.error("IllegalMag", KtFontPrim.str(scale));
            scale = KtNum.valueOf(1000);
        }
        return scale;
    }

    @Override
    public boolean hasFontTokenValue() {
        return true;
    }

    @Override
    public boolean hasFontMetricValue() {
        return true;
    }

    @Override
    public KtToken getFontTokenValue() {
        return new KtCtrlSeqToken(KtFontPrim.getCurrFontMetric().getIdent());
    }

    @Override
    public KtFontMetric getFontMetricValue() {
        return KtFontPrim.getCurrFontMetric();
    }
}

