/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.ReverseBytesReader;

class BytesStore
extends DataOutput {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesStore.class) + RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    private final List<byte[]> blocks = new ArrayList<byte[]>();
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private byte[] current;
    private int nextWrite;

    public BytesStore(int blockBits) {
        this.blockBits = blockBits;
        this.blockSize = 1 << blockBits;
        this.blockMask = this.blockSize - 1;
        this.nextWrite = this.blockSize;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int len) {
        while (len > 0) {
            int chunk = this.blockSize - this.nextWrite;
            if (len <= chunk) {
                assert (b != null);
                assert (this.current != null);
                System.arraycopy(b, offset, this.current, this.nextWrite, len);
                this.nextWrite += len;
                break;
            }
            if (chunk > 0) {
                System.arraycopy(b, offset, this.current, this.nextWrite, chunk);
                offset += chunk;
                len -= chunk;
            }
            this.current = new byte[this.blockSize];
            this.blocks.add(this.current);
            this.nextWrite = 0;
        }
    }

    @Override
    public void copyBytes(DataInput input, long numBytes) throws IOException {
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        assert (input != null);
        long len = numBytes;
        while (len > 0L) {
            int chunk = this.blockSize - this.nextWrite;
            int l = (int)Math.min((long)chunk, len);
            if (l > 0) {
                assert (this.current != null);
                input.readBytes(this.current, this.nextWrite, l);
                this.nextWrite += l;
                len -= (long)l;
                continue;
            }
            this.current = new byte[this.blockSize];
            this.blocks.add(this.current);
            this.nextWrite = 0;
        }
    }

    public FST.BytesReader getReverseReader() {
        return this.getReverseReader(true);
    }

    FST.BytesReader getReverseReader(boolean allowSingle) {
        if (allowSingle && this.blocks.size() == 1) {
            return new ReverseBytesReader(this.blocks.get(0));
        }
        return new FST.BytesReader(){
            private byte[] current;
            private int nextBuffer;
            private int nextRead;
            {
                this.current = BytesStore.this.blocks.size() == 0 ? null : BytesStore.this.blocks.get(0);
                this.nextBuffer = -1;
                this.nextRead = 0;
            }

            @Override
            public byte readByte() {
                if (this.nextRead == -1) {
                    this.current = BytesStore.this.blocks.get(this.nextBuffer--);
                    this.nextRead = BytesStore.this.blockSize - 1;
                }
                return this.current[this.nextRead--];
            }

            @Override
            public void skipBytes(long count) {
                this.setPosition(this.getPosition() - count);
            }

            @Override
            public void readBytes(byte[] b, int offset, int len) {
                for (int i = 0; i < len; ++i) {
                    b[offset + i] = this.readByte();
                }
            }

            @Override
            public long getPosition() {
                return ((long)this.nextBuffer + 1L) * (long)BytesStore.this.blockSize + (long)this.nextRead;
            }

            @Override
            public void setPosition(long pos) {
                int bufferIndex = (int)(pos >> BytesStore.this.blockBits);
                if (this.nextBuffer != bufferIndex - 1) {
                    this.nextBuffer = bufferIndex - 1;
                    this.current = BytesStore.this.blocks.get(bufferIndex);
                }
                this.nextRead = (int)(pos & (long)BytesStore.this.blockMask);
                assert (this.getPosition() == pos) : "pos=" + pos + " getPos()=" + this.getPosition();
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(numBlocks=" + this.blocks.size() + ")";
    }
}

