/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.asn1.x509;

import java.text.ParseException;
import java.util.Date;
import net.jsign.bouncycastle.asn1.ASN1Choice;
import net.jsign.bouncycastle.asn1.ASN1GeneralizedTime;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.ASN1Primitive;
import net.jsign.bouncycastle.asn1.ASN1UTCTime;

public class Time
extends ASN1Object
implements ASN1Choice {
    ASN1Primitive time;

    public Time(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UTCTime) && !(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            throw new IllegalArgumentException("unknown object passed to Time");
        }
        this.time = aSN1Primitive;
    }

    public static Time getInstance(Object object) {
        if (object == null || object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof ASN1UTCTime) {
            return new Time((ASN1UTCTime)object);
        }
        if (object instanceof ASN1GeneralizedTime) {
            return new Time((ASN1GeneralizedTime)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public String getTime() {
        if (this.time instanceof ASN1UTCTime) {
            return ((ASN1UTCTime)this.time).getAdjustedTime();
        }
        return ((ASN1GeneralizedTime)this.time).getTime();
    }

    public Date getDate() {
        try {
            if (this.time instanceof ASN1UTCTime) {
                return ((ASN1UTCTime)this.time).getAdjustedDate();
            }
            return ((ASN1GeneralizedTime)this.time).getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("invalid date string: " + parseException.getMessage());
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.time;
    }

    public String toString() {
        return this.getTime();
    }
}

