/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j;

import java.util.Map;
import java.util.TreeMap;
import net.jsign.log4j.Logger;
import net.jsign.log4j.internal.LogManagerStatus;
import net.jsign.log4j.simple.SimpleLoggerContextFactory;
import net.jsign.log4j.spi.LoggerContext;
import net.jsign.log4j.spi.LoggerContextFactory;
import net.jsign.log4j.spi.Provider;
import net.jsign.log4j.status.StatusLogger;
import net.jsign.log4j.util.LoaderUtil;
import net.jsign.log4j.util.PropertiesUtil;
import net.jsign.log4j.util.ProviderUtil;
import net.jsign.log4j.util.StackLocatorUtil;

public class LogManager {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String FQCN = LogManager.class.getName();
    private static volatile LoggerContextFactory factory;

    protected LogManager() {
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext) {
        try {
            return factory.getContext(FQCN, loader, null, currentContext);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, loader, null, currentContext);
        }
    }

    public static LoggerContextFactory getFactory() {
        return factory;
    }

    private static Class<?> callerClass(Class<?> clazz) {
        if (clazz != null) {
            return clazz;
        }
        Class<?> candidate = StackLocatorUtil.getCallerClass(3);
        if (candidate == null) {
            throw new UnsupportedOperationException("No class provided, and an appropriate one cannot be found.");
        }
        return candidate;
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> cls = LogManager.callerClass(clazz);
        return LogManager.getContext(cls.getClassLoader(), false).getLogger(cls);
    }

    static {
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        String factoryClassName = managerProps.getStringProperty("log4j2.loggerContextFactory");
        if (factoryClassName != null) {
            try {
                factory = LoaderUtil.newCheckedInstanceOf(factoryClassName, LoggerContextFactory.class);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.error("Unable to locate configured LoggerContextFactory {}", factoryClassName);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create configured LoggerContextFactory {}", factoryClassName, ex);
            }
        }
        if (factory == null) {
            TreeMap<Integer, LoggerContextFactory> factories = new TreeMap<Integer, LoggerContextFactory>();
            if (ProviderUtil.hasProviders()) {
                for (Provider provider : ProviderUtil.getProviders()) {
                    Class<? extends LoggerContextFactory> factoryClass = provider.loadLoggerContextFactory();
                    if (factoryClass == null) continue;
                    try {
                        factories.put(provider.getPriority(), factoryClass.newInstance());
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create class {} specified in provider URL {}", factoryClass.getName(), provider.getUrl(), e);
                    }
                }
                if (factories.isEmpty()) {
                    LOGGER.error("Log4j2 could not find a logging implementation. Please add log4j-core to the classpath. Using SimpleLogger to log to the console...");
                    factory = SimpleLoggerContextFactory.INSTANCE;
                } else if (factories.size() == 1) {
                    factory = (LoggerContextFactory)factories.get(factories.lastKey());
                } else {
                    StringBuilder sb = new StringBuilder("Multiple logging implementations found: \n");
                    for (Map.Entry entry : factories.entrySet()) {
                        sb.append("Factory: ").append(((LoggerContextFactory)entry.getValue()).getClass().getName());
                        sb.append(", Weighting: ").append(entry.getKey()).append('\n');
                    }
                    factory = (LoggerContextFactory)factories.get(factories.lastKey());
                    sb.append("Using factory: ").append(factory.getClass().getName());
                    LOGGER.warn(sb.toString());
                }
            } else {
                LOGGER.error("Log4j2 could not find a logging implementation. Please add log4j-core to the classpath. Using SimpleLogger to log to the console...");
                factory = SimpleLoggerContextFactory.INSTANCE;
            }
        }
        LogManagerStatus.setInitialized(true);
    }
}

