/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.align;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtIntPairKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class KtAlignSizesMatrix {
    private final Vector<KtDimen> diagonal;
    private final Map<KtIntPairKey, KtDimen> matrix = new HashMap<KtIntPairKey, KtDimen>(64);

    public KtAlignSizesMatrix(int initialSize) {
        this.diagonal = new Vector(initialSize);
    }

    public int size() {
        return this.diagonal.size();
    }

    public KtDimen get(int i) {
        return i < this.diagonal.size() ? this.diagonal.get(i) : KtDimen.NULL;
    }

    public KtDimen get(int i, int j) {
        return i != j ? this.matrix.get(new KtIntPairKey(i, j)) : this.get(i);
    }

    public KtDimen set(int i, int j, KtDimen value) {
        if (i != j) {
            return this.matrix.put(new KtIntPairKey(i, j), value);
        }
        if (i >= this.diagonal.size()) {
            this.diagonal.setSize(i + 1);
        }
        return this.diagonal.set(i, value);
    }

    public void setMax(int i, int j, KtDimen value) {
        if (i != j) {
            KtIntPairKey key = new KtIntPairKey(i, j);
            KtDimen old = this.matrix.get(key);
            if (old == KtDimen.NULL || value.moreThan(old)) {
                this.matrix.put(key, value);
            }
        } else if (i >= this.diagonal.size()) {
            this.diagonal.setSize(i + 1);
            this.diagonal.set(i, value);
        } else {
            KtDimen old = this.diagonal.get(i);
            if (old == KtDimen.NULL || value.moreThan(old)) {
                this.diagonal.set(i, value);
            }
        }
    }
}

