/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.base;

import com.whitemagicsoftware.keentype.base.KtBinFraction;
import com.whitemagicsoftware.keentype.base.KtBytePar;
import com.whitemagicsoftware.keentype.base.KtDimen;
import java.io.Serializable;

public class KtGlue
implements Serializable {
    public static final byte NORMAL = 0;
    public static final byte FIL = 1;
    public static final byte FILL = 2;
    public static final byte FILLL = 3;
    public static final byte MAX_ORDER = 3;
    public static final KtGlue NULL = null;
    public static final KtGlue ZERO = new KtGlue(KtDimen.ZERO, KtDimen.ZERO, 0, KtDimen.ZERO, 0);
    private final KtDimen dimen;
    private final KtDimen stretch;
    private final byte strOrder;
    private final KtDimen shrink;
    private final byte shrOrder;

    private KtGlue(KtDimen d, KtDimen p, byte po, KtDimen m, byte mo) {
        this.dimen = d;
        this.stretch = p;
        this.strOrder = po;
        this.shrink = m;
        this.shrOrder = mo;
    }

    public KtDimen getDimen() {
        return this.dimen;
    }

    public KtDimen getStretch() {
        return this.stretch;
    }

    public KtDimen getShrink() {
        return this.shrink;
    }

    public byte getStrOrder() {
        return this.strOrder;
    }

    public byte getShrOrder() {
        return this.shrOrder;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String unit) {
        StringBuffer buf = new StringBuffer(80);
        buf.append(this.dimen.toString());
        if (unit != null) {
            buf.append(unit);
        }
        if (!this.stretch.isZero()) {
            KtGlue.append(buf.append(" plus "), this.stretch, this.strOrder, unit);
        }
        if (!this.shrink.isZero()) {
            KtGlue.append(buf.append(" minus "), this.shrink, this.shrOrder, unit);
        }
        return buf.toString();
    }

    public static StringBuffer append(StringBuffer buf, KtDimen val, byte ord, String unit) {
        buf.append(val.toString());
        if (ord < 0 || ord > 3) {
            buf.append("foul");
        } else if (ord > 0) {
            buf.append("fil");
            while (true) {
                byte by = ord;
                ord = (byte)(ord - 1);
                if (by > 1) {
                    buf.append('l');
                    continue;
                }
                break;
            }
        } else if (unit != null) {
            buf.append(unit);
        }
        return buf;
    }

    public static String toString(KtDimen val, byte ord, String unit) {
        return KtGlue.append(new StringBuffer(30), val, ord, unit).toString();
    }

    public static String toString(KtDimen val, byte ord) {
        return KtGlue.toString(val, ord, null);
    }

    public static KtGlue valueOf(KtDimen d, KtDimen p, byte po, KtDimen m, byte mo) {
        if (p.isZero()) {
            po = 0;
        }
        if (m.isZero()) {
            mo = 0;
        }
        return new KtGlue(d, p, po, m, mo);
    }

    public static KtGlue valueOf(KtDimen d, KtDimen p, KtDimen m) {
        return new KtGlue(d, p, 0, m, 0);
    }

    public static KtGlue valueOf(KtDimen d) {
        return new KtGlue(d, KtDimen.ZERO, 0, KtDimen.ZERO, 0);
    }

    public boolean isZero() {
        return this.dimen.isZero() && this.stretch.isZero() && this.shrink.isZero();
    }

    public KtGlue negative() {
        return KtGlue.valueOf(this.dimen.negative(), this.stretch.negative(), this.strOrder, this.shrink.negative(), this.shrOrder);
    }

    private static KtDimen addParts(KtDimen x, KtDimen y, byte xo, KtBytePar yo) {
        if (x.isZero()) {
            xo = 0;
        }
        if (xo == yo.get()) {
            return x.plus(y);
        }
        if (xo < yo.get() && !y.isZero()) {
            return y;
        }
        yo.set(xo);
        return x;
    }

    public KtGlue plus(KtGlue g) {
        KtBytePar strO = new KtBytePar(g.strOrder);
        KtBytePar shrO = new KtBytePar(g.shrOrder);
        KtDimen str = KtGlue.addParts(this.stretch, g.stretch, this.strOrder, strO);
        KtDimen shr = KtGlue.addParts(this.shrink, g.shrink, this.shrOrder, shrO);
        return KtGlue.valueOf(this.dimen.plus(g.dimen), str, strO.get(), shr, shrO.get());
    }

    public KtGlue plus(KtDimen d) {
        return KtGlue.valueOf(this.dimen.plus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue plus(int num) {
        return KtGlue.valueOf(this.dimen.plus(num), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue plus(int num, int den) {
        return KtGlue.valueOf(this.dimen.plus(num, den), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue plus(KtBinFraction x) {
        return KtGlue.valueOf(this.dimen.plus(x), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue plus(double d) {
        return KtGlue.valueOf(this.dimen.plus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue minus(KtGlue g) {
        return this.plus(g.negative());
    }

    public KtGlue minus(KtDimen d) {
        return KtGlue.valueOf(this.dimen.minus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue minus(int num) {
        return KtGlue.valueOf(this.dimen.minus(num), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue minus(int num, int den) {
        return KtGlue.valueOf(this.dimen.minus(num, den), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue minus(KtBinFraction x) {
        return KtGlue.valueOf(this.dimen.minus(x), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue minus(double d) {
        return KtGlue.valueOf(this.dimen.minus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue times(KtDimen d) {
        return KtGlue.valueOf(this.dimen.times(d), this.stretch.times(d), this.strOrder, this.shrink.times(d), this.shrOrder);
    }

    public KtGlue times(int num) {
        return KtGlue.valueOf(this.dimen.times(num), this.stretch.times(num), this.strOrder, this.shrink.times(num), this.shrOrder);
    }

    public KtGlue times(int num, int den) {
        return KtGlue.valueOf(this.dimen.times(num, den), this.stretch.times(num, den), this.strOrder, this.shrink.times(num, den), this.shrOrder);
    }

    public KtGlue times(KtBinFraction x) {
        return KtGlue.valueOf(this.dimen.times(x), this.stretch.times(x), this.strOrder, this.shrink.times(x), this.shrOrder);
    }

    public KtGlue times(double d) {
        return KtGlue.valueOf(this.dimen.times(d), this.stretch.times(d), this.strOrder, this.shrink.times(d), this.shrOrder);
    }

    public KtGlue timesTheFinite(KtDimen d) {
        return KtGlue.valueOf(this.dimen.times(d), this.strOrder == 0 ? this.stretch.times(d) : this.stretch, this.strOrder, this.shrOrder == 0 ? this.shrink.times(d) : this.shrink, this.shrOrder);
    }

    public KtGlue over(KtDimen d) {
        return KtGlue.valueOf(this.dimen.over(d), this.stretch.over(d), this.strOrder, this.shrink.over(d), this.shrOrder);
    }

    public KtGlue over(int num) {
        return KtGlue.valueOf(this.dimen.over(num), this.stretch.over(num), this.strOrder, this.shrink.over(num), this.shrOrder);
    }

    public KtGlue over(int num, int den) {
        return KtGlue.valueOf(this.dimen.over(num, den), this.stretch.over(num, den), this.strOrder, this.shrink.over(num, den), this.shrOrder);
    }

    public KtGlue over(KtBinFraction x) {
        return KtGlue.valueOf(this.dimen.over(x), this.stretch.over(x), this.strOrder, this.shrink.over(x), this.shrOrder);
    }

    public KtGlue over(double d) {
        return KtGlue.valueOf(this.dimen.over(d), this.stretch.over(d), this.strOrder, this.shrink.over(d), this.shrOrder);
    }

    public KtGlue resizedCopy(KtDimen d) {
        return KtGlue.valueOf(d, this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public KtGlue withFiniteShrink() {
        return this.shrOrder == 0 ? this : KtGlue.valueOf(this.dimen, this.stretch, this.strOrder, this.shrink, (byte)0);
    }

    public static interface KtProvider {
        public KtGlue getGlueValue();
    }
}

