/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.command;

import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.command.KtContextDisplay;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenizer;
import com.whitemagicsoftware.keentype.io.KtLog;

public class KtBackedToken
extends KtTokenizer {
    private final KtToken token;
    private boolean readed = false;
    private final boolean expOK;

    public KtBackedToken(KtToken tok, boolean exp) {
        this.token = tok;
        this.expOK = exp;
    }

    @Override
    public KtToken nextToken(KtBoolPar canExpand) {
        canExpand.set(this.expOK);
        if (this.readed) {
            return KtToken.NULL;
        }
        this.readed = true;
        return this.token;
    }

    @Override
    public boolean finishedList() {
        return this.readed;
    }

    @Override
    public int show(KtContextDisplay disp, boolean force, int lines) {
        KtLog where;
        String desc;
        if (this.readed) {
            if (!force) {
                return 0;
            }
            desc = "<recently read> ";
            where = disp.left();
        } else {
            desc = "<to be read again> ";
            where = disp.right();
        }
        disp.normal().startLine().add(desc);
        if (!this.expOK) {
            where.addEsc("notexpanded: ");
        }
        this.token.addProperlyOn(where);
        disp.show();
        return 1;
    }
}

