/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public enum KtProtocolScheme {
    FILE,
    HTTP,
    FTP,
    JAR,
    UNKNOWN;


    public static KtProtocolScheme getProtocol(String uri) {
        try {
            return KtProtocolScheme.getProtocol(new URI(uri));
        }
        catch (Exception ex) {
            return uri.startsWith("//") ? HTTP : KtProtocolScheme.valueFrom(new File(uri));
        }
    }

    public static KtProtocolScheme getProtocol(URI uri) throws MalformedURLException {
        return uri.isAbsolute() ? KtProtocolScheme.valueFrom(uri) : KtProtocolScheme.valueFrom(uri.toURL());
    }

    public static KtProtocolScheme valueFrom(String protocol) {
        String sanitized = protocol == null ? "" : protocol.toUpperCase();
        for (KtProtocolScheme scheme : KtProtocolScheme.values()) {
            if (!sanitized.startsWith(scheme.name())) continue;
            return scheme;
        }
        return UNKNOWN;
    }

    public static KtProtocolScheme valueFrom(File file) {
        return KtProtocolScheme.valueFrom(file.toURI());
    }

    public static KtProtocolScheme valueFrom(URI uri) {
        try {
            return KtProtocolScheme.valueFrom(uri.toURL());
        }
        catch (Exception ex) {
            return UNKNOWN;
        }
    }

    public static KtProtocolScheme valueFrom(URL url) {
        return KtProtocolScheme.valueFrom(url.getProtocol());
    }

    public static boolean isRemote(URL url) {
        return KtProtocolScheme.valueFrom(url).isRemote();
    }

    public boolean isFile() {
        return this == FILE || this == JAR;
    }

    public boolean isHttp() {
        return this == HTTP;
    }

    public boolean isFtp() {
        return this == HTTP;
    }

    public boolean isRemote() {
        return this.isHttp() || this.isFtp();
    }

    public boolean isJar() {
        return this == JAR;
    }
}

