/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtLineOutput;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;

public class KtStandardLog
implements KtLog {
    protected final KtLineOutput mOut;
    protected final KtEscape mEsc;

    public KtStandardLog(KtLineOutput out, KtEscape esc) {
        this.mOut = out;
        this.mEsc = esc;
    }

    public final KtLineOutput getOutput() {
        return this.mOut;
    }

    @Override
    public final KtLog add(char ch) {
        this.mOut.add(ch);
        return this;
    }

    @Override
    public final KtLog add(char ch, int count) {
        while (count-- > 0) {
            this.mOut.add(ch);
        }
        return this;
    }

    @Override
    public final KtLog add(String str) {
        this.mOut.add(str);
        return this;
    }

    @Override
    public final KtLog add(KtCharCode code) {
        this.mOut.add(code);
        return this;
    }

    @Override
    public final KtLog endLine() {
        this.mOut.endLine();
        return this;
    }

    @Override
    public final KtLog startLine() {
        this.mOut.startLine();
        return this;
    }

    @Override
    public final KtLog flush() {
        this.mOut.flush();
        return this;
    }

    @Override
    public final void close() {
        this.mOut.close();
    }

    @Override
    public final KtLog add(boolean val) {
        return this.add(String.valueOf(val));
    }

    @Override
    public final KtLog add(int num) {
        return this.add(String.valueOf(num));
    }

    @Override
    public final KtLog addEsc() {
        KtCharCode escape = this.mEsc.getEscape();
        return escape != KtCharCode.NULL ? this.add(escape) : this;
    }

    @Override
    public final KtLog addEsc(String str) {
        this.addEsc();
        return this.add(str);
    }

    @Override
    public final KtLog add(KtLoggable x) {
        x.addOn(this);
        return this;
    }

    @Override
    public KtLog add(KtLoggable[] array) {
        return this.add(array, 0, array.length);
    }

    @Override
    public KtLog add(KtLoggable[] array, int offset, int length) {
        int i = 0;
        while (i < length) {
            this.add(array[offset + i++]);
        }
        return this;
    }

    @Override
    public final KtLog resetCount() {
        this.mOut.resetCount();
        return this;
    }

    @Override
    public final int getCount() {
        return this.mOut.getCount();
    }

    @Override
    public final KtLog voidCounter() {
        return new KtStandardLog(this.mOut.voidCounter(), this.mEsc);
    }

    @Override
    public final KtLog sepRoom(int count) {
        if (!this.mOut.stillFits(count)) {
            this.mOut.endLine();
        } else if (!this.mOut.isStartLine()) {
            this.mOut.add(' ');
        }
        return this;
    }

    public static interface KtEscape {
        public KtCharCode getEscape();
    }
}

