/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.noad.KtConverter;
import com.whitemagicsoftware.keentype.noad.KtDelimiter;
import com.whitemagicsoftware.keentype.noad.KtEgg;
import com.whitemagicsoftware.keentype.noad.KtField;
import com.whitemagicsoftware.keentype.noad.KtPureNoad;
import com.whitemagicsoftware.keentype.noad.KtStSimpleNodeEgg;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtIntVKernNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtVBoxNode;

public class KtFractionNoad
extends KtPureNoad {
    public static final KtFractionNoad NULL = null;
    protected final KtField numerator;
    protected final KtField denominator;
    protected final KtDimen thickness;

    public KtField getNumerator() {
        return this.numerator;
    }

    public KtField getDenominator() {
        return this.denominator;
    }

    public KtDimen getThickness() {
        return this.thickness;
    }

    public KtFractionNoad(KtField numerator, KtField denominator, KtDimen thickness) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.thickness = thickness;
    }

    public KtFractionNoad numerated(KtField numerator) {
        return new KtFractionNoad(numerator, this.denominator, this.thickness);
    }

    public KtFractionNoad denominated(KtField denominator) {
        return new KtFractionNoad(this.numerator, denominator, this.thickness);
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        log.addEsc(this.getDesc()).add(", thickness ");
        if (this.thickness == KtDimen.NULL) {
            log.add("= default");
        } else {
            log.add(this.thickness.toString());
        }
        this.addDelimitersOn(log);
        this.numerator.addOn(log, cntx, '\\');
        this.denominator.addOn(log, cntx, '/');
    }

    @Override
    public final boolean influencesBin() {
        return true;
    }

    protected String getDesc() {
        return "fraction";
    }

    protected void addDelimitersOn(KtLog log) {
    }

    public KtDelimiter getLeftDelimiter() {
        return KtDelimiter.VOID;
    }

    public KtDelimiter getRightDelimiter() {
        return KtDelimiter.VOID;
    }

    protected byte spacingType() {
        return 7;
    }

    @Override
    public KtEgg convert(KtConverter conv) {
        KtDimen denShift;
        KtDimen numShift;
        KtNode numNode = this.numerator.cleanBox(conv, (byte)4);
        KtNode denNode = this.denominator.cleanBox(conv, (byte)5);
        KtDimen width = numNode.getWidth().max(denNode.getWidth());
        numNode = numNode.reboxedToWidth(width);
        denNode = denNode.reboxedToWidth(width);
        KtDimen middle = conv.getDimPar(16);
        KtDimen drt = conv.getDimPar(17);
        KtDimen thick = this.thickness != KtDimen.NULL ? this.thickness : drt;
        boolean display = conv.getStyle() == 0;
        KtNodeList list = new KtNodeList(5);
        list.append(numNode);
        if (thick.isZero()) {
            KtDimen clr;
            if (display) {
                numShift = conv.getDimPar(2);
                denShift = conv.getDimPar(5);
                clr = drt.times(7);
            } else {
                numShift = conv.getDimPar(4);
                denShift = conv.getDimPar(6);
                clr = drt.times(3);
            }
            KtDimen delta = clr.minus(numShift.minus(numNode.getDepth()).minus(denNode.getHeight().minus(denShift))).halved();
            if (delta.moreThan(0)) {
                numShift = numShift.plus(delta);
                denShift = denShift.plus(delta);
            }
            list.append(new KtIntVKernNode(numShift.minus(numNode.getDepth()).minus(denNode.getHeight().minus(denShift))));
        } else {
            KtDimen clr;
            if (display) {
                numShift = conv.getDimPar(2);
                denShift = conv.getDimPar(5);
                clr = thick.times(3);
            } else {
                numShift = conv.getDimPar(3);
                denShift = conv.getDimPar(6);
                clr = thick;
            }
            KtDimen halfThick = thick.halved();
            KtDimen delta = clr.minus(numShift.minus(numNode.getDepth()).minus(middle.plus(halfThick)));
            if (delta.moreThan(0)) {
                numShift = numShift.plus(delta);
            }
            if ((delta = clr.minus(middle.minus(halfThick).minus(denNode.getHeight().minus(denShift)))).moreThan(0)) {
                denShift = denShift.plus(delta);
            }
            list.append(new KtIntVKernNode(numShift.minus(numNode.getDepth()).minus(middle.plus(halfThick)))).append(KtFractionNoad.makeRule(thick)).append(new KtIntVKernNode(middle.minus(halfThick).minus(denNode.getHeight().minus(denShift))));
        }
        list.append(denNode);
        KtVBoxNode fraction = new KtVBoxNode(new KtBoxSizes(numNode.getHeight().plus(numShift), width, denNode.getDepth().plus(denShift), numNode.getLeftX().max(denNode.getLeftX())), KtGlueSetting.NATURAL, list);
        KtDimen delSize = display ? conv.getDimPar(14) : conv.getDimPar(15);
        list = new KtNodeList(3);
        list.append(KtFractionNoad.varDelimiter(this.getLeftDelimiter(), delSize, conv)).append(fraction).append(KtFractionNoad.varDelimiter(this.getRightDelimiter(), delSize, conv));
        return new KtStSimpleNodeEgg(KtHBoxNode.packedOf(list), this.spacingType());
    }
}

