/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import java.io.Serializable;
import java.util.Vector;

public class KtNodeList
implements Serializable {
    public static final KtNodeList NULL = null;
    public static final KtNodeList EMPTY = new KtNodeList();
    public static final KtNodeEnum EMPTY_ENUM = new KtNodeEnum(){

        @Override
        public KtNode nextNode() {
            return KtNode.NULL;
        }

        @Override
        public boolean hasMoreNodes() {
            return false;
        }
    };
    protected Vector<KtNode> data;

    protected KtNodeList(Vector<KtNode> data) {
        this.data = data;
    }

    public KtNodeList() {
        this.data = new Vector();
    }

    public KtNodeList(int initCap) {
        this.data = new Vector(initCap);
    }

    public KtNodeList(int initCap, int capIncrement) {
        this.data = new Vector(initCap, capIncrement);
    }

    public KtNodeList(KtNode node) {
        this(1);
        this.append(node);
    }

    public KtNodeList(KtNodeEnum nodes) {
        this();
        this.append(nodes);
    }

    public KtNodeList(KtNode[] nodes) {
        this(nodes.length);
        this.append(nodes);
    }

    public KtNodeList(KtNode[] nodes, int offset, int count) {
        this(count);
        this.append(nodes, offset, count);
    }

    public final int length() {
        return this.data.size();
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected void clear() {
        this.data.clear();
    }

    public final KtNode nodeAt(int idx) {
        return this.data.elementAt(idx);
    }

    public KtNodeList append(KtNode node) {
        this.data.addElement(node);
        return this;
    }

    public KtNodeList append(KtNode[] nodes, int offset, int count) {
        this.data.ensureCapacity(this.data.size() + count);
        while (count-- > 0) {
            this.append(nodes[offset++]);
        }
        return this;
    }

    public KtNodeList append(KtNode[] nodes) {
        return this.append(nodes, 0, nodes.length);
    }

    public KtNodeList append(KtNodeEnum nodes) {
        while (nodes.hasMoreNodes()) {
            this.append(nodes.nextNode());
        }
        return this;
    }

    public KtNodeList append(KtNodeList list) {
        return this.append(list.nodes());
    }

    public KtNode lastNode() {
        return this.length() > 0 ? this.nodeAt(this.length() - 1) : KtNode.NULL;
    }

    public void removeLastNode() {
        if (this.length() > 0) {
            this.data.removeElementAt(this.length() - 1);
        }
    }

    public KtNode lastSpecialNode() {
        return this.lastNode();
    }

    public KtNode[] toArray() {
        KtNode[] nodes = new KtNode[this.data.size()];
        return this.data.toArray(nodes);
    }

    public KtNodeEnum nodes() {
        return new KtEnum(0, this.length());
    }

    public KtNodeEnum nodes(int start) {
        return new KtEnum(start, this.length());
    }

    public KtNodeEnum nodes(int start, int end) {
        return new KtEnum(start, end);
    }

    public static KtNodeEnum nodes(final KtNode node) {
        return new KtNodeEnum(){
            private boolean fresh = true;

            @Override
            public KtNode nextNode() {
                this.fresh = false;
                return node;
            }

            @Override
            public boolean hasMoreNodes() {
                return this.fresh;
            }
        };
    }

    public KtNodeList extractedMigrations() {
        int cnt = 0;
        int i = 0;
        while (i < this.length()) {
            if (!this.nodeAt(i++).isMigrating()) continue;
            ++cnt;
        }
        if (cnt > 0) {
            KtNodeList list = new KtNodeList();
            i = 0;
            while (i < this.length()) {
                KtNode node = this.nodeAt(i);
                if (node.isMigrating()) {
                    list.append(node.getMigration());
                    this.data.remove(i);
                    continue;
                }
                ++i;
            }
            return list;
        }
        return EMPTY;
    }

    public KtFontMetric addShortlyOn(KtLog log, KtFontMetric metric) {
        KtNodeEnum nodes = this.nodes();
        while (nodes.hasMoreNodes()) {
            metric = nodes.nextNode().addShortlyOn(log, metric);
        }
        return metric;
    }

    public KtFontMetric addShortlyOn(KtLog log) {
        return this.addShortlyOn(log, KtFontMetric.NULL);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        KtNodeEnum nodes = this.nodes();
        if (nodes.hasMoreNodes()) {
            buf.append(nodes.nextNode());
            while (nodes.hasMoreNodes()) {
                buf.append(", ").append(nodes.nextNode());
            }
        }
        return buf.toString();
    }

    private class KtEnum
    extends KtNodeEnum {
        private int idx;
        private final int end;

        public KtEnum(int idx, int end) {
            this.idx = idx;
            this.end = end;
        }

        @Override
        public KtNode nextNode() {
            return KtNodeList.this.nodeAt(this.idx++);
        }

        @Override
        public boolean hasMoreNodes() {
            return this.idx < this.end;
        }
    }
}

