/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.node.KtAnyShiftNode;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtSettingContext;
import com.whitemagicsoftware.keentype.node.KtTypesetter;

public class KtVShiftNode
extends KtAnyShiftNode {
    protected KtVShiftNode(KtNode node, KtDimen shift) {
        super(node, shift);
    }

    public static KtNode shiftingLeft(KtNode node, KtDimen shift) {
        return shift.isZero() ? node : new KtVShiftNode(node, shift.negative());
    }

    public static KtNode shiftingRight(KtNode node, KtDimen shift) {
        return shift.isZero() ? node : new KtVShiftNode(node, shift);
    }

    @Override
    public KtDimen getHeight() {
        return this.node.getHeight();
    }

    @Override
    public KtDimen getWidth() {
        return this.node.getWidth().plus(this.shift);
    }

    @Override
    public KtDimen getDepth() {
        return this.node.getDepth();
    }

    @Override
    public KtDimen getLeftX() {
        return KtDimen.ZERO;
    }

    @Override
    public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
        setter.moveRight(this.shift);
        this.node.typeSet(setter, sctx.shiftedLeft(this.shift));
        setter.moveLeft(this.shift);
    }

    @Override
    public KtDimen getHeight(KtGlueSetting setting) {
        return this.node.getHeight(setting);
    }

    @Override
    public KtDimen getWidth(KtGlueSetting setting) {
        return this.node.getWidth(setting).plus(this.shift);
    }

    @Override
    public KtDimen getDepth(KtGlueSetting setting) {
        return this.node.getDepth(setting);
    }

    @Override
    public KtDimen getLeftX(KtGlueSetting setting) {
        return this.node.getLeftX(setting).minus(this.shift);
    }

    public String toString() {
        return "VShift(" + String.valueOf(this.node) + "; " + String.valueOf(this.shift) + ")";
    }
}

