/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.render;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.node.KtTypesetter;
import com.whitemagicsoftware.keentype.render.KtCanvas;
import com.whitemagicsoftware.keentype.render.KtCodePointMapper;
import com.whitemagicsoftware.keentype.render.KtCoordinateStack;
import com.whitemagicsoftware.keentype.render.KtFontReader;
import com.whitemagicsoftware.keentype.tex.KtFontInfo;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public final class KtTurtle {
    private static final Map<KtFontInfo, Font> sFonts = new HashMap<KtFontInfo, Font>(32);
    private final KtFontReader mFontReader = new KtFontReader();
    private final KtCodePointMapper mCodePoints = new KtCodePointMapper();
    private KtDimen mSvgX;
    private KtDimen mSvgY;
    private KtDimen mTexX;
    private KtDimen mTexY;
    private final KtCanvas<?> mCanvas;

    public KtTurtle(KtDimen svgX, KtDimen svgY, KtDimen texX, KtDimen texY, KtCanvas<?> canvas) {
        this.setSvgX(svgX);
        this.setSvgY(svgY);
        this.setTexX(texX);
        this.setTexY(texY);
        this.mCanvas = canvas;
    }

    public void sync() {
        this.syncHorizontal();
        this.syncVertical();
    }

    public void syncHorizontal() {
        if (!this.mSvgX.equals(this.mTexX)) {
            this.setSvgX(this.mTexX);
        }
    }

    public void syncVertical() {
        if (!this.mSvgY.equals(this.mTexY)) {
            this.setSvgY(this.mTexY);
        }
    }

    public void font(KtFontInfo info) {
        this.mCodePoints.font(info);
        this.mCanvas.setFont(sFonts.computeIfAbsent(info, this.mFontReader::createFont));
    }

    public void draw(char ch) {
        this.sync();
        int mapped = this.mCodePoints.lookup(ch);
        this.mCanvas.drawString(Character.toString(mapped), this.mSvgX.toDouble(), this.mSvgY.toDouble());
    }

    public void drawRule(KtDimen w, KtDimen h) {
        double x = this.mSvgX.toDouble();
        double y = this.mSvgY.toDouble() - 0.2;
        this.mCanvas.drawLine(x, y, w.plus(x).toDouble(), y, (double)h.toInt() + 0.406);
    }

    public void left(KtDimen x) {
        this.setTexX(this.mTexX.minus(x));
    }

    public void right(KtDimen x) {
        this.setTexX(this.mTexX.plus(x));
    }

    public void up(KtDimen y) {
        this.setTexY(this.mTexY.minus(y));
    }

    public void down(KtDimen y) {
        this.setTexY(this.mTexY.plus(y));
    }

    public void advance(KtDimen w) {
        this.setSvgX(this.mSvgX.plus(w));
    }

    public void moveTexTo(KtDimen x, KtDimen y) {
        this.setTexX(x);
        this.setTexY(y);
    }

    public void moveSvgTo(KtDimen x, KtDimen y) {
        this.setSvgX(x);
        this.setSvgY(y);
    }

    public KtTypesetter.KtMark mark() {
        return new KtTypesetter.KtMark(){
            private final KtDimen mX;
            private final KtDimen mY;
            {
                this.mX = KtDimen.valueOf(KtTurtle.this.mTexX);
                this.mY = KtDimen.valueOf(KtTurtle.this.mTexY);
            }

            @Override
            public void move() {
                KtTurtle.this.moveTexTo(this.mX, this.mY);
            }

            @Override
            public KtDimen xDiff() {
                return KtTurtle.this.mTexX.minus(this.mX);
            }

            @Override
            public KtDimen yDiff() {
                return KtTurtle.this.mTexY.minus(this.mY);
            }
        };
    }

    public KtCoordinateStack stack(KtCoordinateStack stack) {
        return new KtCoordinateStack(this.mSvgX, this.mSvgY, stack);
    }

    public boolean isWidth(KtDimen width) {
        return this.mTexX.equals(this.mSvgX.plus(width));
    }

    private void setTexX(KtDimen x) {
        this.mTexX = x;
    }

    private void setTexY(KtDimen y) {
        this.mTexY = y;
    }

    private void setSvgX(KtDimen x) {
        this.mSvgX = x;
    }

    private void setSvgY(KtDimen y) {
        this.mSvgY = y;
    }
}

