/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tex;

import com.whitemagicsoftware.keentype.base.KtNum;
import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtInputLine;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.io.KtStandardLog;
import java.io.File;
import java.io.StringWriter;

public final class KtTeXCharMapper
implements KtCharCode.KtMaker,
KtInputLine.KtMapper,
KtStandardLog.KtEscape {
    private static KtConfig config;

    public static void setConfig(KtConfig conf) {
        config = conf;
    }

    private static KtCharCode forNum(int n) {
        return 0 <= n && n <= 255 ? new KtChar((char)n) : KtCharCode.NULL;
    }

    private static KtCharCode forNum(KtNum num) {
        return KtTeXCharMapper.forNum(num.intVal());
    }

    private static boolean matchNum(char code, int n) {
        return n <= 255 && n == code;
    }

    private static boolean matchNum(char code, KtNum num) {
        return KtTeXCharMapper.matchNum(code, num.intVal());
    }

    private static void putExpCodes(char chr, KtCharCode.KtCodeWriter out) {
        KtTeXCharMapper.writeCode('^', out);
        KtTeXCharMapper.writeCode('^', out);
        if (chr < '@') {
            KtTeXCharMapper.writeCode((char)(chr + 64), out);
        } else if (chr < '\u0080') {
            KtTeXCharMapper.writeCode((char)(chr - 64), out);
        } else {
            KtTeXCharMapper.writeCode(KtTeXCharMapper.lcHexDig(chr >> 4 & 0xF), out);
            KtTeXCharMapper.writeCode(KtTeXCharMapper.lcHexDig(chr & 0xF), out);
        }
    }

    private static void putExpChars(char chr, KtCharCode.KtCharWriter out) {
        out.writeChar('^');
        out.writeChar('^');
        if (chr < '@') {
            out.writeChar((char)(chr + 64));
        } else if (chr < '\u0080') {
            out.writeChar((char)(chr - 64));
        } else {
            out.writeChar(KtTeXCharMapper.lcHexDig(chr >> 4 & 0xF));
            out.writeChar(KtTeXCharMapper.lcHexDig(chr & 0xF));
        }
    }

    private static boolean isPrintable(char chr) {
        return chr >= ' ' && chr < '\u007f' || chr > '\u00a0';
    }

    private static void writeCode(char chr, KtCharCode.KtCodeWriter out) {
        out.writeCode(new KtChar(chr));
    }

    private static char lcHexDig(int d) {
        return (char)(d < 10 ? 48 + d : 97 + d - 10);
    }

    public KtTeXCharMapper() {
        KtToken.setCharCodeMaker(this);
    }

    @Override
    public KtCharCode make(char chr) {
        return new KtChar(chr);
    }

    @Override
    public KtCharCode make(int num) {
        return KtTeXCharMapper.forNum(num);
    }

    @Override
    public KtCharCode getEscape() {
        return KtTeXCharMapper.forNum(config.escapeNumCode());
    }

    @Override
    public boolean isNewLine(char chr) {
        return KtTeXCharMapper.matchNum(chr, config.newLineNumCode());
    }

    @Override
    public void writeExpCodes(char chr, KtCharCode.KtCodeWriter out) {
        if (KtTeXCharMapper.isPrintable(chr)) {
            KtTeXCharMapper.writeCode(chr, out);
        } else {
            KtTeXCharMapper.putExpCodes(chr, out);
        }
    }

    @Override
    public void writeExpChars(char chr, KtCharCode.KtCharWriter out) {
        if (KtTeXCharMapper.isPrintable(chr)) {
            out.writeChar(chr);
        } else {
            KtTeXCharMapper.putExpChars(chr, out);
        }
    }

    @Override
    public KtCharCode map(char chr) {
        return new KtChar(chr);
    }

    @Override
    public KtCharCode map(int num) {
        return KtTeXCharMapper.forNum(num);
    }

    @Override
    public KtCharCode endLine() {
        return KtTeXCharMapper.forNum(config.endLineNumCode());
    }

    @Override
    public boolean ignoreTrailing(char chr) {
        return chr == ' ' || chr == '\t';
    }

    public static interface KtConfig {
        public int catCode(int var1);

        public int lcNumCode(int var1);

        public int ucNumCode(int var1);

        public int spaceFactor(int var1);

        public int mathCode(int var1);

        public int delCode(int var1);

        public int escapeNumCode();

        public int newLineNumCode();

        public int endLineNumCode();
    }

    private static final class KtChar
    implements KtCharCode {
        private final char code;

        public KtChar(char chr) {
            this.code = chr;
        }

        @Override
        public char toChar() {
            return this.code <= '\u00ff' ? (char)this.code : (char)'\uffff';
        }

        @Override
        public char toCanonicalLetter() {
            int n = config.lcNumCode(this.code);
            return 0 < n && n <= 255 ? (char)n : (char)'\uffff';
        }

        @Override
        public int numValue() {
            return this.code <= '\u00ff' ? (int)this.code : -1;
        }

        @Override
        public boolean match(KtCharCode x) {
            return x.match(this.code);
        }

        @Override
        public boolean match(char c) {
            return c == this.code;
        }

        @Override
        public boolean match(int n) {
            return KtTeXCharMapper.matchNum(this.code, n);
        }

        @Override
        public boolean match(KtNum num) {
            return KtTeXCharMapper.matchNum(this.code, num);
        }

        @Override
        public KtCharCode toLowerCase() {
            int n = config.lcNumCode(this.code);
            return 0 < n && n <= 255 ? new KtChar((char)n) : this;
        }

        @Override
        public KtCharCode toUpperCase() {
            int n = config.ucNumCode(this.code);
            return 0 < n && n <= 255 ? new KtChar((char)n) : this;
        }

        @Override
        public int spaceFactor() {
            return config.spaceFactor(this.code);
        }

        @Override
        public int mathCode() {
            return config.mathCode(this.code);
        }

        @Override
        public int delCode() {
            return config.delCode(this.code);
        }

        @Override
        public boolean isEscape() {
            return config.catCode(this.code) == 0;
        }

        @Override
        public boolean startsExpand() {
            return config.catCode(this.code) == 7;
        }

        @Override
        public boolean isLetter() {
            return config.catCode(this.code) == 11;
        }

        @Override
        public boolean isEndLine() {
            return this.match(config.endLineNumCode());
        }

        @Override
        public boolean isNewLine() {
            return this.match(config.newLineNumCode());
        }

        @Override
        public boolean startsFileExt() {
            return this.code == '.';
        }

        @Override
        public void writeExpCodes(KtCharCode.KtCodeWriter out) {
            if (KtTeXCharMapper.isPrintable(this.code)) {
                out.writeCode(this);
            } else {
                KtTeXCharMapper.putExpCodes(this.code, out);
            }
        }

        @Override
        public void writeExpChars(KtCharCode.KtCharWriter out) {
            if (KtTeXCharMapper.isPrintable(this.code)) {
                out.writeChar(this.code);
            } else {
                KtTeXCharMapper.putExpChars(this.code, out);
            }
        }

        @Override
        public void writeRawChars(KtCharCode.KtCharWriter out) {
            out.writeChar(this.code);
        }

        @Override
        public void addOn(KtLog log) {
            log.add(this);
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object o) {
            return o instanceof KtCharCode && ((KtCharCode)o).match(this.code);
        }

        public String toString() {
            return String.valueOf(this.code);
        }
    }

    public static class KtTeXFileName
    implements KtFileName {
        private final KtName.KtBuffer data = new KtName.KtBuffer();

        public KtTeXFileName() {
        }

        public KtTeXFileName(String name) {
            this.setPath(name);
        }

        public KtTeXFileName(KtName name) {
            this.data.append(name);
        }

        @Override
        public int accept(KtCharCode code) {
            if (code.toChar() == '\uffff') {
                return -1;
            }
            if (code.match(' ')) {
                return 0;
            }
            this.data.append(code);
            return 1;
        }

        @Override
        public String getPath() {
            StringWriter out = new StringWriter();
            for (int i = 0; i < this.data.length(); ++i) {
                KtCharCode code = this.data.codeAt(i);
                if (!(code instanceof KtChar)) continue;
                out.write(((KtChar)code).code);
            }
            return out.toString();
        }

        @Override
        public void setPath(String path) {
            this.data.clear();
            this.append(path);
        }

        @Override
        public KtName baseName() {
            int beg = this.indexOfName();
            int end = this.indexOfExt(beg);
            KtCharCode[] codes = new KtCharCode[end - beg];
            this.data.getCodes(beg, end, codes, 0);
            return new KtName(codes);
        }

        @Override
        public void addDefaultExt(String ext) {
            int i = this.indexOfExt(this.indexOfName());
            if (i < this.data.length()) {
                return;
            }
            this.data.append(new KtChar('.'));
            this.append(ext);
        }

        @Override
        public void append(char chr) {
            this.data.append(new KtChar(chr));
        }

        @Override
        public void append(String str) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                this.append(str.charAt(i));
            }
        }

        private int indexOfName() {
            String path = this.getPath();
            String name = new File(path).getName();
            int i = path.lastIndexOf(name);
            return Math.max(i, 0);
        }

        private int indexOfExt(int start) {
            int i = this.data.length();
            while (--i > start) {
                if (!this.data.codeAt(i).startsFileExt()) continue;
                return i;
            }
            return this.data.length();
        }

        @Override
        public KtFileName copy() {
            return new KtTeXFileName(this.data.toName());
        }

        @Override
        public void addOn(KtLog log) {
            log.add(this.data.toName());
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof KtTeXFileName && this.data.equals(((KtTeXFileName)o).data);
        }

        public String toString() {
            return this.getPath();
        }
    }
}

