/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.builder.KtHBoxBuilder;
import com.whitemagicsoftware.keentype.command.KtSimpleGroup;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.node.KtDiscretionaryNode;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.typo.KtAction;
import com.whitemagicsoftware.keentype.typo.KtBuilderPrim;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;

public class KtDiscretionaryPrim
extends KtBuilderPrim {
    public final KtAction NORMAL = new KtAction(){

        @Override
        public void exec(KtBuilder bld, KtToken src) {
            bld.addNode(KtDiscretionaryNode.EMPTY);
            1.pushLevel(new KtDiscGroup());
        }
    };

    public KtDiscretionaryPrim(String name) {
        super(name);
    }

    public class KtDiscGroup
    extends KtSimpleGroup {
        private final KtNodeList[] lists = new KtNodeList[3];
        private KtHBoxBuilder builder;
        private int index = 0;

        public KtDiscGroup() {
            this.lists[1] = this.lists[2] = KtNodeList.EMPTY;
            this.lists[0] = this.lists[2];
        }

        @Override
        public void start() {
            this.builder = new KtHBoxBuilder(KtDiscGroup.currLineNumber());
            KtBuilder.push(this.builder);
            KtDiscGroup.scanLeftBrace();
        }

        @Override
        public void close() {
            KtBuilder.pop();
            KtNodeList list = this.builder.getList();
            for (int i = 0; i < list.length(); ++i) {
                if (list.nodeAt(i).canBePartOfDiscretionary()) continue;
                KtDiscGroup.error("ImproperDisc");
                KtTypoCommand.addItemsOnDiagLog("The following discretionary sublist has been deleted:", list.nodes(i));
                list = new KtNodeList(list.nodes(0, i));
                break;
            }
            this.lists[this.index] = list;
            KtBuilder bld = KtTypoCommand.getBld();
            if (++this.index < this.lists.length) {
                KtDiscGroup.pushLevel(this);
            } else if (bld.forbidsThirdPartOfDiscretionary() && !list.isEmpty()) {
                KtDiscGroup.error("IllegalMathDisc", KtDiscretionaryPrim.this);
                this.lists[this.index - 1] = KtNodeList.EMPTY;
            } else if (list.length() > 255) {
                KtDiscGroup.error("TooLongDisc");
                bld.removeLastNode();
                bld.addNode(new KtDiscretionaryNode(this.lists[0], this.lists[1], KtNodeList.EMPTY));
                bld.addNodes(list.nodes());
                return;
            }
            bld.removeLastNode();
            bld.addNode(new KtDiscretionaryNode(this.lists[0], this.lists[1], this.lists[2]));
        }
    }
}

