/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.align;

import com.whitemagicsoftware.keentype.align.KtAlignSizesMatrix;
import com.whitemagicsoftware.keentype.align.KtAnyUnsetNode;
import com.whitemagicsoftware.keentype.align.KtPreamble;
import com.whitemagicsoftware.keentype.align.KtPreambleScanning;
import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.base.KtGlue;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtBraceNesting;
import com.whitemagicsoftware.keentype.command.KtClosing;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtCommandBase;
import com.whitemagicsoftware.keentype.command.KtGroup;
import com.whitemagicsoftware.keentype.command.KtInpTokChecker;
import com.whitemagicsoftware.keentype.command.KtInsertedTokenList;
import com.whitemagicsoftware.keentype.command.KtSimpleGroup;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.node.KtAnyBoxNode;
import com.whitemagicsoftware.keentype.node.KtAnySkipNode;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtRuleNode;
import com.whitemagicsoftware.keentype.node.KtSizesEvaluator;
import com.whitemagicsoftware.keentype.node.KtVShiftNode;
import com.whitemagicsoftware.keentype.typo.KtParagraph;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class KtAlignment
extends KtCommandBase {
    public static final KtAlignment NULL = null;
    protected final KtDimen desired;
    protected final boolean exactly;
    protected final KtTokenList.KtInserter everyCr;
    protected final KtToken frozenCr;
    protected final KtToken frozenEndTemplate;
    protected KtPreamble preamble;
    protected KtAlignSizesMatrix maxSizes;
    protected int currColumn;
    protected int currSpan;
    public static final int GLUEP_TAB_SKIP = KtAlignment.newGlueParam();
    public static final KtColumnEnding SPAN_ENDING = new KtColumnEnding("SPAN_ENDING");
    public static final KtColumnEnding TAB_ENDING = new KtColumnEnding("TAB_ENDING");
    public static final KtColumnEnding CR_ENDING = new KtColumnEnding("CR_ENDING");
    public static final KtColumnEnding NULL_ENDING = null;
    protected KtColumnBraceNesting columnBalance = NULL_COLUMN_NESTING;
    protected KtBraceNesting savedColumnNesting;
    protected boolean insertTemplate;
    protected KtColumnEnding columnEnding = NULL_ENDING;
    public static final int NOALIGN_DISBALANCE = 1000000;
    protected static final KtColumnBraceNesting NULL_COLUMN_NESTING = null;
    private static KtAlignment top = NULL;
    private KtAlignment next = NULL;
    public static KtClosing CLOSE_COLUMN = new KtClosing(){

        @Override
        public void exec(KtGroup grp, KtToken src) {
            KtParagraph.finish();
            KtAlignment.checkTop();
            top.finishColumn();
        }
    };
    public static KtClosing MISSING_CR = new KtClosing(){

        @Override
        public void exec(KtGroup grp, KtToken src) {
            2.backToken(src);
            KtAlignment.checkTop();
            2.insertToken(KtAlignment.top.frozenCr);
            2.error("MissingCr", KtAlignment.top.frozenCr);
        }
    };

    public KtAlignment(KtDimen desired, boolean exactly, KtTokenList.KtInserter everyCr, KtToken frzCr, KtToken frzEndt) {
        this.desired = desired;
        this.exactly = exactly;
        this.everyCr = everyCr;
        this.frozenCr = frzCr;
        this.frozenEndTemplate = frzEndt;
    }

    public void start(KtToken src) {
        this.push();
        this.preamble = this.scanPreamble(src);
        this.maxSizes = new KtAlignSizesMatrix(this.preamble.length());
        this.everyCr.insertToks();
        this.nextRow();
    }

    protected KtPreamble scanPreamble(KtToken src) {
        KtCommandBase.KtConfig cfg = KtAlignment.getConfig();
        KtPreambleScanning scan = new KtPreambleScanning(src, this.frozenCr);
        KtInpTokChecker savedChk = KtAlignment.setTokenChecker(scan);
        KtBraceNesting savedBrn = KtAlignment.setBraceNesting(scan);
        boolean afterAssign = cfg.enableAfterAssignment(false);
        KtGlue firstSkip = cfg.getGlueParam(GLUEP_TAB_SKIP);
        String skipName = cfg.getGlueName(GLUEP_TAB_SKIP);
        while (this.scanRecord(scan)) {
        }
        KtAlignment.setBraceNesting(savedBrn);
        KtAlignment.setTokenChecker(savedChk);
        cfg.enableAfterAssignment(afterAssign);
        return scan.toPreamble(firstSkip, skipName, this.frozenEndTemplate);
    }

    protected boolean scanRecord(KtPreambleScanning scan) {
        KtToken tok;
        KtCommand cmd;
        boolean fresh = true;
        while (!(cmd = KtAlignment.meaningOf(tok = this.getPreambleToken())).isMacroParam()) {
            if (scan.balanced() && (cmd.isTabMark() || cmd.isCarRet())) {
                if (fresh && cmd.isTabMark() && scan.setLoopIndex()) continue;
                KtAlignment.backToken(tok);
                KtAlignment.error("MissingSharp");
                break;
            }
            if (fresh && cmd.isSpacer()) continue;
            scan.append(tok);
            fresh = false;
        }
        scan.finishHalf();
        while (true) {
            tok = this.getPreambleToken();
            cmd = KtAlignment.meaningOf(tok);
            if (scan.balanced() && (cmd.isTabMark() || cmd.isCarRet())) break;
            if (cmd.isMacroParam()) {
                KtAlignment.error("SecondSharpInTab");
                continue;
            }
            scan.append(tok);
        }
        scan.append(this.frozenEndTemplate);
        scan.finishRecord(KtAlignment.getConfig().getGlueParam(GLUEP_TAB_SKIP));
        return !cmd.isCarRet();
    }

    protected KtToken getPreambleToken() {
        KtToken tok;
        while (true) {
            tok = KtAlignment.nextRawToken();
            while (KtAlignment.meaningOf(tok).isSpan()) {
                tok = KtAlignment.nextExpToken();
            }
            KtCommand cmd = KtAlignment.meaningOf(tok);
            if (!cmd.isTabSkip()) break;
            cmd.exec(tok);
        }
        return tok;
    }

    protected void nextRow() {
        KtToken tok;
        KtCommand cmd;
        while ((cmd = KtAlignment.meaningOf(tok = KtAlignment.nextExpNonSpacer())).isCrCr()) {
        }
        if (cmd.isNoAlign()) {
            this.startNonAligned();
        } else if (cmd.isRightBrace()) {
            this.stop();
        } else {
            this.pushNewRowBuilder();
            this.addNamedSkipToRow(this.preamble.firstSkip, this.preamble.skipName);
            this.startSpan(0);
            this.currColumn = 0;
            this.startColumn(tok, cmd);
        }
    }

    protected void startNonAligned() {
        KtAlignment.scanLeftBrace();
        KtAlignment.pushLevel(new KtNoAlignGroup());
    }

    protected void startSpan(int index) {
        KtAlignment.pushLevel(new KtSpanGroup());
        this.pushNewSpanBuilder();
        this.currSpan = index;
    }

    protected void startColumn(KtToken tok, KtCommand cmd) {
        if (cmd.isOmit()) {
            this.startColumnBody(false);
        } else {
            KtAlignment.backToken(tok);
            KtAlignment.getTokStack().push(new KtTemplateTokenizer(this.preamble.getUPart(this.currColumn)));
        }
    }

    protected boolean balancedColumn() {
        return this.columnBalance != NULL_COLUMN_NESTING && this.columnBalance.balanced();
    }

    protected int columnDisbalance() {
        return this.columnBalance != NULL_COLUMN_NESTING ? this.columnBalance.disbalance() : 1000000;
    }

    protected void startColumnBody(boolean insert) {
        this.columnBalance = new KtColumnBraceNesting();
        this.savedColumnNesting = KtAlignment.setBraceNesting(this.columnBalance);
        this.insertTemplate = insert;
    }

    protected void finishColumnBody(KtColumnEnding ending) {
        if (this.columnBalance == NULL_COLUMN_NESTING) {
            throw new RuntimeException("no column scanned");
        }
        KtAlignment.setBraceNesting(this.savedColumnNesting);
        this.savedColumnNesting = KtBraceNesting.NULL;
        this.columnBalance = NULL_COLUMN_NESTING;
        if (this.insertTemplate) {
            KtAlignment.pushList(this.preamble.getVPart(this.currColumn), "template");
        } else {
            KtAlignment.pushToken(this.preamble.endTemplate, "template");
        }
        this.columnEnding = ending;
    }

    protected void finishColumn() {
        if (this.columnEnding == NULL_ENDING) {
            throw new RuntimeException("column body not started and finished");
        }
        if (this.columnEnding != CR_ENDING && !this.preamble.hasRecord(this.currColumn + 1)) {
            KtAlignment.error("ExtraAlignTab", this.frozenCr);
            this.columnEnding = CR_ENDING;
        }
        if (this.columnEnding != SPAN_ENDING) {
            KtAlignment.popLevel();
            this.maxSizes.setMax(this.currSpan, this.currColumn, this.packedSpanSize(this.currColumn - this.currSpan));
            this.addNamedSkipToRow(this.preamble.getSkip(this.currColumn), this.preamble.skipName);
            if (this.columnEnding == CR_ENDING) {
                this.packRow();
                this.everyCr.insertToks();
                this.nextRow();
                return;
            }
            this.startSpan(this.currColumn + 1);
        }
        KtToken tok = KtAlignment.nextExpNonSpacer();
        KtCommand cmd = KtAlignment.meaningOf(tok);
        ++this.currColumn;
        this.startColumn(tok, cmd);
        this.columnEnding = NULL_ENDING;
    }

    protected void stop() {
        KtBuilder.pop();
        KtAlignment.popLevel();
    }

    public KtNodeEnum finish(KtDimen indent) {
        KtAlignment.pop();
        this.calculateWidths();
        return this.setAndTransform(indent).nodes();
    }

    protected void calculateWidths() {
        int k = 0;
        int i = 1;
        while (i < this.maxSizes.size()) {
            KtDimen tw = this.maxSizes.get(k);
            tw = tw == KtDimen.NULL ? KtDimen.ZERO : tw.plus(this.preamble.getSkip(k).getDimen());
            for (int j = i; j < this.maxSizes.size(); ++j) {
                KtDimen w = this.maxSizes.get(k, j);
                if (w == KtDimen.NULL) continue;
                this.maxSizes.setMax(i, j, w.minus(tw));
            }
            k = i++;
        }
    }

    protected KtNodeList setAndTransform(KtDimen indent) {
        KtSizesEvaluator pack = new KtSizesEvaluator();
        pack.add(this.preamble.firstSkip);
        for (int i = 0; i < this.maxSizes.size(); ++i) {
            KtDimen w = this.maxSizes.get(i);
            if (w == KtDimen.NULL) continue;
            pack.add(w);
            pack.add(this.preamble.getSkip(i));
        }
        KtDimen size = pack.getBody();
        if (this.exactly) {
            pack.evaluate(this.desired.minus(size), false);
            size = this.desired;
        } else {
            pack.evaluate(this.desired, false);
            size = size.plus(this.desired);
        }
        this.check(pack, size);
        return this.transform(size, pack.getSetting(), indent);
    }

    protected KtNodeList transform(KtDimen size, KtGlueSetting setting, KtDimen indent) {
        KtBoxSizes around = this.transformSizes(KtBoxSizes.ZERO, size);
        KtNodeList list = new KtNodeList();
        KtNodeEnum nodes = this.getUnsetNodes();
        while (nodes.hasMoreNodes()) {
            KtNode node = nodes.nextNode();
            if (node instanceof KtAnyUnsetNode) {
                node = this.transform((KtAnyUnsetNode)node, size, setting, indent);
            } else if (node instanceof KtRuleNode) {
                KtBoxSizes full;
                KtBoxSizes sizes = ((KtRuleNode)node).getSizes();
                if (!sizes.equals(full = sizes.replenished(around))) {
                    node = new KtRuleNode(full);
                }
                if (!indent.isZero()) {
                    node = KtHBoxNode.packedOf(node);
                    node = KtVShiftNode.shiftingRight(node, indent);
                }
            }
            list.append(node);
        }
        return list;
    }

    protected KtNode transform(KtAnyUnsetNode row, KtDimen size, KtGlueSetting setting, KtDimen indent) {
        KtNodeList list = new KtNodeList();
        KtNodeEnum nodes = row.getList().nodes();
        list.append(nodes.nextNode());
        int i = 0;
        while (nodes.hasMoreNodes()) {
            i = this.transform((KtAnyUnsetNode)nodes.nextNode(), list, i, row.getSizes(), setting);
            list.append(nodes.nextNode());
            ++i;
        }
        return KtVShiftNode.shiftingRight(this.makeBox(this.transformSizes(row.getSizes(), size), setting, list), indent);
    }

    protected int transform(KtAnyUnsetNode col, KtNodeList list, int i, KtBoxSizes rowSizes, KtGlueSetting setting) {
        boolean empty;
        int n = i + col.getSpanCount();
        KtDimen size = this.maxSizes.get(i);
        boolean bl = empty = size == KtDimen.NULL;
        if (empty) {
            size = KtDimen.ZERO;
        }
        KtNodeList filler = new KtNodeList();
        KtDimen total = size;
        if (i < n) {
            KtGlue tab = empty ? KtGlue.ZERO : this.preamble.getSkip(i);
            int j = i;
            do {
                total = total.plus(setting.set(tab, false));
                filler.append(this.makeSkip(tab, this.preamble.skipName));
                KtDimen w = this.maxSizes.get(++j);
                if (w != KtDimen.NULL) {
                    tab = this.preamble.getSkip(j);
                    total = total.plus(w);
                } else {
                    w = KtDimen.ZERO;
                    tab = KtGlue.ZERO;
                }
                filler.append(this.makeBox(this.transformSizes(KtBoxSizes.ZERO, w), KtGlueSetting.NATURAL, KtNodeList.EMPTY));
            } while (j != n);
        }
        list.append(this.makeBox(this.transformSizes(rowSizes, size), col.getSetting(total.minus(this.getRelevantSize(col.getSizes()))), col.getList())).append(filler);
        return n;
    }

    protected void check(KtSizesEvaluator pack, KtDimen size) {
        KtTypoCommand.KtAnyBoxPacker packer = this.makeBoxPacker();
        if (packer.check(pack)) {
            int i;
            KtNodeList list = new KtNodeList();
            list.append(this.makeSkip(this.preamble.firstSkip, this.preamble.skipName));
            for (i = 0; i < this.maxSizes.size(); ++i) {
                KtDimen w = this.maxSizes.get(i);
                if (w != KtDimen.NULL) {
                    list.append(new KtAnyUnsetNode(this.transformSizes(KtBoxSizes.ZERO, w), KtNodeList.EMPTY)).append(i < this.preamble.length() ? this.makeSkip(this.preamble.getSkip(i), this.preamble.skipName) : this.makeSkip(this.preamble.getSkip(i)));
                    continue;
                }
                list.append(new KtAnyUnsetNode()).append(this.makeSkip(KtGlue.ZERO, this.preamble.skipName));
            }
            while (i < this.preamble.length()) {
                list.append(new KtAnyUnsetNode()).append(this.makeSkip(KtGlue.ZERO, this.preamble.skipName));
                ++i;
            }
            packer.reportBox(this.makeBox(this.transformSizes(KtBoxSizes.ZERO, size), pack.getSetting(), list));
        }
    }

    protected abstract void pushNewRowBuilder();

    protected abstract void pushNewSpanBuilder();

    protected abstract void addNamedSkipToRow(KtGlue var1, String var2);

    protected abstract KtDimen packedSpanSize(int var1);

    protected abstract void packRow();

    protected abstract KtNodeEnum getUnsetNodes();

    protected abstract KtDimen getRelevantSize(KtBoxSizes var1);

    protected abstract KtBoxSizes transformSizes(KtBoxSizes var1, KtDimen var2);

    protected abstract KtAnyBoxNode makeBox(KtBoxSizes var1, KtGlueSetting var2, KtNodeList var3);

    protected abstract KtAnySkipNode makeSkip(KtGlue var1);

    protected abstract KtAnySkipNode makeSkip(KtGlue var1, String var2);

    protected abstract KtTypoCommand.KtAnyBoxPacker makeBoxPacker();

    public abstract void copyPrevParameters(KtBuilder var1);

    private void push() {
        this.next = top;
        top = this;
    }

    private static void pop() {
        top = KtAlignment.top.next;
    }

    private static void checkTop() {
        if (top == NULL) {
            throw new RuntimeException("no alignment active");
        }
    }

    public static boolean columnBodyIsActiveAndBalanced() {
        return top != NULL && top.balancedColumn();
    }

    public static void finishActiveColumnBody(KtColumnEnding ending) {
        KtAlignment.checkTop();
        top.finishColumnBody(ending);
    }

    public static int activeColumnDisbalance() {
        return top != NULL ? top.columnDisbalance() : 1000000;
    }

    protected static class KtColumnBraceNesting
    implements KtBraceNesting {
        private int braceNesting = 0;

        protected KtColumnBraceNesting() {
        }

        @Override
        public void adjust(int count) {
            this.braceNesting += count;
        }

        public int disbalance() {
            return this.braceNesting;
        }

        public boolean balanced() {
            return this.braceNesting == 0;
        }
    }

    public static final class KtColumnEnding
    implements Serializable {
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;
        private final String name;
        private static final KtColumnEnding[] VALS = new KtColumnEnding[3];

        private KtColumnEnding(String name) {
            this.name = name;
            KtColumnEnding.VALS[this.ordinal] = this;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() throws ObjectStreamException {
            return VALS[this.ordinal];
        }
    }

    public static class KtNoAlignGroup
    extends KtSimpleGroup {
        @Override
        public void stop() {
            KtParagraph.finish();
        }

        @Override
        public void close() {
            KtAlignment.checkTop();
            top.nextRow();
        }
    }

    public static class KtSpanGroup
    extends KtSimpleGroup {
    }

    protected class KtTemplateTokenizer
    extends KtInsertedTokenList {
        public KtTemplateTokenizer(KtTokenList list) {
            super(list, "<template> ");
        }

        @Override
        public boolean close() {
            KtAlignment.this.startColumnBody(true);
            return false;
        }
    }
}

