/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.events;

import com.whitemagicsoftware.keentype.bus.KtBus;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.tex.KtTeXError;

public final class KtErrorEvent {
    private final KtTeXError mError;
    private final KtLoggable[] mParams;
    private final boolean mDelAllowed;
    private final boolean mCounting;

    private KtErrorEvent(KtTeXError error) {
        this(error, new KtLoggable[0], false, false);
    }

    private KtErrorEvent(KtTeXError error, KtLoggable[] params, boolean counting, boolean delAllowed) {
        assert (error != null);
        this.mError = error;
        this.mParams = params;
        this.mCounting = counting;
        this.mDelAllowed = delAllowed;
    }

    public boolean isCounting() {
        return this.mCounting;
    }

    public boolean isDelAllowed() {
        return this.mDelAllowed;
    }

    public void addText(KtLog log) {
        this.mError.addText(log, this.mParams);
    }

    public void addHelp(KtLog log) {
        this.mError.addHelp(log, this.mParams);
    }

    public void addDesc(KtLog log) {
        this.mError.addDesc(log, this.mParams);
    }

    public static void publish(KtTeXError error) {
        KtErrorEvent.publish(error, null, false);
    }

    public static void publish(KtTeXError error, KtLoggable[] params, boolean delAllowed) {
        KtErrorEvent.publish(error, params, true, delAllowed);
    }

    public static void publish(KtTeXError err, KtLoggable[] params, boolean counting, boolean delAllowed) {
        KtBus.post(new KtErrorEvent(err, params, counting, delAllowed));
    }
}

