/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.io;

import com.whitemagicsoftware.keentype.io.KtFileWalker;
import com.whitemagicsoftware.keentype.io.KtProtocolScheme;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Consumer;

public final class KtResourceWalker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void walk(String directory, String glob, Consumer<Path> c) throws URISyntaxException, IOException {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(directory);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                Path path;
                URL resource = resources.nextElement();
                URI uri = resource.toURI();
                FileSystem fs = null;
                if (KtProtocolScheme.valueFrom(uri) == KtProtocolScheme.JAR) {
                    fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    path = fs.getPath(directory, new String[0]);
                } else {
                    path = Paths.get(uri);
                }
                try {
                    KtFileWalker.walk(path, glob, c);
                }
                finally {
                    if (fs != null) {
                        fs.close();
                    }
                }
            }
        }
    }
}

