/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.noad;

import com.whitemagicsoftware.keentype.noad.KtNoad;
import com.whitemagicsoftware.keentype.noad.KtNoadEnum;
import com.whitemagicsoftware.keentype.noad.KtNodeNoad;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import java.io.Serializable;
import java.util.Vector;

public class KtNoadList
implements Serializable {
    public static final KtNoadList NULL = null;
    public static final KtNoadList EMPTY = new KtNoadList();
    public static final KtNoadEnum EMPTY_ENUM = new KtNoadEnum(){

        @Override
        public KtNoad nextNoad() {
            return KtNoad.NULL;
        }

        @Override
        public boolean hasMoreNoads() {
            return false;
        }
    };
    protected Vector<KtNoad> data;

    protected KtNoadList(Vector<KtNoad> data) {
        this.data = data;
    }

    public KtNoadList() {
        this.data = new Vector();
    }

    public KtNoadList(int initCap) {
        this.data = new Vector(initCap);
    }

    public KtNoadList(int initCap, int capIncrement) {
        this.data = new Vector(initCap, capIncrement);
    }

    public KtNoadList(KtNoad noad) {
        this(1);
        this.append(noad);
    }

    public KtNoadList(KtNoadEnum noads) {
        this();
        this.append(noads);
    }

    public KtNoadList(KtNoad[] noads) {
        this(noads.length);
        this.append(noads);
    }

    public KtNoadList(KtNoad[] noads, int offset, int count) {
        this(count);
        this.append(noads, offset, count);
    }

    public final int length() {
        return this.data.size();
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected void clear() {
        this.data.clear();
    }

    public final KtNoad noadAt(int idx) {
        return this.data.elementAt(idx);
    }

    public KtNoadList append(KtNoad noad) {
        this.data.addElement(noad);
        return this;
    }

    public KtNoadList append(KtNoad[] noads, int offset, int count) {
        this.data.ensureCapacity(this.data.size() + count);
        while (count-- > 0) {
            this.append(noads[offset++]);
        }
        return this;
    }

    public KtNoadList append(KtNoad[] noads) {
        return this.append(noads, 0, noads.length);
    }

    public KtNoadList append(KtNoadEnum noads) {
        while (noads.hasMoreNoads()) {
            this.append(noads.nextNoad());
        }
        return this;
    }

    public KtNoadList append(KtNoadList list) {
        return this.append(list.noads());
    }

    public KtNoad lastNoad() {
        return this.length() > 0 ? this.noadAt(this.length() - 1) : KtNoad.NULL;
    }

    public void removeLastNoad() {
        if (this.length() > 0) {
            this.data.removeElementAt(this.length() - 1);
        }
    }

    public void replaceLastNoad(KtNoad noad) {
        if (this.length() > 0) {
            this.data.set(this.length() - 1, noad);
        }
    }

    public KtNoad[] toArray() {
        KtNoad[] noads = new KtNoad[this.data.size()];
        return this.data.toArray(noads);
    }

    public KtNoadEnum noads() {
        return new KtEnum(0, this.length());
    }

    public KtNoadEnum noads(int start) {
        return new KtEnum(start, this.length());
    }

    public KtNoadEnum noads(int start, int end) {
        return new KtEnum(start, end);
    }

    public static KtNoadEnum noads(final KtNoad noad) {
        return new KtNoadEnum(){
            private boolean fresh = true;

            @Override
            public KtNoad nextNoad() {
                this.fresh = false;
                return noad;
            }

            @Override
            public boolean hasMoreNoads() {
                return this.fresh;
            }
        };
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        KtNoadEnum noads = this.noads();
        while (noads.hasMoreNoads()) {
            buf.append(noads.nextNoad()).append(", ");
        }
        return buf.toString();
    }

    public KtNoadList append(KtNode node) {
        this.append(new KtNodeNoad(node));
        return this;
    }

    public KtNoadList append(KtNodeEnum nodes) {
        while (nodes.hasMoreNodes()) {
            this.append(nodes.nextNode());
        }
        return this;
    }

    public KtNode lastNode() {
        KtNoad last = this.lastNoad();
        return last != KtNoad.NULL && last.isNode() ? last.getNode() : KtNode.NULL;
    }

    public void removeLastNode() {
        KtNoad last = this.lastNoad();
        if (last != KtNoad.NULL && last.isNode()) {
            this.removeLastNoad();
        }
    }

    public KtNode lastSpecialNode() {
        return this.lastNode();
    }

    private class KtEnum
    extends KtNoadEnum {
        private int idx;
        private final int end;

        public KtEnum(int idx, int end) {
            this.idx = idx;
            this.end = end;
        }

        @Override
        public KtNoad nextNoad() {
            return KtNoadList.this.noadAt(this.idx++);
        }

        @Override
        public boolean hasMoreNoads() {
            return this.idx < this.end;
        }
    }
}

