/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tfm;

import com.whitemagicsoftware.keentype.tfm.KtBadTeXFmException;
import com.whitemagicsoftware.keentype.tfm.KtFixWord;
import com.whitemagicsoftware.keentype.tfm.KtIndexMultimap;
import com.whitemagicsoftware.keentype.tfm.KtTeXFm;
import com.whitemagicsoftware.keentype.tfm.KtTeXFmDiagnostic;
import com.whitemagicsoftware.keentype.tfm.KtTeXMathExtFm;
import com.whitemagicsoftware.keentype.tfm.KtTeXMathSymFm;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class KtTeXFmLoader {
    KtTeXFmDiagnostic diagnostic;
    protected InputStream input;
    protected static final byte NO_TAG = 0;
    protected static final byte LIG_TAG = 1;
    protected static final byte LIST_TAG = 2;
    protected static final byte EXT_TAG = 3;
    protected int fileLength;
    protected int headerLength;
    protected short firstCharCode;
    protected int charCount;
    protected int widthCount;
    protected int heightCount;
    protected int depthCount;
    protected int italicCount;
    protected int ligAuxLen;
    protected int kernCount;
    protected int extAuxCnt;
    protected int paramCount;
    protected int checkSum;
    protected KtFixWord designSize;
    protected String codingScheme = null;
    protected String family = null;
    protected int face = -1;
    protected boolean sevenBitSafe = false;
    protected int[] headerRest = null;
    protected int restIndex = 0;
    protected static final byte VANILLA = 0;
    protected static final byte MATHSY = 1;
    protected static final byte MATHEX = 2;
    protected byte fontType;
    protected static final int CODING_SIZE = 10;
    protected static final int FAMILY_SIZE = 5;
    protected KtAuxCharInfo[] charAuxTab;
    protected KtFixWord[] widthTable;
    protected KtFixWord[] heightTable;
    protected KtFixWord[] depthTable;
    protected KtFixWord[] italicTable;
    protected KtAuxLigKern[] ligAuxTab;
    protected KtFixWord[] kernTable;
    protected KtAuxExtRecipe[] extAuxTab;
    protected KtFixWord[] paramTable;
    private static final String WD = "Width";
    private static final String HT = "Height";
    private static final String DP = "Depth";
    private static final String IC = "Italic correction";
    private static final String KR = "Kern";
    protected static final KtFixWord zeroFixWord = KtFixWord.valueOf(0);
    protected static final short NO_CHAR_CODE = -1;
    protected static final int NO_INDEX = -1;
    protected short boundaryChar = (short)-1;
    protected int boundaryStart = -1;
    protected KtIndexMultimap labels = new KtIndexMultimap();
    protected static final int BOUNDARY_LABEL = -1;
    protected KtTeXFm.KtLigKern[] ligKernTable;
    protected KtTeXFm.KtCharInfo[] charTable;
    protected KtTeXFm metric;

    protected static void abort(String s, KtTeXFmDiagnostic dg) throws KtBadTeXFmException {
        if (dg != null) {
            dg.fatal(s);
        }
        throw new KtBadTeXFmException(s);
    }

    protected void abort(String s) throws KtBadTeXFmException {
        KtTeXFmLoader.abort(s, this.diagnostic);
    }

    protected void bad(String s) throws KtBadTeXFmException {
        if (this.diagnostic != null) {
            this.diagnostic.error(s);
        }
        if (this.diagnostic == null || this.diagnostic.abortOnError()) {
            throw new KtBadTeXFmException(s);
        }
    }

    protected void warning(String s) {
        if (this.diagnostic != null) {
            this.diagnostic.warning(s);
        }
    }

    protected KtTeXFmLoader(InputStream in, KtTeXFmDiagnostic dg) throws IOException {
        this.input = in;
        this.diagnostic = dg;
        try {
            this.readLengths();
            this.readHeader();
            this.readTables();
            this.checkTables();
            this.makeLigTable();
            this.checkExtens();
            this.makeCharTable();
            this.makeMetric();
        }
        finally {
            this.input.close();
        }
    }

    protected KtTeXFmLoader(InputStream in) throws IOException {
        this(in, null);
    }

    protected KtTeXFmLoader(String path, KtTeXFmDiagnostic dg) throws IOException {
        this(new BufferedInputStream(new FileInputStream(path)), dg);
    }

    protected KtTeXFmLoader(String path) throws IOException {
        this(path, null);
    }

    protected void readLengths() throws IOException {
        this.fileLength = this.readFileLength();
        this.headerLength = this.readLength();
        this.firstCharCode = this.readLength();
        short lastChar = this.readLength();
        this.widthCount = this.readLength();
        this.heightCount = this.readLength();
        this.depthCount = this.readLength();
        this.italicCount = this.readLength();
        this.ligAuxLen = this.readLength();
        this.kernCount = this.readLength();
        this.extAuxCnt = this.readLength();
        this.paramCount = this.readLength();
        if (this.headerLength < 2) {
            this.abort("The header length is only " + this.headerLength + "!");
        }
        if (this.firstCharCode > lastChar + 1 || lastChar > 255) {
            this.abort("The character code range " + this.firstCharCode + ".." + lastChar + "is illegal!");
        }
        this.charCount = lastChar + 1 - this.firstCharCode;
        if (this.charCount == 0) {
            this.firstCharCode = 0;
        }
        if (this.widthCount == 0 || this.heightCount == 0 || this.depthCount == 0 || this.italicCount == 0) {
            this.abort("Incomplete subfiles for character dimensions!");
        }
        if (this.extAuxCnt > 256) {
            this.abort("There are " + this.extAuxCnt + " extensible recipes!");
        }
        if (this.fileLength != 6 + this.headerLength + this.charCount + this.widthCount + this.heightCount + this.depthCount + this.italicCount + this.ligAuxLen + this.kernCount + this.extAuxCnt + this.paramCount) {
            this.abort("Subfile sizes don't add up to the stated total!");
        }
    }

    protected int readFileLength() throws IOException {
        short i = this.readByte();
        if (i < 0) {
            this.abort("The input file is empty!");
        }
        if (i > 127) {
            this.abort("The first byte of the input file exceeds 127!");
        }
        int len = i << 8;
        i = this.readByte();
        if (i < 0) {
            this.abort("The input file is only one byte long!");
        }
        if ((len += i) == 0) {
            this.abort("The file claims to have length zero, but that's impossible!");
        }
        if (len < 6) {
            this.abort("The file claims to have length " + len + " words, but it must be at least 6 words long!");
        }
        return len;
    }

    protected void readHeader() throws IOException {
        int rest = this.headerLength;
        this.checkSum = this.readWord();
        KtFixWord dSize = this.readFixWord();
        if ((rest -= 2) >= 10) {
            this.codingScheme = this.readBCPL(40);
            this.fontType = KtTeXFmLoader.getFontType(this.codingScheme);
            if ((rest -= 10) >= 5) {
                this.family = this.readBCPL(20);
                if ((rest -= 5) >= 1) {
                    this.sevenBitSafe = this.readByte() > 127;
                    this.input.skip(2L);
                    this.face = this.readByte();
                    if (--rest > 0) {
                        this.headerRest = new int[rest];
                        this.restIndex = this.headerLength - rest;
                        for (int i = 0; i < rest; ++i) {
                            this.headerRest[i] = this.readWord();
                        }
                    }
                }
            }
        }
        if (dSize.lessThan(0)) {
            dSize = this.badDesignSize(dSize, "negative");
        } else if (dSize.lessThan(1)) {
            dSize = this.badDesignSize(dSize, "too small");
        }
        this.designSize = dSize;
    }

    protected static byte getFontType(String s) {
        if (s.startsWith("TEX MATH SY")) {
            return 1;
        }
        if (s.startsWith("TEX MATH EX")) {
            return 2;
        }
        return 0;
    }

    protected String readBCPL(int size) throws IOException {
        int len = this.readByte();
        if (len >= size) {
            this.bad("String is too long; I've shortened it drastically.");
            len = 1;
        }
        size -= len + 1;
        StringBuilder buf = new StringBuilder(len);
        while (len-- > 0) {
            int c = this.readByte();
            if (c == 40 || c == 41) {
                this.bad("Parenthesis in string has been changed to slash.");
                c = 47;
            } else if (32 > c || c > 126) {
                this.bad("Nonstandard ASCII code has been blotted out.");
                c = 63;
            } else {
                c = Character.toUpperCase((char)c);
            }
            buf.append((char)c);
        }
        this.input.skip(size);
        return buf.toString();
    }

    protected KtFixWord badDesignSize(KtFixWord dSize, String s) throws KtBadTeXFmException {
        this.bad("Design size " + s + "!\nI've set it to 10 points.");
        return KtFixWord.valueOf(10);
    }

    protected boolean charExists(short c) {
        return (c = (short)(c - this.firstCharCode)) >= 0 && c < this.charCount && this.charAuxTab[c].exists();
    }

    protected void readTables() throws IOException {
        this.charAuxTab = KtAuxCharInfo.readTable(this.input, this.diagnostic, this.charCount);
        this.widthTable = this.readFixWords(this.widthCount);
        this.heightTable = this.readFixWords(this.heightCount);
        this.depthTable = this.readFixWords(this.depthCount);
        this.italicTable = this.readFixWords(this.italicCount);
        this.ligAuxTab = KtAuxLigKern.readTable(this.input, this.diagnostic, this.ligAuxLen);
        this.kernTable = this.readFixWords(this.kernCount);
        this.extAuxTab = KtAuxExtRecipe.readTable(this.input, this.diagnostic, this.extAuxCnt);
        this.paramTable = this.readFixWords(this.paramCount);
        if (this.input.read() >= 0) {
            this.warning("There's some extra junk at the end of the TFM file,\nbut I'll proceed as if it weren't there.");
        }
    }

    protected void checkTables() throws KtBadTeXFmException {
        this.checkParams();
        this.checkZeroDimen(this.widthTable, "width");
        this.checkZeroDimen(this.heightTable, "height");
        this.checkZeroDimen(this.depthTable, "depth");
        this.checkZeroDimen(this.italicTable, "italic");
        this.checkDimens(this.widthTable, 0, this.widthCount, WD);
        this.checkDimens(this.heightTable, 0, this.heightCount, HT);
        this.checkDimens(this.depthTable, 0, this.depthCount, DP);
        this.checkDimens(this.italicTable, 0, this.italicCount, IC);
        this.checkDimens(this.kernTable, 0, this.kernCount, KR);
    }

    protected void checkParams() throws KtBadTeXFmException {
        this.checkDimens(this.paramTable, 1, this.paramCount, "Parameter");
        switch (this.fontType) {
            case 1: {
                if (this.paramCount == 22) break;
                this.warning("Unusual number of fontdimen parameters for a math symbols font (" + this.paramCount + " not 22).");
                break;
            }
            case 2: {
                if (this.paramCount == 13) break;
                this.warning("Unusual number of fontdimen parameters for an extension font (" + this.paramCount + " not 13).");
            }
        }
    }

    protected void checkDimens(KtFixWord[] table, int beg, int end, String what) throws KtBadTeXFmException {
        while (beg < end) {
            if (!table[beg].lessThan(16) || !table[beg].moreThan(-16)) {
                this.bad(what + " " + beg + " is too big;\nI have set it to zero.");
                table[beg] = zeroFixWord;
            }
            ++beg;
        }
    }

    protected void checkZeroDimen(KtFixWord[] table, String what) throws KtBadTeXFmException {
        if (!table[0].isZero()) {
            this.bad(what + "[0] should be zero.");
        } else {
            table[0] = KtFixWord.ZERO;
        }
    }

    protected void makeLigTable() throws KtBadTeXFmException {
        if (this.ligAuxLen > 0) {
            this.setupBoundary();
        }
        this.buildLabels();
        this.promoteActivity();
        this.buildLigKernTable();
    }

    protected void setupBoundary() throws KtBadTeXFmException {
        KtAuxLigKern alk = this.ligAuxTab[0];
        if (alk.meansBoundary()) {
            this.boundaryChar = alk.nextChar();
            alk.activity = 1;
        }
        if ((alk = this.ligAuxTab[this.ligAuxLen - 1]).meansBoundary()) {
            int start = alk.restartIndex();
            alk.activity = 1;
            if (start < this.ligAuxLen) {
                this.ligAuxTab[start].activity = (byte)2;
                this.labels.add(start, -1);
            } else {
                this.bad(" KtLigature/kern starting index for boundarychar is too large;\nso I removed it.");
            }
        }
    }

    protected void buildLabels() throws KtBadTeXFmException {
        for (int i = 0; i < this.charCount; ++i) {
            if (this.charAuxTab[i].tag() != 1) continue;
            int start = this.ligAuxStart(this.charAuxTab[i].ligStart());
            if (start < this.ligAuxLen) {
                this.labels.add(start, i);
                this.ligAuxTab[start].activity = (byte)2;
                continue;
            }
            this.bad(" KtLigature/kern starting index for character '" + this.octCharNum(i) + "\n is too large;\nso I removed it.");
            this.charAuxTab[i].resetTag();
        }
    }

    protected int ligAuxStart(int start) {
        KtAuxLigKern alk;
        if (start < this.ligAuxLen && (alk = this.ligAuxTab[start]).meansRestart() && (start = alk.restartIndex()) < this.ligAuxLen && alk.activity == 0) {
            alk.activity = 1;
        }
        return start;
    }

    protected void promoteActivity() throws KtBadTeXFmException {
        int ligKernLength = 0;
        for (int i = 0; i < this.ligAuxLen; ++i) {
            KtAuxLigKern alk = this.ligAuxTab[i];
            if (alk.activity == 2 && !alk.meansStop()) {
                int next = alk.nextIndex(i);
                if (next < this.ligAuxLen) {
                    this.ligAuxTab[next].activity = (byte)2;
                } else {
                    this.bad("KtLigature/kern step " + i + " skips too far;\nI made it stop.");
                    alk.makeStop();
                }
            }
            if (alk.activity == 1) continue;
            ++ligKernLength;
        }
        this.ligKernTable = new KtTeXFm.KtLigKern[ligKernLength];
    }

    protected void buildLigKernTable() throws KtBadTeXFmException {
        int currIns = 0;
        for (int i = 0; i < this.ligAuxLen; ++i) {
            this.setLigStarts(i, currIns);
            KtAuxLigKern alk = this.ligAuxTab[i];
            if (alk.activity == 1) continue;
            if (!alk.meansRestart()) {
                this.checkLigKern(alk);
                int skip = this.getSkip(i);
                this.ligKernTable[currIns++] = alk.meansKern() ? this.makeKern(alk, skip) : this.makeLig(alk, skip);
                continue;
            }
            if (alk.restartIndex() <= this.ligAuxLen) continue;
            this.bad("KtLigature unconditional stop command address is too big.");
        }
    }

    protected void setLigStarts(int pos, int start) {
        KtIndexMultimap.KtEnum lab = this.labels.forKey(pos);
        while (lab.hasMore()) {
            int c = lab.next();
            if (c == -1) {
                this.boundaryStart = start;
                continue;
            }
            this.charAuxTab[c].lig_kern_start = start;
        }
    }

    protected void checkLigKern(KtAuxLigKern alk) throws KtBadTeXFmException {
        if (!this.charExists(alk.nextChar()) && alk.nextChar() != this.boundaryChar) {
            this.bad_char(alk.nextChar(), (alk.meansKern() ? KR : "KtLigature") + " step for");
            alk.setNextChar(this.firstCharCode);
        }
    }

    protected void bad_char(short c, String s) throws KtBadTeXFmException {
        this.bad(s + " nonexistent character '" + Integer.toOctalString(c) + ".");
    }

    protected int getSkip(int pos) {
        KtAuxLigKern alk = this.ligAuxTab[pos];
        if (alk.meansStop()) {
            return -1;
        }
        int skip = 0;
        int next = alk.nextIndex(pos);
        while (++pos < next) {
            if (this.ligAuxTab[pos].activity == 1) continue;
            ++skip;
        }
        return skip;
    }

    protected KtTeXFm.KtLigKern makeLig(KtAuxLigKern alk, int skip) throws KtBadTeXFmException {
        if (!this.charExists(alk.ligChar())) {
            this.bad_char(alk.ligChar(), "KtLigature step produces the");
            alk.setLigChar(this.firstCharCode);
        }
        boolean left = alk.leaveLeft();
        boolean right = alk.leaveRight();
        byte step = alk.stepOver();
        if (step > (left ? 1 : 0) + (right ? 1 : 0)) {
            this.warning("KtLigature step with nonstandard code changed to LIG");
            right = false;
            left = false;
            step = 0;
        }
        return new KtTeXFm.KtLigature(skip, alk.nextChar(), alk.ligChar(), left, right, step);
    }

    protected KtTeXFm.KtLigKern makeKern(KtAuxLigKern alk, int skip) throws KtBadTeXFmException {
        KtFixWord kern;
        int kernIdx = alk.kernIndex();
        if (kernIdx < this.kernTable.length) {
            kern = this.kernTable[kernIdx];
        } else {
            this.bad("Kern index too large.");
            kern = zeroFixWord;
        }
        return new KtTeXFm.KtKerning(skip, alk.nextChar(), kern);
    }

    protected void checkExtens() throws KtBadTeXFmException {
        for (int i = 0; i < this.extAuxCnt; ++i) {
            KtAuxExtRecipe aer = this.extAuxTab[i];
            if (aer.top != 0) {
                this.checkExt(aer.top);
            }
            if (aer.mid != 0) {
                this.checkExt(aer.mid);
            }
            if (aer.bot != 0) {
                this.checkExt(aer.bot);
            }
            this.checkExt(aer.rep);
        }
    }

    protected void checkExt(short c) throws KtBadTeXFmException {
        if (!this.charExists(c)) {
            this.bad_char(c, "Extensible recipe involves the");
        }
    }

    protected void makeCharTable() throws KtBadTeXFmException {
        this.charTable = new KtTeXFm.KtCharInfo[this.charCount];
        for (int i = 0; i < this.charCount; ++i) {
            this.charTable[i] = this.charAuxTab[i].exists() ? this.makeCharInfo(i) : KtTeXFm.KtCharInfo.NULL;
        }
    }

    protected KtTeXFm.KtCharInfo makeCharInfo(int pos) throws KtBadTeXFmException {
        KtAuxCharInfo aci = this.charAuxTab[pos];
        KtFixWord wd = this.takeDimen(this.widthTable, aci.widthIndex(), pos, WD);
        KtFixWord ht = this.takeDimen(this.heightTable, aci.heightIndex(), pos, HT);
        KtFixWord dp = this.takeDimen(this.depthTable, aci.depthIndex(), pos, DP);
        KtFixWord ic = this.takeDimen(this.italicTable, aci.italicIndex(), pos, IC);
        switch (aci.tag()) {
            case 1: {
                return new KtTeXFm.KtLigCharInfo(wd, ht, dp, ic, aci.lig_kern_start);
            }
            case 2: {
                if (!this.validCharList(pos)) break;
                return new KtTeXFm.KtListCharInfo(wd, ht, dp, ic, aci.biggerChar());
            }
            case 3: {
                if (aci.extenIndex() < this.extAuxCnt) {
                    KtAuxExtRecipe aer = this.extAuxTab[aci.extenIndex()];
                    return new KtTeXFm.KtExtCharInfo(wd, ht, dp, ic, aer.top != 0 ? (short)aer.top : (short)-1, aer.mid != 0 ? (short)aer.mid : (short)-1, aer.bot != 0 ? (short)aer.bot : (short)-1, aer.rep);
                }
                this.range_error(pos, "Extensible");
            }
        }
        return new KtTeXFm.KtCharInfo(wd, ht, dp, ic);
    }

    protected KtFixWord takeDimen(KtFixWord[] table, int i, int pos, String what) throws KtBadTeXFmException {
        if (i < table.length) {
            return table[i];
        }
        this.range_error(pos, what);
        return zeroFixWord;
    }

    protected void range_error(int pos, String what) throws KtBadTeXFmException {
        this.bad(what + " index for character '" + this.octCharNum(pos) + " is too large;\nso I reset it to zero.");
    }

    protected String octCharNum(int pos) {
        return Integer.toOctalString(pos + this.firstCharCode);
    }

    protected boolean validCharList(int pos) throws KtBadTeXFmException {
        KtAuxCharInfo aci = this.charAuxTab[pos];
        short next = aci.biggerChar();
        if (!this.charExists(next)) {
            this.bad_char(next, "Character list link to");
            aci.resetTag();
            return false;
        }
        while ((next = (short)(next - this.firstCharCode)) < pos && (aci = this.charAuxTab[next]).tag() == 2) {
            next = aci.biggerChar();
        }
        if (next == pos) {
            this.bad("Cycle in a character list!\nCharacter '" + this.octCharNum(pos) + " now ends the list.");
            this.charAuxTab[pos].resetTag();
            return false;
        }
        return true;
    }

    public KtTeXFm getMetric() {
        return this.metric;
    }

    protected void makeMetric() {
        switch (this.fontType) {
            case 1: {
                this.metric = new KtTeXMathSymFm(this.checkSum, this.designSize, this.firstCharCode, this.charTable, this.boundaryChar, this.boundaryStart, this.ligKernTable, this.paramTable, this.codingScheme, this.family, this.face, this.sevenBitSafe, this.headerRest, this.restIndex);
                break;
            }
            case 2: {
                this.metric = new KtTeXMathExtFm(this.checkSum, this.designSize, this.firstCharCode, this.charTable, this.boundaryChar, this.boundaryStart, this.ligKernTable, this.paramTable, this.codingScheme, this.family, this.face, this.sevenBitSafe, this.headerRest, this.restIndex);
                break;
            }
            default: {
                this.metric = new KtTeXFm(this.checkSum, this.designSize, this.firstCharCode, this.charTable, this.boundaryChar, this.boundaryStart, this.ligKernTable, this.paramTable, this.codingScheme, this.family, this.face, this.sevenBitSafe, this.headerRest, this.restIndex);
            }
        }
    }

    protected final KtFixWord[] readFixWords(int count) throws IOException {
        KtFixWord[] table = new KtFixWord[count];
        for (int i = 0; i < count; ++i) {
            table[i] = this.readFixWord();
        }
        return table;
    }

    protected final KtFixWord readFixWord() throws IOException {
        int FIX_WORD_DENOMINATOR = 0x100000;
        return KtFixWord.valueOf(this.readWord(), 0x100000);
    }

    protected final int readWord() throws IOException {
        int i = this.readByte();
        i = (i << 8) + this.readByte();
        i = (i << 8) + this.readByte();
        return (i << 8) + this.readByte();
    }

    protected final short readLength() throws IOException {
        short i = this.readByte();
        if ((i & 0x80) != 0) {
            this.abort("One of the subfile sizes is negative!");
        }
        return (short)((i << 8) + this.readByte());
    }

    protected final short readByte() throws IOException {
        return KtTeXFmLoader.readByte(this.input, this.diagnostic);
    }

    protected static short readByte(InputStream in, KtTeXFmDiagnostic dg) throws IOException {
        int i = in.read();
        if (i < 0) {
            KtTeXFmLoader.abort("The file has fewer bytes than it claims!", dg);
        }
        return (short)i;
    }

    protected static class KtAuxCharInfo {
        private final byte _width_index;
        private final byte _height_depth_index;
        private byte _italic_index_tag;
        private final byte _remainder;
        int lig_kern_start;

        boolean exists() {
            return this._width_index != 0;
        }

        int widthIndex() {
            return this._width_index & 0xFF;
        }

        int heightIndex() {
            return this._height_depth_index >> 4 & 0xF;
        }

        int depthIndex() {
            return this._height_depth_index & 0xF;
        }

        int italicIndex() {
            return this._italic_index_tag >> 2 & 0x3F;
        }

        byte tag() {
            return (byte)(this._italic_index_tag & 3);
        }

        void resetTag() {
            this._italic_index_tag = (byte)(this._italic_index_tag & 0xFFFFFFFC);
        }

        private short remainder() {
            return (short)(this._remainder & 0xFF);
        }

        int ligStart() {
            return this.remainder();
        }

        short biggerChar() {
            return this.remainder();
        }

        int extenIndex() {
            return this.remainder();
        }

        KtAuxCharInfo(InputStream in, KtTeXFmDiagnostic dg) throws IOException {
            this._width_index = (byte)KtTeXFmLoader.readByte(in, dg);
            this._height_depth_index = (byte)KtTeXFmLoader.readByte(in, dg);
            this._italic_index_tag = (byte)KtTeXFmLoader.readByte(in, dg);
            this._remainder = (byte)KtTeXFmLoader.readByte(in, dg);
        }

        static KtAuxCharInfo[] readTable(InputStream in, KtTeXFmDiagnostic dg, int count) throws IOException {
            KtAuxCharInfo[] table = new KtAuxCharInfo[count];
            for (int i = 0; i < count; ++i) {
                table[i] = new KtAuxCharInfo(in, dg);
            }
            return table;
        }
    }

    protected static class KtAuxLigKern {
        private static final short BOUNDARY_FLAG = 255;
        private static final short STOP_FLAG = 128;
        private static final short KERN_FLAG = 128;
        private byte _skip_byte;
        private byte _next_char;
        private final byte _op_byte;
        private byte _remainder;
        static final byte UNREACHABLE = 0;
        static final byte PASS_THROUGH = 1;
        static final byte ACCESSIBLE = 2;
        byte activity = 0;

        private short skip_byte() {
            return (short)(this._skip_byte & 0xFF);
        }

        private short op_byte() {
            return (short)(this._op_byte & 0xFF);
        }

        private short remainder() {
            return (short)(this._remainder & 0xFF);
        }

        boolean meansBoundary() {
            return this.skip_byte() == 255;
        }

        boolean meansRestart() {
            return this.skip_byte() > 128;
        }

        boolean meansStop() {
            return this.skip_byte() >= 128;
        }

        int nextIndex(int pos) {
            return pos + this.skip_byte() + 1;
        }

        void makeStop() {
            this._skip_byte = (byte)-128;
        }

        short nextChar() {
            return (short)(this._next_char & 0xFF);
        }

        void setNextChar(int c) {
            this._next_char = (byte)c;
        }

        int restartIndex() {
            return (this.op_byte() << 8) + this.remainder();
        }

        boolean meansKern() {
            return this.op_byte() >= 128;
        }

        int kernIndex() {
            return (this.op_byte() - 128 << 8) + this.remainder();
        }

        boolean leaveLeft() {
            return (this.op_byte() & 2) != 0;
        }

        boolean leaveRight() {
            return (this.op_byte() & 1) != 0;
        }

        byte stepOver() {
            return (byte)(this.op_byte() >>> 2);
        }

        short ligChar() {
            return this.remainder();
        }

        void setLigChar(short c) {
            this._remainder = (byte)c;
        }

        KtAuxLigKern(InputStream in, KtTeXFmDiagnostic dg) throws IOException {
            this._skip_byte = (byte)KtTeXFmLoader.readByte(in, dg);
            this._next_char = (byte)KtTeXFmLoader.readByte(in, dg);
            this._op_byte = (byte)KtTeXFmLoader.readByte(in, dg);
            this._remainder = (byte)KtTeXFmLoader.readByte(in, dg);
        }

        static KtAuxLigKern[] readTable(InputStream in, KtTeXFmDiagnostic dg, int count) throws IOException {
            KtAuxLigKern[] table = new KtAuxLigKern[count];
            for (int i = 0; i < count; ++i) {
                table[i] = new KtAuxLigKern(in, dg);
            }
            return table;
        }
    }

    protected static class KtAuxExtRecipe {
        short top;
        short mid;
        short bot;
        short rep;

        KtAuxExtRecipe(InputStream in, KtTeXFmDiagnostic dg) throws IOException {
            this.top = KtTeXFmLoader.readByte(in, dg);
            this.mid = KtTeXFmLoader.readByte(in, dg);
            this.bot = KtTeXFmLoader.readByte(in, dg);
            this.rep = KtTeXFmLoader.readByte(in, dg);
        }

        static KtAuxExtRecipe[] readTable(InputStream in, KtTeXFmDiagnostic dg, int count) throws IOException {
            KtAuxExtRecipe[] table = new KtAuxExtRecipe[count];
            for (int i = 0; i < count; ++i) {
                table[i] = new KtAuxExtRecipe(in, dg);
            }
            return table;
        }
    }
}

