/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tfm;

import com.whitemagicsoftware.keentype.base.KtBinFraction;
import com.whitemagicsoftware.keentype.base.KtBoolPar;
import com.whitemagicsoftware.keentype.base.KtIntPar;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.io.KtName;
import com.whitemagicsoftware.keentype.node.KtMathWordBuilder;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtWordRebuilder;
import com.whitemagicsoftware.keentype.tfm.KtFixWord;
import com.whitemagicsoftware.keentype.tfm.KtTeXFm;
import java.util.Stack;

public abstract class KtTeXLigKernBuilder
implements KtWordRebuilder,
KtMathWordBuilder {
    public static final short NO_CHAR_CODE = -1;
    private KtCell left = KtCell.NULL;
    private final Stack<KtCell> stack = new Stack();
    private final KtName.KtBuffer buffer = new KtName.KtBuffer();
    private boolean collapsed = false;
    private static final KtCell BOUNDARY = new KtBoundCell();
    private final KtBoolPar keepLeft = new KtBoolPar();
    private final KtBoolPar keepRight = new KtBoolPar();
    private final KtIntPar stepOver = new KtIntPar();
    private boolean leftHit = false;
    private boolean rightHit = false;

    @Override
    public boolean lastHasCollapsed() {
        return this.collapsed;
    }

    private void push(KtCell cell) {
        this.stack.push(cell);
        this.collapsed = false;
    }

    private KtCell pop() {
        return this.stack.pop();
    }

    private KtCell peek() {
        return this.stack.peek();
    }

    private boolean empty() {
        return this.stack.empty();
    }

    @Override
    public boolean add(KtCharCode code) {
        char index = code.toChar();
        if (index != '\uffff' && this.exists((short)index)) {
            KtCharCell cell = new KtCharCell(code);
            if (this.left == KtCell.NULL) {
                this.left = cell;
                this.buffer.append(code);
            } else {
                this.push(cell);
                this.proceed();
            }
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public byte addIfBelongsToCut(KtCharCode code) {
        char index = code.toChar();
        if (index != '\uffff' && this.exists((short)index)) {
            KtCharCell cell = new KtCharCell(code);
            if (this.left == KtCell.NULL) {
                this.left = cell;
                this.buffer.append(code);
            } else {
                byte how = 0;
                this.push(cell);
                while (!this.empty()) {
                    KtTeXFm.KtLigKern lk = this.getLigKern(this.left.getIdx(), this.peek().getIdx());
                    if (lk != KtTeXFm.KtLigKern.NULL) {
                        how = 1;
                        short lig = lk.getLig(this.keepLeft, this.keepRight, this.stepOver);
                        if (lig != -1) {
                            this.ligStep(lig);
                            continue;
                        }
                        KtFixWord kern = lk.getKern();
                        if (kern != KtFixWord.NULL) {
                            if (this.peek() == cell) {
                                this.pop();
                                this.close();
                                this.makeKern(kern);
                                return how;
                            }
                            this.move();
                            this.makeKern(kern);
                            continue;
                        }
                    }
                    if (this.peek() == cell) {
                        this.pop();
                        this.close();
                        return how;
                    }
                    this.move();
                }
            }
            return 2;
        }
        this.close();
        return 0;
    }

    @Override
    public boolean prolongsCut(KtCharCode code) {
        char index;
        if (this.left != KtCell.NULL && (index = code.toChar()) != '\uffff' && this.exists((short)index)) {
            KtTeXFm.KtLigKern lk = this.getLigKern(this.left.getIdx(), (short)index);
            return lk != KtTeXFm.KtLigKern.NULL;
        }
        return false;
    }

    private void proceed() {
        while (!this.empty()) {
            KtTeXFm.KtLigKern lk = this.getLigKern(this.left.getIdx(), this.peek().getIdx());
            if (lk != KtTeXFm.KtLigKern.NULL) {
                short lig = lk.getLig(this.keepLeft, this.keepRight, this.stepOver);
                if (lig != -1) {
                    this.ligStep(lig);
                    continue;
                }
                KtFixWord kern = lk.getKern();
                if (kern != KtFixWord.NULL) {
                    this.move();
                    this.makeKern(kern);
                    continue;
                }
            }
            this.move();
        }
    }

    public KtTeXLigKernBuilder(boolean leftBoundary) {
        if (leftBoundary) {
            this.left = BOUNDARY;
        }
    }

    protected KtTeXLigKernBuilder(KtCharCode code) {
        this.left = new KtCharCell(code);
    }

    protected KtTeXLigKernBuilder(short index, KtName subst, boolean leftHit) {
        this.left = new KtLigCell(index);
        this.buffer.append(subst);
        this.leftHit = leftHit;
    }

    private void ligStep(short lig) {
        if (this.left.isBoundary()) {
            this.leftHit = true;
        } else if (this.peek().isBoundary()) {
            this.rightHit = true;
        }
        KtCharCode code = this.keepRight.get() ? KtCharCode.NULL : this.pop().getCode();
        KtLigCell cell = new KtLigCell(lig, code);
        if (this.keepLeft.get()) {
            this.push(cell);
        } else {
            this.setLeft(cell);
            this.collapsed = this.empty();
        }
        for (int i = this.stepOver.get(); i > 0; --i) {
            this.move();
        }
    }

    @Override
    public void close(boolean rightBoundary) {
        if (rightBoundary) {
            this.close(BOUNDARY);
        } else {
            this.close();
        }
    }

    @Override
    public void close(KtCharCode code) {
        this.close(new KtCharBoundCell(code));
    }

    private void close(KtCell cell) {
        if (this.left != KtCell.NULL && !this.left.isBoundary()) {
            this.push(cell);
            this.proceed();
        }
        this.close();
    }

    public void close() {
        if (this.left != KtCell.NULL) {
            this.left.makeNode(this.leftHit, this.rightHit);
            this.left = KtCell.NULL;
        }
        this.rightHit = false;
        this.leftHit = false;
        this.buffer.clear();
    }

    private KtNode takeLastNode(boolean larger) {
        KtNode node = KtNode.NULL;
        if (this.left != KtCell.NULL) {
            node = this.left.makeNode(this.leftHit, this.rightHit, larger);
            this.left = KtCell.NULL;
        }
        this.rightHit = false;
        this.leftHit = false;
        this.buffer.clear();
        return node;
    }

    private void move() {
        this.move(this.pop());
    }

    private void move(KtCell right) {
        if (this.rightHit && right.isBoundary()) {
            this.left.makeNode(this.leftHit, true);
            this.rightHit = false;
        } else {
            this.left.makeNode(this.leftHit, false);
        }
        if (!this.left.isBoundary()) {
            this.leftHit = false;
        }
        this.buffer.clear();
        this.setLeft(right);
    }

    private void setLeft(KtCell cell) {
        this.left = cell;
        KtCharCode code = cell.getCode();
        if (code != KtCharCode.NULL) {
            this.buffer.append(code);
        }
    }

    @Override
    public KtNode takeLastNode() {
        return this.takeLastNode(false);
    }

    @Override
    public KtNode takeLastLargerNode() {
        return this.takeLastNode(true);
    }

    protected abstract boolean exists(short var1);

    protected abstract KtTeXFm.KtLigKern getLigKern(short var1, short var2);

    protected abstract void makeChar(KtCharCode var1);

    protected abstract void makeLig(short var1, KtName var2, boolean var3, boolean var4);

    protected abstract void makeKern(KtBinFraction var1);

    protected abstract KtNode makeChar(KtCharCode var1, boolean var2);

    protected abstract KtNode makeLig(short var1, KtName var2, boolean var3, boolean var4, boolean var5);

    private static interface KtCell {
        public static final KtCell NULL = null;

        public short getIdx();

        public KtCharCode getCode();

        public boolean isBoundary();

        public void makeNode(boolean var1, boolean var2);

        public KtNode makeNode(boolean var1, boolean var2, boolean var3);
    }

    private class KtCharCell
    implements KtCell {
        private final KtCharCode code;

        public KtCharCell(KtCharCode code) {
            this.code = code;
        }

        @Override
        public short getIdx() {
            return (short)this.code.toChar();
        }

        @Override
        public KtCharCode getCode() {
            return this.code;
        }

        @Override
        public boolean isBoundary() {
            return false;
        }

        @Override
        public void makeNode(boolean lh, boolean rh) {
            KtTeXLigKernBuilder.this.makeChar(this.code);
        }

        @Override
        public KtNode makeNode(boolean lh, boolean rh, boolean larger) {
            return KtTeXLigKernBuilder.this.makeChar(this.code, larger);
        }
    }

    private class KtLigCell
    implements KtCell {
        private final short index;
        private final KtCharCode code;

        public KtLigCell(short index, KtCharCode code) {
            this.index = index;
            this.code = code;
        }

        public KtLigCell(short index) {
            this(index, KtCharCode.NULL);
        }

        @Override
        public short getIdx() {
            return this.index;
        }

        @Override
        public KtCharCode getCode() {
            return this.code;
        }

        @Override
        public boolean isBoundary() {
            return false;
        }

        @Override
        public void makeNode(boolean lh, boolean rh) {
            KtTeXLigKernBuilder.this.makeLig(this.index, KtTeXLigKernBuilder.this.buffer.toName(), lh, rh);
        }

        @Override
        public KtNode makeNode(boolean lh, boolean rh, boolean larger) {
            return KtTeXLigKernBuilder.this.makeLig(this.index, KtTeXLigKernBuilder.this.buffer.toName(), lh, rh, larger);
        }
    }

    private static class KtCharBoundCell
    extends KtBoundCell {
        private final KtCharCode code;

        public KtCharBoundCell(KtCharCode code) {
            this.code = code;
        }

        @Override
        public short getIdx() {
            return (short)this.code.toChar();
        }
    }

    private static class KtBoundCell
    implements KtCell {
        private KtBoundCell() {
        }

        @Override
        public short getIdx() {
            return -1;
        }

        @Override
        public KtCharCode getCode() {
            return KtCharCode.NULL;
        }

        @Override
        public boolean isBoundary() {
            return true;
        }

        @Override
        public void makeNode(boolean lh, boolean rh) {
        }

        @Override
        public KtNode makeNode(boolean lh, boolean rh, boolean larger) {
            return KtNode.NULL;
        }
    }
}

