/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.lucene.analysis.ja.dict.Dictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;
import org.apache.lucene.util.IntsRef;

public abstract class BinaryDictionary
implements Dictionary {
    private final ByteBuffer buffer;
    private final int[] targetMapOffsets;
    private final int[] targetMap;
    private final String[] posDict;
    private final String[] inflTypeDict;
    private final String[] inflFormDict;

    protected BinaryDictionary(IOSupplier<InputStream> targetMapResource, IOSupplier<InputStream> posResource, IOSupplier<InputStream> dictResource) throws IOException {
        InputStreamDataInput in;
        try (BufferedInputStream mapIS = new BufferedInputStream(targetMapResource.get());){
            in = new InputStreamDataInput(mapIS);
            CodecUtil.checkHeader(in, "kuromoji_dict_map", 1, 1);
            this.targetMap = new int[in.readVInt()];
            this.targetMapOffsets = new int[in.readVInt()];
            BinaryDictionary.populateTargetMap(in, this.targetMap, this.targetMapOffsets);
        }
        try (BufferedInputStream posIS = new BufferedInputStream(posResource.get());){
            in = new InputStreamDataInput(posIS);
            CodecUtil.checkHeader(in, "kuromoji_dict_pos", 1, 1);
            int posSize = in.readVInt();
            this.posDict = new String[posSize];
            this.inflTypeDict = new String[posSize];
            this.inflFormDict = new String[posSize];
            BinaryDictionary.populatePosDict(in, posSize, this.posDict, this.inflTypeDict, this.inflFormDict);
        }
        try (InputStream dictIS = dictResource.get();){
            in = new InputStreamDataInput(dictIS);
            CodecUtil.checkHeader(in, "kuromoji_dict", 1, 1);
            int size = in.readVInt();
            ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size);
            ReadableByteChannel channel = Channels.newChannel(dictIS);
            int read = channel.read(tmpBuffer);
            if (read != size) {
                throw new EOFException("Cannot read whole dictionary");
            }
            this.buffer = tmpBuffer.asReadOnlyBuffer();
        }
    }

    private static void populateTargetMap(DataInput in, int[] targetMap, int[] targetMapOffsets) throws IOException {
        int accum = 0;
        int sourceId = 0;
        for (int ofs = 0; ofs < targetMap.length; ++ofs) {
            int val = in.readVInt();
            if ((val & 1) != 0) {
                targetMapOffsets[sourceId] = ofs;
                ++sourceId;
            }
            targetMap[ofs] = accum += val >>> 1;
        }
        if (sourceId + 1 != targetMapOffsets.length) {
            throw new IOException("targetMap file format broken; targetMap.length=" + targetMap.length + ", targetMapOffsets.length=" + targetMapOffsets.length + ", sourceId=" + sourceId);
        }
        targetMapOffsets[sourceId] = targetMap.length;
    }

    private static void populatePosDict(DataInput in, int posSize, String[] posDict, String[] inflTypeDict, String[] inflFormDict) throws IOException {
        for (int j = 0; j < posSize; ++j) {
            posDict[j] = in.readString();
            inflTypeDict[j] = in.readString();
            inflFormDict[j] = in.readString();
            if (inflTypeDict[j].length() == 0) {
                inflTypeDict[j] = null;
            }
            if (inflFormDict[j].length() != 0) continue;
            inflFormDict[j] = null;
        }
    }

    public void lookupWordIds(int sourceId, IntsRef ref) {
        ref.ints = this.targetMap;
        ref.offset = this.targetMapOffsets[sourceId];
        ref.length = this.targetMapOffsets[sourceId + 1] - ref.offset;
    }

    @Override
    public int getLeftId(int wordId) {
        return (this.buffer.getShort(wordId) & 0xFFFF) >>> 3;
    }

    @Override
    public int getRightId(int wordId) {
        return (this.buffer.getShort(wordId) & 0xFFFF) >>> 3;
    }

    @Override
    public int getWordCost(int wordId) {
        return this.buffer.getShort(wordId + 2);
    }
}

