/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.util.BitUtil;

public abstract class DataInput
implements Cloneable {
    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public short readShort() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public int readInt() throws IOException {
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        int i = b & 0x7F;
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0xF) << 28;
        if ((b & 0xF0) == 0) {
            return i;
        }
        throw new IOException("Invalid vInt detected (too many bits)");
    }

    public int readZInt() throws IOException {
        return BitUtil.zigZagDecode(this.readVInt());
    }

    public long readLong() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL | (long)this.readInt() << 32;
    }

    public long readVLong() throws IOException {
        return this.readVLong(false);
    }

    private long readVLong(boolean allowNegative) throws IOException {
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if (b >= 0) {
            return i;
        }
        if (allowNegative) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << 63;
            if (b == 0 || b == 1) {
                return i;
            }
            throw new IOException("Invalid vLong detected (more than 64 bits)");
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    public String readString() throws IOException {
        int length = this.readVInt();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    public DataInput clone() {
        try {
            return (DataInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("This cannot happen: Failing to clone DataInput", e);
        }
    }

    public abstract void skipBytes(long var1) throws IOException;
}

