/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.util.IOUtils;

public class WordlistLoader {
    public static CharArraySet getWordSet(Reader reader, String comment, CharArraySet result) throws IOException {
        try (BufferedReader br = WordlistLoader.getBufferedReader(reader);){
            String word = null;
            while ((word = br.readLine()) != null) {
                if (word.startsWith(comment) || (word = word.trim()).isEmpty()) continue;
                result.add(word);
            }
        }
        return result;
    }

    public static CharArraySet getWordSet(Reader reader, String comment) throws IOException {
        return CharArraySet.unmodifiableSet(WordlistLoader.getWordSet(reader, comment, new CharArraySet(16, false)));
    }

    public static CharArraySet getWordSet(InputStream stream, String comment) throws IOException {
        return WordlistLoader.getWordSet(stream, StandardCharsets.UTF_8, comment);
    }

    public static CharArraySet getWordSet(InputStream stream, Charset charset, String comment) throws IOException {
        return WordlistLoader.getWordSet(IOUtils.getDecodingReader(stream, charset), comment);
    }

    private static BufferedReader getBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

