/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.Token;
import org.apache.lucene.analysis.ko.dict.Dictionary;

public class DictionaryToken
extends Token {
    private final int wordId;
    private final KoreanTokenizer.Type type;
    private final Dictionary dictionary;

    public DictionaryToken(KoreanTokenizer.Type type, Dictionary dictionary, int wordId, char[] surfaceForm, int offset, int length, int startOffset, int endOffset) {
        super(surfaceForm, offset, length, startOffset, endOffset);
        this.type = type;
        this.dictionary = dictionary;
        this.wordId = wordId;
    }

    public String toString() {
        return "DictionaryToken(\"" + this.getSurfaceFormString() + "\" pos=" + this.getStartOffset() + " length=" + this.getLength() + " posLen=" + this.getPositionLength() + " type=" + this.type + " wordId=" + this.wordId + " leftID=" + this.dictionary.getLeftId(this.wordId) + ")";
    }

    public POS.Type getPOSType() {
        return this.dictionary.getPOSType(this.wordId);
    }

    public Dictionary.Morpheme[] getMorphemes() {
        return this.dictionary.getMorphemes(this.wordId, this.getSurfaceForm(), this.getOffset(), this.getLength());
    }
}

