/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class AttributeSource {
    private final Map<Class<? extends Attribute>, AttributeImpl> attributes;
    private final Map<Class<? extends AttributeImpl>, AttributeImpl> attributeImpls;
    private final State[] currentState;
    private final AttributeFactory factory;
    private static final ClassValue<Class<? extends Attribute>[]> implInterfaces = new ClassValue<Class<? extends Attribute>[]>(){

        @Override
        protected Class<? extends Attribute>[] computeValue(Class<?> clazz) {
            LinkedHashSet<Class<Attribute>> intfSet = new LinkedHashSet<Class<Attribute>>();
            do {
                for (Class<?> curInterface : clazz.getInterfaces()) {
                    if (curInterface == Attribute.class || !Attribute.class.isAssignableFrom(curInterface)) continue;
                    intfSet.add(curInterface.asSubclass(Attribute.class));
                }
            } while ((clazz = clazz.getSuperclass()) != null);
            Class[] a = intfSet.toArray(new Class[intfSet.size()]);
            return a;
        }
    };

    public AttributeSource() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
    }

    public AttributeSource(AttributeSource input) {
        Objects.requireNonNull(input, "input AttributeSource must not be null");
        this.attributes = input.attributes;
        this.attributeImpls = input.attributeImpls;
        this.currentState = input.currentState;
        this.factory = input.factory;
    }

    public AttributeSource(AttributeFactory factory) {
        this.attributes = new LinkedHashMap<Class<? extends Attribute>, AttributeImpl>();
        this.attributeImpls = new LinkedHashMap<Class<? extends AttributeImpl>, AttributeImpl>();
        this.currentState = new State[1];
        this.factory = Objects.requireNonNull(factory, "AttributeFactory must not be null");
    }

    static Class<? extends Attribute>[] getAttributeInterfaces(Class<? extends AttributeImpl> clazz) {
        return implInterfaces.get(clazz);
    }

    public final void addAttributeImpl(AttributeImpl att) {
        Class<?> clazz = att.getClass();
        if (this.attributeImpls.containsKey(clazz)) {
            return;
        }
        for (Class<? extends Attribute> curInterface : AttributeSource.getAttributeInterfaces(clazz)) {
            if (this.attributes.containsKey(curInterface)) continue;
            this.currentState[0] = null;
            this.attributes.put(curInterface, att);
            this.attributeImpls.put(clazz, att);
        }
    }

    public final <T extends Attribute> T addAttribute(Class<T> attClass) {
        AttributeImpl attImpl = this.attributes.get(attClass);
        if (attImpl == null) {
            if (!attClass.isInterface() || !Attribute.class.isAssignableFrom(attClass)) {
                throw new IllegalArgumentException("addAttribute() only accepts an interface that extends Attribute, but " + attClass.getName() + " does not fulfil this contract.");
            }
            attImpl = this.factory.createAttributeInstance(attClass);
            this.addAttributeImpl(attImpl);
        }
        return (T)((Attribute)attClass.cast(attImpl));
    }

    public final boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    private State getCurrentState() {
        State s = this.currentState[0];
        if (s != null || !this.hasAttributes()) {
            return s;
        }
        s = this.currentState[0] = new State();
        State c = this.currentState[0];
        Iterator<AttributeImpl> it = this.attributeImpls.values().iterator();
        c.attribute = it.next();
        while (it.hasNext()) {
            c = c.next = new State();
            c.attribute = it.next();
        }
        return s;
    }

    public final void clearAttributes() {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.clear();
            state = state.next;
        }
    }

    public final void endAttributes() {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.end();
            state = state.next;
        }
    }

    public int hashCode() {
        int code = 0;
        State state = this.getCurrentState();
        while (state != null) {
            code = code * 31 + state.attribute.hashCode();
            state = state.next;
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AttributeSource) {
            AttributeSource other = (AttributeSource)obj;
            if (this.hasAttributes()) {
                if (!other.hasAttributes()) {
                    return false;
                }
                if (this.attributeImpls.size() != other.attributeImpls.size()) {
                    return false;
                }
                State thisState = this.getCurrentState();
                State otherState = other.getCurrentState();
                while (thisState != null && otherState != null) {
                    if (otherState.attribute.getClass() != thisState.attribute.getClass() || !otherState.attribute.equals(thisState.attribute)) {
                        return false;
                    }
                    thisState = thisState.next;
                    otherState = otherState.next;
                }
                return true;
            }
            return !other.hasAttributes();
        }
        return false;
    }

    public final String reflectAsString(final boolean prependAttClass) {
        final StringBuilder buffer = new StringBuilder();
        this.reflectWith(new AttributeReflector(){

            @Override
            public void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                if (prependAttClass) {
                    buffer.append(attClass.getName()).append('#');
                }
                buffer.append(key).append('=').append(value == null ? "null" : value);
            }
        });
        return buffer.toString();
    }

    public final void reflectWith(AttributeReflector reflector) {
        State state = this.getCurrentState();
        while (state != null) {
            state.attribute.reflectWith(reflector);
            state = state.next;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " " + this.reflectAsString(false);
    }

    public static final class State
    implements Cloneable {
        AttributeImpl attribute;
        State next;

        public State clone() {
            State clone = new State();
            clone.attribute = this.attribute.clone();
            if (this.next != null) {
                clone.next = this.next.clone();
            }
            return clone;
        }
    }
}

