/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;

public class BytesRefBuilder {
    private final BytesRef ref = new BytesRef();

    public void setLength(int length) {
        this.ref.length = length;
    }

    public void grow(int capacity) {
        this.ref.bytes = ArrayUtil.grow(this.ref.bytes, capacity);
    }

    public void append(byte[] b, int off, int len) {
        this.grow(this.ref.length + len);
        System.arraycopy(b, off, this.ref.bytes, this.ref.length, len);
        this.ref.length += len;
    }

    public void append(BytesRef ref) {
        this.append(ref.bytes, ref.offset, ref.length);
    }

    public void clear() {
        this.setLength(0);
    }

    public void copyBytes(BytesRef ref) {
        this.clear();
        this.append(ref);
    }

    public void copyChars(char[] text, int off, int len) {
        this.grow(UnicodeUtil.maxUTF8Length(len));
        this.ref.length = UnicodeUtil.UTF16toUTF8(text, off, len, this.ref.bytes);
    }

    public BytesRef get() {
        assert (this.ref.offset == 0) : "Modifying the offset of the returned ref is illegal";
        return this.ref;
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

