/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.lucene.util.Constants;

public final class RamUsageEstimator {
    public static final boolean COMPRESSED_REFS_ENABLED;
    public static final int NUM_BYTES_OBJECT_REF;
    public static final int NUM_BYTES_OBJECT_HEADER;
    public static final int NUM_BYTES_ARRAY_HEADER;
    public static final int NUM_BYTES_OBJECT_ALIGNMENT;
    public static final Map<Class<?>, Integer> primitiveSizes;
    static final int INTEGER_SIZE;
    static final int LONG_SIZE;
    static final int STRING_SIZE;
    static final boolean JVM_IS_HOTSPOT_64BIT;
    public static final long HASHTABLE_RAM_BYTES_PER_ENTRY;
    public static final long LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY;

    private RamUsageEstimator() {
    }

    public static long alignObjectSize(long size) {
        return (size += (long)NUM_BYTES_OBJECT_ALIGNMENT - 1L) - size % (long)NUM_BYTES_OBJECT_ALIGNMENT;
    }

    public static long shallowSizeOfInstance(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return primitiveSizes.get(clazz).intValue();
        }
        long size = NUM_BYTES_OBJECT_HEADER;
        while (clazz != null) {
            Field[] fields;
            Class<?> target = clazz;
            try {
                fields = AccessController.doPrivileged(target::getDeclaredFields);
            }
            catch (AccessControlException e) {
                throw new RuntimeException("Can't access fields of class: " + target, e);
            }
            for (Field f : fields) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                size = RamUsageEstimator.adjustForField(size, f);
            }
            clazz = clazz.getSuperclass();
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    public static long adjustForField(long sizeSoFar, Field f) {
        Class<?> type = f.getType();
        int fsize = type.isPrimitive() ? primitiveSizes.get(type) : NUM_BYTES_OBJECT_REF;
        return sizeSoFar + (long)fsize;
    }

    static {
        IdentityHashMap<Class<Comparable<Boolean>>, Integer> primitiveSizesMap = new IdentityHashMap<Class<Comparable<Boolean>>, Integer>();
        primitiveSizesMap.put(Boolean.TYPE, 1);
        primitiveSizesMap.put(Byte.TYPE, 1);
        primitiveSizesMap.put(Character.TYPE, 2);
        primitiveSizesMap.put(Short.TYPE, 2);
        primitiveSizesMap.put(Integer.TYPE, 4);
        primitiveSizesMap.put(Float.TYPE, 4);
        primitiveSizesMap.put(Double.TYPE, 8);
        primitiveSizesMap.put(Long.TYPE, 8);
        primitiveSizes = Collections.unmodifiableMap(primitiveSizesMap);
        if (Constants.JRE_IS_64BIT) {
            boolean isHotspot;
            int objectAlignment;
            boolean compressedOops;
            block10: {
                compressedOops = false;
                objectAlignment = 8;
                isHotspot = false;
                try {
                    Object vmOption;
                    Class<?> beanClazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                    Object hotSpotBean = Class.forName("java.lang.management.ManagementFactory").getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
                    if (hotSpotBean == null) break block10;
                    isHotspot = true;
                    Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                    try {
                        vmOption = getVMOptionMethod.invoke(hotSpotBean, "UseCompressedOops");
                        compressedOops = Boolean.parseBoolean(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        isHotspot = false;
                    }
                    try {
                        vmOption = getVMOptionMethod.invoke(hotSpotBean, "ObjectAlignmentInBytes");
                        objectAlignment = Integer.parseInt(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        isHotspot = false;
                    }
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    isHotspot = false;
                    Logger log = Logger.getLogger(RamUsageEstimator.class.getName());
                    Module module = RamUsageEstimator.class.getModule();
                    ModuleLayer layer = module.getLayer();
                    if (layer != null) {
                        if (!layer.findModule("jdk.management").map(module::canRead).orElse(false).booleanValue()) {
                            log.warning("Lucene cannot correctly calculate object sizes on 64bit JVMs, unless the 'jdk.management' Java module is readable [please add 'jdk.management' to modular application either by command line or its module descriptor]");
                        }
                    }
                    log.warning("Lucene cannot correctly calculate object sizes on 64bit JVMs that are not based on Hotspot or a compatible implementation.");
                }
            }
            JVM_IS_HOTSPOT_64BIT = isHotspot;
            COMPRESSED_REFS_ENABLED = compressedOops;
            NUM_BYTES_OBJECT_ALIGNMENT = objectAlignment;
            NUM_BYTES_OBJECT_REF = COMPRESSED_REFS_ENABLED ? 4 : 8;
            NUM_BYTES_OBJECT_HEADER = 8 + NUM_BYTES_OBJECT_REF;
            NUM_BYTES_ARRAY_HEADER = (int)RamUsageEstimator.alignObjectSize(NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            JVM_IS_HOTSPOT_64BIT = false;
            COMPRESSED_REFS_ENABLED = false;
            NUM_BYTES_OBJECT_ALIGNMENT = 8;
            NUM_BYTES_OBJECT_REF = 4;
            NUM_BYTES_OBJECT_HEADER = 8;
            NUM_BYTES_ARRAY_HEADER = NUM_BYTES_OBJECT_HEADER + 4;
        }
        INTEGER_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Integer.class);
        LONG_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Long.class);
        STRING_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(String.class);
        HASHTABLE_RAM_BYTES_PER_ENTRY = 2L * (long)NUM_BYTES_OBJECT_REF * 2L;
        LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY = HASHTABLE_RAM_BYTES_PER_ENTRY + 2L * (long)NUM_BYTES_OBJECT_REF;
    }
}

