/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.pqc.crypto.frodo;

import net.jsign.bouncycastle.crypto.Xof;
import net.jsign.bouncycastle.pqc.crypto.frodo.FrodoMatrixGenerator;

class FrodoEngine {
    private final int D;
    private final int q;
    private final int n;
    private final int B;
    private final int len_sk_bytes;
    private final int len_pk_bytes;
    private final int len_ct_bytes;
    private final short[] T_chi;
    private final int len_mu;
    private final int len_seedSE;
    private final int len_s;
    private final int len_k;
    private final int len_pkh;
    private final int len_ss;
    private final int len_mu_bytes;
    private final int len_seedSE_bytes;
    private final int len_s_bytes;
    private final int len_k_bytes;
    private final int len_pkh_bytes;
    private final int len_ss_bytes;
    private final Xof digest;
    private final FrodoMatrixGenerator gen;

    public FrodoEngine(int n, int n2, int n3, short[] sArray, Xof xof, FrodoMatrixGenerator frodoMatrixGenerator) {
        this.n = n;
        this.D = n2;
        this.q = 1 << n2;
        this.B = n3;
        this.len_seedSE = this.len_mu = n3 * 8 * 8;
        this.len_s = this.len_mu;
        this.len_k = this.len_mu;
        this.len_pkh = this.len_mu;
        this.len_ss = this.len_mu;
        this.len_mu_bytes = this.len_mu / 8;
        this.len_seedSE_bytes = this.len_seedSE / 8;
        this.len_s_bytes = this.len_s / 8;
        this.len_k_bytes = this.len_k / 8;
        this.len_pkh_bytes = this.len_pkh / 8;
        this.len_ss_bytes = this.len_ss / 8;
        this.len_ct_bytes = n2 * n * 8 / 8 + n2 * 8 * 8 / 8;
        this.len_pk_bytes = 16 + n2 * n * 8 / 8;
        this.len_sk_bytes = this.len_s_bytes + this.len_pk_bytes + (2 * n * 8 + this.len_pkh_bytes);
        this.T_chi = sArray;
        this.digest = xof;
        this.gen = frodoMatrixGenerator;
    }
}

