/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.json-io.util.io;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Map;
import net.jsign.json-io.util.io.JsonObject;
import net.jsign.json-io.util.io.JsonReader;
import net.jsign.json-io.util.io.MetaUtils;
import net.jsign.json-io.util.io.Resolver;

public class MapResolver
extends Resolver {
    protected MapResolver(JsonReader reader) {
        super(reader);
    }

    @Override
    protected Object readIfMatching(Object o, Class compType, Deque<JsonObject<String, Object>> stack) {
        return null;
    }

    @Override
    public void traverseFields(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        Object target = jsonObj.target;
        for (Map.Entry e : jsonObj.entrySet()) {
            String fieldName = (String)e.getKey();
            Field field = target != null ? MetaUtils.getField(target.getClass(), fieldName) : null;
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, null);
                continue;
            }
            if (rhs == "~!o~") {
                jsonObj.put(fieldName, new JsonObject());
                continue;
            }
            if (rhs.getClass().isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.put("@items", rhs);
                stack.addFirst(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                JsonObject jObj = (JsonObject)rhs;
                if (field != null && MetaUtils.isLogicalPrimitive(field.getType())) {
                    jObj.put("value", MetaUtils.convert(field.getType(), jObj.get("value")));
                    continue;
                }
                Long refId = jObj.getReferenceId();
                if (refId != null) {
                    JsonObject refObject = this.getReferencedObj(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                stack.addFirst(jObj);
                continue;
            }
            if (field == null) continue;
            Class<?> fieldType = field.getType();
            if (MetaUtils.isPrimitive(fieldType) || BigDecimal.class.equals(fieldType) || BigInteger.class.equals(fieldType) || Date.class.equals(fieldType)) {
                jsonObj.put(fieldName, MetaUtils.convert(fieldType, rhs));
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, null);
        }
        jsonObj.target = null;
    }

    @Override
    protected void traverseCollection(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return;
        }
        int idx = 0;
        ArrayList<Object> copy = new ArrayList<Object>(items.length);
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element == "~!o~") {
                copy.add(new JsonObject());
            } else {
                JsonObject jsonObject;
                copy.add(element);
                if (element instanceof Object[]) {
                    jsonObject = new JsonObject();
                    jsonObject.put("@items", element);
                    stack.addFirst(jsonObject);
                } else if (element instanceof JsonObject) {
                    jsonObject = (JsonObject)element;
                    Long refId = jsonObject.getReferenceId();
                    if (refId != null) {
                        JsonObject refObject = this.getReferencedObj(refId);
                        copy.set(idx, refObject);
                    } else {
                        stack.addFirst(jsonObject);
                    }
                }
                ++idx;
            }
            ++n2;
        }
        jsonObj.target = null;
        int i = 0;
        while (i < items.length) {
            items[i] = copy.get(i);
            ++i;
        }
    }

    @Override
    protected void traverseArray(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        this.traverseCollection(stack, jsonObj);
    }
}

