/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.spi;

import java.io.Serializable;
import net.jsign.log4j.Level;
import net.jsign.log4j.LogBuilder;
import net.jsign.log4j.LoggingException;
import net.jsign.log4j.Marker;
import net.jsign.log4j.MarkerManager;
import net.jsign.log4j.internal.DefaultLogBuilder;
import net.jsign.log4j.message.DefaultFlowMessageFactory;
import net.jsign.log4j.message.FlowMessageFactory;
import net.jsign.log4j.message.Message;
import net.jsign.log4j.message.MessageFactory;
import net.jsign.log4j.message.MessageFactory2;
import net.jsign.log4j.message.ParameterizedMessageFactory;
import net.jsign.log4j.message.ReusableMessageFactory;
import net.jsign.log4j.spi.ExtendedLogger;
import net.jsign.log4j.spi.MessageFactory2Adapter;
import net.jsign.log4j.status.StatusLogger;
import net.jsign.log4j.util.Constants;
import net.jsign.log4j.util.LoaderUtil;
import net.jsign.log4j.util.PropertiesUtil;
import net.jsign.log4j.util.StackLocatorUtil;

public abstract class AbstractLogger
implements Serializable,
ExtendedLogger {
    public static final Marker FLOW_MARKER = MarkerManager.getMarker("FLOW");
    public static final Marker ENTRY_MARKER = MarkerManager.getMarker("ENTER").setParents(FLOW_MARKER);
    public static final Marker EXIT_MARKER = MarkerManager.getMarker("EXIT").setParents(FLOW_MARKER);
    public static final Marker EXCEPTION_MARKER = MarkerManager.getMarker("EXCEPTION");
    public static final Marker THROWING_MARKER = MarkerManager.getMarker("THROWING").setParents(EXCEPTION_MARKER);
    public static final Marker CATCHING_MARKER = MarkerManager.getMarker("CATCHING").setParents(EXCEPTION_MARKER);
    public static final Class<? extends MessageFactory> DEFAULT_MESSAGE_FACTORY_CLASS = AbstractLogger.createClassForProperty("log4j2.messageFactory", ReusableMessageFactory.class, ParameterizedMessageFactory.class);
    public static final Class<? extends FlowMessageFactory> DEFAULT_FLOW_MESSAGE_FACTORY_CLASS = AbstractLogger.createFlowClassForProperty("log4j2.flowMessageFactory", DefaultFlowMessageFactory.class);
    private static final String FQCN = AbstractLogger.class.getName();
    protected final String name;
    private final MessageFactory2 messageFactory;
    private final FlowMessageFactory flowMessageFactory;
    private static final ThreadLocal<int[]> recursionDepthHolder = new ThreadLocal();
    protected final transient ThreadLocal<DefaultLogBuilder> logBuilder;

    public AbstractLogger() {
        this.name = this.getClass().getName();
        this.messageFactory = AbstractLogger.createDefaultMessageFactory();
        this.flowMessageFactory = AbstractLogger.createDefaultFlowMessageFactory();
        this.logBuilder = new LocalLogBuilder(this);
    }

    public AbstractLogger(String name, MessageFactory messageFactory) {
        this.name = name;
        this.messageFactory = messageFactory == null ? AbstractLogger.createDefaultMessageFactory() : AbstractLogger.narrow(messageFactory);
        this.flowMessageFactory = AbstractLogger.createDefaultFlowMessageFactory();
        this.logBuilder = new LocalLogBuilder(this);
    }

    public static void checkMessageFactory(ExtendedLogger logger, MessageFactory messageFactory) {
        String name = logger.getName();
        Object loggerMessageFactory = logger.getMessageFactory();
        if (messageFactory != null && !loggerMessageFactory.equals(messageFactory)) {
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with the message factory {}, which may create log events with unexpected formatting.", name, loggerMessageFactory, messageFactory);
        } else if (messageFactory == null && !loggerMessageFactory.getClass().equals(DEFAULT_MESSAGE_FACTORY_CLASS)) {
            StatusLogger.getLogger().warn("The Logger {} was created with the message factory {} and is now requested with a null message factory (defaults to {}), which may create log events with unexpected formatting.", name, loggerMessageFactory, DEFAULT_MESSAGE_FACTORY_CLASS.getName());
        }
    }

    private static Class<? extends MessageFactory> createClassForProperty(String property, Class<ReusableMessageFactory> reusableParameterizedMessageFactoryClass, Class<ParameterizedMessageFactory> parameterizedMessageFactoryClass) {
        try {
            String fallback = Constants.ENABLE_THREADLOCALS ? reusableParameterizedMessageFactoryClass.getName() : parameterizedMessageFactoryClass.getName();
            String clsName = PropertiesUtil.getProperties().getStringProperty(property, fallback);
            return LoaderUtil.loadClass(clsName).asSubclass(MessageFactory.class);
        }
        catch (Throwable throwable) {
            return parameterizedMessageFactoryClass;
        }
    }

    private static Class<? extends FlowMessageFactory> createFlowClassForProperty(String property, Class<DefaultFlowMessageFactory> defaultFlowMessageFactoryClass) {
        try {
            String clsName = PropertiesUtil.getProperties().getStringProperty(property, defaultFlowMessageFactoryClass.getName());
            return LoaderUtil.loadClass(clsName).asSubclass(FlowMessageFactory.class);
        }
        catch (Throwable throwable) {
            return defaultFlowMessageFactoryClass;
        }
    }

    private static MessageFactory2 createDefaultMessageFactory() {
        try {
            MessageFactory result = DEFAULT_MESSAGE_FACTORY_CLASS.newInstance();
            return AbstractLogger.narrow(result);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static MessageFactory2 narrow(MessageFactory result) {
        if (result instanceof MessageFactory2) {
            return (MessageFactory2)result;
        }
        return new MessageFactory2Adapter(result);
    }

    private static FlowMessageFactory createDefaultFlowMessageFactory() {
        try {
            return DEFAULT_FLOW_MESSAGE_FACTORY_CLASS.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void debug(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, p0);
    }

    @Override
    public void error(String message) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, null);
    }

    @Override
    public void error(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, p0);
    }

    @Override
    public void error(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, p0, p1);
    }

    @Override
    public void error(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, p0, p1, p2);
    }

    @Override
    public void fatal(String message, Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, throwable);
    }

    @Override
    public <MF extends MessageFactory> MF getMessageFactory() {
        return (MF)this.messageFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isEnabled(Level level) {
        return this.isEnabled(level, null, (Object)null, null);
    }

    public boolean isEnabled(Level level, Marker marker) {
        return this.isEnabled(level, marker, (Object)null, null);
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0) {
        if (this.isEnabled(level, marker, message, p0)) {
            this.logMessage(fqcn, level, marker, message, p0);
        }
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1) {
        if (this.isEnabled(level, marker, message, p0, p1)) {
            this.logMessage(fqcn, level, marker, message, p0, p1);
        }
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        if (this.isEnabled(level, marker, message, p0, p1, p2)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2);
        }
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3, p4);
        }
    }

    public void logIfEnabled(String fqcn, Level level, Marker marker, String message, Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            this.logMessage(fqcn, level, marker, message, throwable);
        }
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message, Throwable throwable) {
        this.logMessageSafely(fqcn, level, marker, this.messageFactory.newMessage(message), throwable);
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0) {
        Message msg = this.messageFactory.newMessage(message, p0);
        this.logMessageSafely(fqcn, level, marker, msg, msg.getThrowable());
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1) {
        Message msg = this.messageFactory.newMessage(message, p0, p1);
        this.logMessageSafely(fqcn, level, marker, msg, msg.getThrowable());
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        Message msg = this.messageFactory.newMessage(message, p0, p1, p2);
        this.logMessageSafely(fqcn, level, marker, msg, msg.getThrowable());
    }

    protected void logMessage(String fqcn, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        Message msg = this.messageFactory.newMessage(message, p0, p1, p2, p3, p4);
        this.logMessageSafely(fqcn, level, marker, msg, msg.getThrowable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable throwable) {
        try {
            AbstractLogger.incrementRecursionDepth();
            this.log(level, marker, fqcn, location, message, throwable);
        }
        catch (Throwable ex) {
            this.handleLogMessageException(ex, fqcn, message);
        }
        finally {
            AbstractLogger.decrementRecursionDepth();
            ReusableMessageFactory.release(message);
        }
    }

    protected void log(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable throwable) {
        this.logMessage(fqcn, level, marker, message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageSafely(String fqcn, Level level, Marker marker, Message message, Throwable throwable) {
        try {
            this.logMessageTrackRecursion(fqcn, level, marker, message, throwable);
        }
        finally {
            ReusableMessageFactory.release(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageTrackRecursion(String fqcn, Level level, Marker marker, Message message, Throwable throwable) {
        try {
            AbstractLogger.incrementRecursionDepth();
            this.tryLogMessage(fqcn, this.getLocation(fqcn), level, marker, message, throwable);
        }
        finally {
            AbstractLogger.decrementRecursionDepth();
        }
    }

    private static int[] getRecursionDepthHolder() {
        int[] result = recursionDepthHolder.get();
        if (result == null) {
            result = new int[1];
            recursionDepthHolder.set(result);
        }
        return result;
    }

    private static void incrementRecursionDepth() {
        int[] nArray = AbstractLogger.getRecursionDepthHolder();
        nArray[0] = nArray[0] + 1;
    }

    private static void decrementRecursionDepth() {
        int[] nArray = AbstractLogger.getRecursionDepthHolder();
        nArray[0] = nArray[0] - 1;
        int newDepth = nArray[0];
        if (newDepth < 0) {
            throw new IllegalStateException("Recursion depth became negative: " + newDepth);
        }
    }

    private void tryLogMessage(String fqcn, StackTraceElement location, Level level, Marker marker, Message message, Throwable throwable) {
        try {
            this.log(level, marker, fqcn, location, message, throwable);
        }
        catch (Throwable t) {
            this.handleLogMessageException(t, fqcn, message);
        }
    }

    private StackTraceElement getLocation(String fqcn) {
        return this.requiresLocation() ? StackLocatorUtil.calcLocation(fqcn) : null;
    }

    private void handleLogMessageException(Throwable throwable, String fqcn, Message message) {
        if (throwable instanceof LoggingException) {
            throw (LoggingException)throwable;
        }
        StatusLogger.getLogger().warn("{} caught {} logging {}: {}", fqcn, throwable.getClass().getName(), message.getClass().getSimpleName(), message.getFormat(), throwable);
    }

    @Override
    public void warn(String message) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, null);
    }

    @Override
    public void warn(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, p0);
    }

    @Override
    public void warn(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, p0, p1);
    }

    @Override
    public void warn(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, p0, p1, p2);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, p0, p1, p2, p3, p4);
    }

    protected boolean requiresLocation() {
        return false;
    }

    @Override
    public LogBuilder atDebug() {
        return this.atLevel(Level.DEBUG);
    }

    @Override
    public LogBuilder atWarn() {
        return this.atLevel(Level.WARN);
    }

    @Override
    public LogBuilder atError() {
        return this.atLevel(Level.ERROR);
    }

    public LogBuilder atLevel(Level level) {
        if (this.isEnabled(level)) {
            return this.getLogBuilder(level).reset(level);
        }
        return LogBuilder.NOOP;
    }

    private DefaultLogBuilder getLogBuilder(Level level) {
        DefaultLogBuilder builder = this.logBuilder.get();
        return Constants.ENABLE_THREADLOCALS && !builder.isInUse() ? builder : new DefaultLogBuilder(this, level);
    }

    private class LocalLogBuilder
    extends ThreadLocal<DefaultLogBuilder> {
        private AbstractLogger logger;

        LocalLogBuilder(AbstractLogger logger) {
            this.logger = logger;
        }

        @Override
        protected DefaultLogBuilder initialValue() {
            return new DefaultLogBuilder(this.logger);
        }
    }
}

