/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.jsign.log4j.util.LowLevelLogUtil;
import net.jsign.log4j.util.PropertyFilePropertySource;
import net.jsign.log4j.util.PropertySource;
import net.jsign.log4j.util.ServiceLoaderUtil;

public final class PropertiesUtil {
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties", false);
    private final Environment environment;

    public PropertiesUtil(String propertiesFileName) {
        this(propertiesFileName, true);
    }

    private PropertiesUtil(String propertiesFileName, boolean useTccl) {
        this(new PropertyFilePropertySource(propertiesFileName, useTccl));
    }

    PropertiesUtil(PropertySource source) {
        this.environment = new Environment(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadClose(InputStream in, Object source) {
        Properties props = new Properties();
        if (null != in) {
            try {
                props.load(in);
            }
            catch (IOException e) {
                LowLevelLogUtil.logException("Unable to read " + source, e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LowLevelLogUtil.logException("Unable to close " + source, e);
                }
            }
        }
        return props;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public boolean getBooleanProperty(String name, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValueIfAbsent : (prop.isEmpty() ? defaultValueIfPresent : "true".equalsIgnoreCase(prop));
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Integer.parseInt(prop.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getStringProperty(String name) {
        return this.environment.get(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    private static class Environment {
        private final Set<PropertySource> sources = new TreeSet<PropertySource>(new PropertySource.Comparator());
        private final Map<String, String> literal = new ConcurrentHashMap<String, String>();
        private final Map<String, String> normalized = new ConcurrentHashMap<String, String>();
        private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

        private Environment(PropertySource propertySource) {
            PropertyFilePropertySource sysProps = new PropertyFilePropertySource("log4j2.system.properties", false);
            try {
                sysProps.forEach((key, value) -> {
                    if (System.getProperty(key) == null) {
                        System.setProperty(key, value);
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.sources.add(propertySource);
            ServiceLoaderUtil.loadServices(PropertySource.class, MethodHandles.lookup(), false, false).forEach(this.sources::add);
            this.reload();
        }

        private synchronized void reload() {
            this.literal.clear();
            this.normalized.clear();
            this.tokenized.clear();
            HashSet keys = new HashSet();
            this.sources.stream().map(PropertySource::getPropertyNames).reduce(keys, (left, right) -> {
                left.addAll(right);
                return left;
            });
            keys.stream().filter(Objects::nonNull).forEach(key -> {
                List<CharSequence> tokens = PropertySource.Util.tokenize(key);
                this.sources.forEach(source -> {
                    String normalValue;
                    CharSequence normalKey;
                    String value = source.getProperty((String)key);
                    if (value != null) {
                        this.literal.putIfAbsent((String)key, value);
                        if (!tokens.isEmpty()) {
                            this.tokenized.putIfAbsent(tokens, value);
                        }
                    }
                    if ((normalKey = source.getNormalForm(tokens)) != null && (normalValue = source.getProperty(normalKey.toString())) != null) {
                        this.normalized.putIfAbsent((String)key, normalValue);
                    }
                });
            });
        }

        private String get(String key) {
            if (this.normalized.containsKey(key)) {
                return this.normalized.get(key);
            }
            if (this.literal.containsKey(key)) {
                return this.literal.get(key);
            }
            List<CharSequence> tokens = PropertySource.Util.tokenize(key);
            for (PropertySource source : this.sources) {
                String normalKey = Objects.toString(source.getNormalForm(tokens), null);
                if (normalKey != null && source.containsProperty(normalKey)) {
                    String normalValue = source.getProperty(normalKey);
                    return normalValue;
                }
                if (!source.containsProperty(key)) continue;
                String value = source.getProperty(key);
                return value;
            }
            return this.tokenized.get(tokens);
        }
    }
}

