/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.poi.util;

public final class LittleEndian {
    public static int getInt(byte[] data) {
        return LittleEndian.getInt(data, 0);
    }

    public static int getInt(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        int b2 = data[i++] & 0xFF;
        int b3 = data[i] & 0xFF;
        return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
    }

    public static long getLong(byte[] data, int offset) {
        long result = 0xFF & data[offset + 7];
        for (int j = offset + 8 - 1; j >= offset; --j) {
            result <<= 8;
            result |= (long)(0xFF & data[j]);
        }
        return result;
    }

    public static short getShort(byte[] data, int offset) {
        int b0 = data[offset] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        return (short)((b1 << 8) + b0);
    }

    public static void putInt(byte[] data, int offset, int value) {
        int i = offset;
        data[i++] = (byte)(value & 0xFF);
        data[i++] = (byte)(value >>> 8 & 0xFF);
        data[i++] = (byte)(value >>> 16 & 0xFF);
        data[i] = (byte)(value >>> 24 & 0xFF);
    }

    public static void putLong(byte[] data, int offset, long value) {
        data[offset] = (byte)(value & 0xFFL);
        data[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        data[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        data[offset + 3] = (byte)(value >>> 24 & 0xFFL);
        data[offset + 4] = (byte)(value >>> 32 & 0xFFL);
        data[offset + 5] = (byte)(value >>> 40 & 0xFFL);
        data[offset + 6] = (byte)(value >>> 48 & 0xFFL);
        data[offset + 7] = (byte)(value >>> 56 & 0xFFL);
    }

    public static void putShort(byte[] data, int offset, short value) {
        int i = offset;
        data[i++] = (byte)(value & 0xFF);
        data[i] = (byte)(value >>> 8 & 0xFF);
    }
}

