/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.DefaultFormSubmissionListener;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.FormFieldFactory;
import org.xhtmlrenderer.util.XRLog;

public class XhtmlForm {
    private static final String FS_DEFAULT_GROUP = "__fs_default_group_";
    private static int _defaultGroupCount = 1;
    private final UserAgentCallback _userAgentCallback;
    private final Map _componentCache;
    private final Map _buttonGroups;
    private final Element _parentFormElement;
    private final FormSubmissionListener _formSubmissionListener;

    public XhtmlForm(UserAgentCallback uac, Element e, FormSubmissionListener fsListener) {
        this._userAgentCallback = uac;
        this._buttonGroups = new HashMap();
        this._componentCache = new LinkedHashMap();
        this._parentFormElement = e;
        this._formSubmissionListener = fsListener;
    }

    public XhtmlForm(UserAgentCallback uac, Element e) {
        this(uac, e, new DefaultFormSubmissionListener());
    }

    public UserAgentCallback getUserAgentCallback() {
        return this._userAgentCallback;
    }

    public void addButtonToGroup(String groupName, AbstractButton button) {
        ButtonGroupWrapper group;
        if (groupName == null) {
            groupName = XhtmlForm.createNewDefaultGroupName();
        }
        if ((group = (ButtonGroupWrapper)this._buttonGroups.get(groupName)) == null) {
            group = new ButtonGroupWrapper();
            this._buttonGroups.put(groupName, group);
        }
        group.add(button);
    }

    private static String createNewDefaultGroupName() {
        return FS_DEFAULT_GROUP + ++_defaultGroupCount;
    }

    private static boolean isFormField(Element e) {
        String nodeName = e.getNodeName();
        return nodeName.equals("input") || nodeName.equals("select") || nodeName.equals("textarea");
    }

    public FormField addComponent(Element e, LayoutContext context, BlockBox box) {
        FormField field;
        if (this._componentCache.containsKey(e)) {
            field = (FormField)this._componentCache.get(e);
        } else {
            if (!XhtmlForm.isFormField(e)) {
                return null;
            }
            field = FormFieldFactory.create(this, context, box);
            if (field == null) {
                XRLog.layout("Unknown field type: " + e.getNodeName());
                return null;
            }
            this._componentCache.put(e, field);
        }
        return field;
    }

    public void reset() {
        for (Object value : this._buttonGroups.values()) {
            ((ButtonGroupWrapper)value).clearSelection();
        }
        for (Object o : this._componentCache.values()) {
            ((FormField)o).reset();
        }
    }

    public void submit(JComponent source) {
        if (this._parentFormElement == null) {
            return;
        }
        StringBuilder data = new StringBuilder();
        String action = this._parentFormElement.getAttribute("action");
        data.append(action).append("?");
        Iterator fields = this._componentCache.entrySet().iterator();
        boolean first = true;
        while (fields.hasNext()) {
            String[] dataStrings;
            Map.Entry entry = fields.next();
            FormField field = (FormField)entry.getValue();
            if (!field.includeInSubmission(source)) continue;
            for (String dataString : dataStrings = field.getFormDataStrings()) {
                if (!first) {
                    data.append('&');
                }
                data.append(dataString);
                first = false;
            }
        }
        if (this._formSubmissionListener != null) {
            this._formSubmissionListener.submit(data.toString());
        }
    }

    public static String collectText(Element e) {
        StringBuilder result = new StringBuilder();
        Node node = e.getFirstChild();
        if (node != null) {
            do {
                short nodeType;
                if ((nodeType = node.getNodeType()) != 3 && nodeType != 4) continue;
                Text text = (Text)node;
                result.append(text.getData());
            } while ((node = node.getNextSibling()) != null);
        }
        return result.toString().trim();
    }

    private static class ButtonGroupWrapper {
        private final ButtonGroup _group = new ButtonGroup();
        private final AbstractButton _dummy = new JRadioButton();

        public ButtonGroupWrapper() {
            this._group.add(this._dummy);
        }

        public void add(AbstractButton b) {
            this._group.add(b);
        }

        public void clearSelection() {
            this._group.setSelected(this._dummy.getModel(), true);
        }
    }
}

