/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.hyph;

import com.whitemagicsoftware.keentype.hyph.KtWordMap;
import java.io.Serializable;
import java.util.Objects;

public class KtWordTree
implements KtWordMap {
    public static final KtWordTree NULL = null;
    public static final Entry NULL_ENTRY = null;
    private final Entry root = new Entry('\u0000', NULL_ENTRY);
    private char maxCode = '\u0000';
    public static final KtPack NULL_PACK = null;

    private static boolean sameObjects(Object x, Object y) {
        return Objects.equals(x, y);
    }

    private Entry find(Entry from, char code) {
        Entry ent = from.below;
        while (ent != NULL_ENTRY) {
            if (code == ent.code) {
                return ent;
            }
            if (code < ent.code) break;
            ent = ent.next;
        }
        return NULL_ENTRY;
    }

    private Entry get(Entry from, char code) {
        boolean first = true;
        Entry ent = from.below;
        while (ent != NULL_ENTRY) {
            if (code == ent.code) {
                return ent;
            }
            if (code < ent.code) break;
            first = false;
            from = ent;
            ent = from.next;
        }
        ent = new Entry(code, ent);
        if (first) {
            from.below = ent;
        } else {
            from.next = ent;
        }
        if (this.maxCode < code) {
            this.maxCode = code;
        }
        return ent;
    }

    private Entry find(Entry from, String word) {
        for (int i = 0; i < word.length() && from != NULL_ENTRY; ++i) {
            from = this.find(from, word.charAt(i));
        }
        return from;
    }

    private Entry get(Entry from, String word) {
        for (int i = 0; i < word.length(); ++i) {
            from = this.get(from, word.charAt(i));
        }
        return from;
    }

    @Override
    public Object get(String word) {
        Entry ent = this.find(this.root, word);
        return ent != NULL_ENTRY ? ent.value : null;
    }

    @Override
    public Object put(String word, Object value) {
        Entry ent = this.get(this.root, word);
        Object old = ent.value;
        ent.value = value;
        return old;
    }

    @Override
    public KtWordMap.KtSeeker seeker() {
        return new KtSeeker();
    }

    private static class Entry
    implements Serializable {
        final char code;
        Object value;
        Entry below;
        Entry next;

        public Entry(char code, Entry next) {
            this.code = code;
            this.value = null;
            this.below = NULL_ENTRY;
            this.next = next;
        }
    }

    public class KtSeeker
    implements KtWordMap.KtSeeker {
        private Entry curr;

        public KtSeeker() {
            this.curr = KtWordTree.this.root;
        }

        @Override
        public void reset() {
            this.curr = KtWordTree.this.root;
        }

        @Override
        public boolean isValid() {
            return this.curr != NULL_ENTRY;
        }

        @Override
        public void seek(char code) {
            if (this.curr != NULL_ENTRY) {
                this.curr = KtWordTree.this.find(this.curr, code);
            }
        }

        @Override
        public Object get() {
            return this.curr != NULL_ENTRY ? this.curr.value : null;
        }
    }

    private record KtPack(char code, Object value, KtPack below, KtPack next) {
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof KtPack)) {
                return false;
            }
            KtPack that = (KtPack)obj;
            return this.code == that.code && KtWordTree.sameObjects(this.value, that.value) && this.below == that.below && this.next == that.next;
        }

        @Override
        public int hashCode() {
            int h = 191 * this.code;
            if (this.value != null) {
                h += 313 * this.value.hashCode();
            }
            if (this.below != NULL_PACK) {
                h += 1009 * this.below.hashCode();
            }
            if (this.next != NULL_PACK) {
                h += 1571 * this.next.hashCode();
            }
            return h;
        }
    }
}

