/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tex;

import com.whitemagicsoftware.keentype.command.KtFileName;
import com.whitemagicsoftware.keentype.io.KtClassPathResources;
import com.whitemagicsoftware.keentype.tex.KtFileFormat;
import com.whitemagicsoftware.keentype.tex.KtFileHandler;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public final class KtFileOpener {
    private static final KtFileHandler FILE_HANDLER = InputStream::close;
    private final Map<KtFileFormat, KtFileHandler> mHandlers = new HashMap<KtFileFormat, KtFileHandler>(8);

    public void attachHandler(KtFileFormat format, KtFileHandler handler) {
        assert (format != null);
        assert (handler != null);
        this.mHandlers.put(format, handler);
    }

    public void detachHandler(KtFileFormat format) {
        assert (format != null);
        this.mHandlers.remove((Object)format);
    }

    public void read(KtFileName name, KtFileFormat ... formats) throws IOException, FontFormatException {
        String path = name.getPath();
        Optional<URI> uri = KtFileOpener.findFile(path, formats);
        URL url = uri.isPresent() ? uri.get().toURL() : new File(path).toURI().toURL();
        for (KtFileFormat format : formats) {
            if (!format.matches(url)) continue;
            KtFileHandler handler = this.mHandlers.getOrDefault((Object)format, FILE_HANDLER);
            InputStream stream = url.openStream();
            handler.handle(stream);
        }
    }

    public static InputStream readFile(KtFileName name, KtFileFormat format) {
        assert (name != null);
        assert (format != null);
        KtFileOpener opener = new KtFileOpener();
        AtomicReference<InputStream> stream = new AtomicReference<InputStream>(InputStream.nullInputStream());
        try {
            opener.attachHandler(format, stream::set);
            opener.read(name, format);
        }
        catch (FontFormatException e) {
            throw new UncheckedIOException(new IOException(e));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            opener.detachHandler(format);
        }
        return stream.get();
    }

    public static OutputStream write(KtFileName name, KtFileFormat format) throws IOException {
        assert (name != null);
        assert (format != null);
        name.addDefaultExt(format.toString());
        String path = name.getPath();
        return new FileOutputStream(path);
    }

    private static Optional<URI> findFile(String name, KtFileFormat ... formats) {
        assert (name != null);
        assert (!name.isBlank());
        assert (formats != null);
        assert (formats.length > 0);
        StringBuilder regex = new StringBuilder(128);
        regex.append(".*");
        regex.append(name);
        regex.append("(\\.(");
        String sep = "";
        for (KtFileFormat format : formats) {
            regex.append(sep);
            regex.append((Object)format);
            sep = "|";
        }
        regex.append("))$");
        Pattern pattern = Pattern.compile(regex.toString());
        return KtClassPathResources.getResource(pattern);
    }
}

