/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.message;

import java.util.Arrays;
import net.jsign.log4j.message.Clearable;
import net.jsign.log4j.message.ParameterFormatter;
import net.jsign.log4j.message.ReusableMessage;
import net.jsign.log4j.util.Constants;
import net.jsign.log4j.util.StringBuilders;

public class ReusableParameterizedMessage
implements Clearable,
ReusableMessage {
    private transient ThreadLocal<StringBuilder> buffer;
    private String messagePattern;
    private int argCount;
    private int usedCount;
    private final int[] indices = new int[256];
    private transient Object[] varargs;
    private transient Object[] params = new Object[10];
    private transient Throwable throwable;
    transient boolean reserved = false;

    private Object[] getTrimmedParams() {
        return this.varargs == null ? Arrays.copyOf(this.params, this.argCount) : this.varargs;
    }

    private Object[] getParams() {
        return this.varargs == null ? this.params : this.varargs;
    }

    private void init(String messagePattern, int argCount, Object[] paramArray) {
        this.varargs = null;
        this.messagePattern = messagePattern;
        this.argCount = argCount;
        int placeholderCount = ReusableParameterizedMessage.count(messagePattern, this.indices);
        this.initThrowable(paramArray, argCount, placeholderCount);
        this.usedCount = Math.min(placeholderCount, argCount);
    }

    private static int count(String messagePattern, int[] indices) {
        try {
            return ParameterFormatter.countArgumentPlaceholders2(messagePattern, indices);
        }
        catch (Exception ex) {
            return ParameterFormatter.countArgumentPlaceholders(messagePattern);
        }
    }

    private void initThrowable(Object[] params, int argCount, int usedParams) {
        this.throwable = usedParams < argCount && params[argCount - 1] instanceof Throwable ? (Throwable)params[argCount - 1] : null;
    }

    ReusableParameterizedMessage set(String messagePattern, Object ... arguments) {
        this.init(messagePattern, arguments == null ? 0 : arguments.length, arguments);
        this.varargs = arguments;
        return this;
    }

    ReusableParameterizedMessage set(String messagePattern, Object p0) {
        this.params[0] = p0;
        this.init(messagePattern, 1, this.params);
        return this;
    }

    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1) {
        this.params[0] = p0;
        this.params[1] = p1;
        this.init(messagePattern, 2, this.params);
        return this;
    }

    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2) {
        this.params[0] = p0;
        this.params[1] = p1;
        this.params[2] = p2;
        this.init(messagePattern, 3, this.params);
        return this;
    }

    ReusableParameterizedMessage set(String messagePattern, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.params[0] = p0;
        this.params[1] = p1;
        this.params[2] = p2;
        this.params[3] = p3;
        this.params[4] = p4;
        this.init(messagePattern, 5, this.params);
        return this;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        return this.getTrimmedParams();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getFormattedMessage() {
        StringBuilder sb = this.getBuffer();
        this.formatTo(sb);
        String result = sb.toString();
        StringBuilders.trimToMaxSize(sb, Constants.MAX_REUSABLE_MESSAGE_SIZE);
        return result;
    }

    private StringBuilder getBuffer() {
        StringBuilder result;
        if (this.buffer == null) {
            this.buffer = new ThreadLocal();
        }
        if ((result = this.buffer.get()) == null) {
            int currentPatternLength = this.messagePattern == null ? 0 : this.messagePattern.length();
            result = new StringBuilder(Math.max(512, currentPatternLength * 2));
            this.buffer.set(result);
        }
        result.setLength(0);
        return result;
    }

    @Override
    public void formatTo(StringBuilder builder) {
        if (this.indices[0] < 0) {
            ParameterFormatter.formatMessage(builder, this.messagePattern, this.getParams(), this.argCount);
        } else {
            ParameterFormatter.formatMessage2(builder, this.messagePattern, this.getParams(), this.usedCount, this.indices);
        }
    }

    ReusableParameterizedMessage reserve() {
        this.reserved = true;
        return this;
    }

    public String toString() {
        return "ReusableParameterizedMessage[messagePattern=" + this.getFormat() + ", stringArgs=" + Arrays.toString(this.getParameters()) + ", throwable=" + this.getThrowable() + ']';
    }

    @Override
    public void clear() {
        this.reserved = false;
        this.varargs = null;
        this.messagePattern = null;
        this.throwable = null;
    }
}

