/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rxp90.jsymspell;

import io.gitlab.rxp90.jsymspell.SymSpell;
import io.gitlab.rxp90.jsymspell.SymSpellBuilder;
import io.gitlab.rxp90.jsymspell.Verbosity;
import io.gitlab.rxp90.jsymspell.api.Bigram;
import io.gitlab.rxp90.jsymspell.api.StringDistance;
import io.gitlab.rxp90.jsymspell.api.SuggestItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SymSpellImpl
implements SymSpell {
    private static final long BIGRAM_COUNT_MIN = Long.MAX_VALUE;
    private final int maxDictionaryEditDistance;
    private final int prefixLength;
    private final Map<String, Collection<String>> deletes = new ConcurrentHashMap<String, Collection<String>>();
    private final Map<Bigram, Long> bigramLexicon;
    private final Map<String, Long> unigramLexicon;
    private final StringDistance stringDistance;
    private final int maxDictionaryWordLength;
    private final long n;

    SymSpellImpl(SymSpellBuilder builder) {
        this.unigramLexicon = new HashMap<String, Long>(builder.getUnigramLexicon());
        this.maxDictionaryEditDistance = builder.getMaxDictionaryEditDistance();
        this.prefixLength = builder.getPrefixLength();
        this.bigramLexicon = new HashMap<Bigram, Long>(builder.getBigramLexicon());
        this.stringDistance = builder.getStringDistanceAlgorithm();
        this.n = this.unigramLexicon.values().stream().reduce(Long::sum).orElse(0L);
        this.unigramLexicon.keySet().forEach(word -> {
            Map<String, Collection<String>> edits = this.generateEdits((String)word);
            edits.forEach((string, suggestions) -> this.deletes.computeIfAbsent((String)string, ignored -> new ArrayList()).addAll(suggestions));
        });
        this.maxDictionaryWordLength = this.unigramLexicon.keySet().stream().map(String::length).max(Integer::compareTo).orElse(0);
    }

    private boolean deleteSuggestionPrefix(String delete, int deleteLen, String suggestion, int suggestionLen) {
        if (deleteLen == 0) {
            return true;
        }
        int adjustedSuggestionLen = Math.min(this.prefixLength, suggestionLen);
        int j = 0;
        for (int i = 0; i < deleteLen; ++i) {
            char delChar = delete.charAt(i);
            while (j < adjustedSuggestionLen && delChar != suggestion.charAt(j)) {
                ++j;
            }
            if (j != adjustedSuggestionLen) continue;
            return false;
        }
        return true;
    }

    Set<String> edits(String word, int editDistance, Set<String> deleteWords) {
        if (word.length() > 1 && ++editDistance <= this.maxDictionaryEditDistance) {
            for (int i = 0; i < word.length(); ++i) {
                StringBuilder editableWord = new StringBuilder(word);
                String delete = editableWord.deleteCharAt(i).toString();
                if (!deleteWords.add(delete) || editDistance >= this.maxDictionaryEditDistance) continue;
                this.edits(delete, editDistance, deleteWords);
            }
        }
        return deleteWords;
    }

    private Map<String, Collection<String>> generateEdits(String key) {
        Set<String> edits = this.editsPrefix(key);
        HashMap<String, Collection<String>> generatedDeletes = new HashMap<String, Collection<String>>();
        edits.forEach(delete -> generatedDeletes.computeIfAbsent((String)delete, ignored -> new ArrayList()).add(key));
        return generatedDeletes;
    }

    private Set<String> editsPrefix(String key) {
        HashSet<String> set = new HashSet<String>();
        if (key.length() <= this.maxDictionaryEditDistance) {
            set.add("");
        }
        if (key.length() > this.prefixLength) {
            key = key.substring(0, this.prefixLength);
        }
        set.add(key);
        return this.edits(key, 0, set);
    }

    @Override
    public List<SuggestItem> lookup(String input, Verbosity verbosity, boolean includeUnknown) {
        return this.lookup(input, verbosity, this.maxDictionaryEditDistance, includeUnknown);
    }

    @Override
    public List<SuggestItem> lookup(String input, Verbosity verbosity) {
        return this.lookup(input, verbosity, false);
    }

    private List<SuggestItem> lookup(String input, Verbosity verbosity, int maxEditDistance, boolean includeUnknown) {
        int inputPrefixLen;
        boolean wordIsTooLong;
        if (maxEditDistance > this.maxDictionaryEditDistance) {
            throw new IllegalArgumentException("maxEditDistance > maxDictionaryEditDistance");
        }
        ArrayList<SuggestItem> suggestions = new ArrayList<SuggestItem>();
        int inputLen = input.length();
        boolean bl = wordIsTooLong = inputLen - maxEditDistance > this.maxDictionaryWordLength;
        if (wordIsTooLong && includeUnknown) {
            return Arrays.asList(new SuggestItem(input, maxEditDistance + 1, 0.0));
        }
        if (this.unigramLexicon.containsKey(input)) {
            SuggestItem suggestSameWord = new SuggestItem(input, 0, this.unigramLexicon.get(input).longValue());
            suggestions.add(suggestSameWord);
            if (!verbosity.equals((Object)Verbosity.ALL)) {
                return suggestions;
            }
        }
        if (maxEditDistance == 0 && includeUnknown && suggestions.isEmpty()) {
            return Arrays.asList(new SuggestItem(input, maxEditDistance + 1, 0.0));
        }
        HashSet<String> deletesAlreadyConsidered = new HashSet<String>();
        ArrayList<String> candidates = new ArrayList<String>();
        if (inputLen > this.prefixLength) {
            inputPrefixLen = this.prefixLength;
            candidates.add(input.substring(0, inputPrefixLen));
        } else {
            inputPrefixLen = inputLen;
        }
        candidates.add(input);
        HashSet<String> suggestionsAlreadyConsidered = new HashSet<String>();
        suggestionsAlreadyConsidered.add(input);
        int maxEditDistance2 = maxEditDistance;
        int candidatePointer = 0;
        while (candidatePointer < candidates.size()) {
            Collection<String> preCalculatedDeletes;
            String candidate;
            int candidateLength;
            int lengthDiffBetweenInputAndCandidate;
            boolean candidateDistanceHigherThanSuggestionDistance;
            boolean bl2 = candidateDistanceHigherThanSuggestionDistance = (lengthDiffBetweenInputAndCandidate = inputPrefixLen - (candidateLength = (candidate = (String)candidates.get(candidatePointer++)).length())) > maxEditDistance2;
            if (candidateDistanceHigherThanSuggestionDistance) {
                if (!verbosity.equals((Object)Verbosity.ALL)) break;
                continue;
            }
            if (lengthDiffBetweenInputAndCandidate < maxEditDistance && candidateLength <= this.prefixLength) {
                if (!verbosity.equals((Object)Verbosity.ALL) && lengthDiffBetweenInputAndCandidate >= maxEditDistance2) continue;
                candidates.addAll(this.generateNewCandidates(candidate, deletesAlreadyConsidered));
            }
            if ((preCalculatedDeletes = this.deletes.get(candidate)) == null) continue;
            for (String preCalculatedDelete : preCalculatedDeletes) {
                int distance;
                if (preCalculatedDelete.equals(input) || Math.abs(preCalculatedDelete.length() - inputLen) > maxEditDistance2 || preCalculatedDelete.length() < candidateLength || preCalculatedDelete.length() == candidateLength && !preCalculatedDelete.equals(candidate) || Math.min(preCalculatedDelete.length(), this.prefixLength) > inputPrefixLen && Math.min(preCalculatedDelete.length(), this.prefixLength) - candidateLength > maxEditDistance2) continue;
                if (candidateLength == 0) {
                    distance = Math.max(inputLen, preCalculatedDelete.length());
                    if (distance > maxEditDistance2) continue;
                    suggestionsAlreadyConsidered.add(preCalculatedDelete);
                    continue;
                }
                if (preCalculatedDelete.length() == 1) {
                    distance = input.contains(preCalculatedDelete) ? inputLen - 1 : inputLen;
                    if (distance > maxEditDistance2) continue;
                    suggestionsAlreadyConsidered.add(preCalculatedDelete);
                    continue;
                }
                int minDistance = Math.min(inputLen, preCalculatedDelete.length()) - this.prefixLength;
                boolean noDistanceCalculationIsRequired = this.prefixLength - maxEditDistance == candidateLength && minDistance > 1 && !input.substring(inputLen + 1 - minDistance).equals(preCalculatedDelete.substring(preCalculatedDelete.length() + 1 - minDistance)) || minDistance > 0 && input.charAt(inputLen - minDistance) != preCalculatedDelete.charAt(preCalculatedDelete.length() - minDistance) && input.charAt(inputLen - minDistance - 1) != preCalculatedDelete.charAt(preCalculatedDelete.length() - minDistance) && input.charAt(inputLen - minDistance) != preCalculatedDelete.charAt(preCalculatedDelete.length() - minDistance - 1);
                if (noDistanceCalculationIsRequired || !verbosity.equals((Object)Verbosity.ALL) && !this.deleteSuggestionPrefix(candidate, candidateLength, preCalculatedDelete, preCalculatedDelete.length()) || !suggestionsAlreadyConsidered.add(preCalculatedDelete) || (distance = this.stringDistance.distanceWithEarlyStop(input, preCalculatedDelete, maxEditDistance2)) < 0 || distance > maxEditDistance2) continue;
                SuggestItem suggestItem = new SuggestItem(preCalculatedDelete, distance, this.unigramLexicon.get(preCalculatedDelete).longValue());
                if (!suggestions.isEmpty()) {
                    if (verbosity.equals((Object)Verbosity.CLOSEST) && distance < maxEditDistance2) {
                        suggestions.clear();
                    } else if (verbosity.equals((Object)Verbosity.TOP) && (distance < maxEditDistance2 || suggestItem.getFrequencyOfSuggestionInDict() > ((SuggestItem)suggestions.get(0)).getFrequencyOfSuggestionInDict())) {
                        maxEditDistance2 = distance;
                        suggestions.add(suggestItem);
                    }
                }
                if (!verbosity.equals((Object)Verbosity.ALL)) {
                    maxEditDistance2 = distance;
                }
                suggestions.add(suggestItem);
            }
        }
        if (suggestions.size() > 1) {
            Collections.sort(suggestions);
        }
        if (includeUnknown && suggestions.isEmpty()) {
            SuggestItem noSuggestionsFound = new SuggestItem(input, maxEditDistance + 1, 0.0);
            suggestions.add(noSuggestionsFound);
        }
        return suggestions;
    }

    private Set<String> generateNewCandidates(String candidate, Set<String> deletesAlreadyConsidered) {
        HashSet<String> newDeletes = new HashSet<String>();
        for (int i = 0; i < candidate.length(); ++i) {
            StringBuilder editableString = new StringBuilder(candidate);
            String delete = editableString.deleteCharAt(i).toString();
            if (!deletesAlreadyConsidered.add(delete)) continue;
            newDeletes.add(delete);
        }
        return newDeletes;
    }

    @Override
    public List<SuggestItem> lookupCompound(String input, int editDistanceMax, boolean includeUnknown) {
        String[] termList = input.split(" ");
        ArrayList<SuggestItem> suggestionParts = new ArrayList<SuggestItem>();
        boolean lastCombination = false;
        for (int i = 0; i < termList.length; ++i) {
            SuggestItem bestSuggestion;
            Optional<SuggestItem> newSuggestion;
            String currentToken = termList[i];
            List<SuggestItem> suggestionsForCurrentToken = this.lookup(currentToken, Verbosity.TOP, editDistanceMax, includeUnknown);
            if (i > 0 && !lastCombination && (newSuggestion = this.combineWords(editDistanceMax, includeUnknown, currentToken, termList[i - 1], bestSuggestion = (SuggestItem)suggestionParts.get(suggestionParts.size() - 1), suggestionsForCurrentToken.isEmpty() ? null : suggestionsForCurrentToken.get(0))).isPresent()) {
                suggestionParts.set(suggestionParts.size() - 1, newSuggestion.get());
                lastCombination = true;
                continue;
            }
            lastCombination = false;
            if (!suggestionsForCurrentToken.isEmpty()) {
                boolean firstSuggestionIsPerfect;
                boolean bl = firstSuggestionIsPerfect = suggestionsForCurrentToken.get(0).getEditDistance() == 0;
                if (firstSuggestionIsPerfect || currentToken.length() == 1) {
                    suggestionParts.add(suggestionsForCurrentToken.get(0));
                    continue;
                }
                this.splitWords(editDistanceMax, termList, suggestionsForCurrentToken, suggestionParts, i);
                continue;
            }
            this.splitWords(editDistanceMax, termList, suggestionsForCurrentToken, suggestionParts, i);
        }
        double freq = this.n;
        StringBuilder stringBuilder = new StringBuilder();
        for (SuggestItem suggestItem : suggestionParts) {
            stringBuilder.append(suggestItem.getSuggestion()).append(" ");
            freq *= suggestItem.getFrequencyOfSuggestionInDict() / (double)this.n;
        }
        String term = stringBuilder.toString().replaceFirst("\\s++$", "");
        SuggestItem suggestion = new SuggestItem(term, this.stringDistance.distanceWithEarlyStop(input, term, Integer.MAX_VALUE), freq);
        ArrayList<SuggestItem> suggestionsLine = new ArrayList<SuggestItem>();
        suggestionsLine.add(suggestion);
        return suggestionsLine;
    }

    private void splitWords(int editDistanceMax, String[] termList, List<SuggestItem> suggestions, List<SuggestItem> suggestionParts, int i) {
        String word;
        SuggestItem suggestionSplitBest = null;
        if (!suggestions.isEmpty()) {
            suggestionSplitBest = suggestions.get(0);
        }
        if ((word = termList[i]).length() > 1) {
            for (int j = 1; j < word.length(); ++j) {
                double freq;
                List<SuggestItem> suggestions2;
                String part1 = word.substring(0, j);
                String part2 = word.substring(j);
                List<SuggestItem> suggestions1 = this.lookup(part1, Verbosity.TOP, editDistanceMax, false);
                if (suggestions1.isEmpty() || (suggestions2 = this.lookup(part2, Verbosity.TOP, editDistanceMax, false)).isEmpty()) continue;
                Bigram splitTerm = new Bigram(suggestions1.get(0).getSuggestion(), suggestions2.get(0).getSuggestion());
                int splitDistance = this.stringDistance.distanceWithEarlyStop(word, splitTerm.toString(), editDistanceMax);
                if (splitDistance < 0) {
                    splitDistance = editDistanceMax + 1;
                }
                if (suggestionSplitBest != null) {
                    if (splitDistance > suggestionSplitBest.getEditDistance()) continue;
                    if (splitDistance < suggestionSplitBest.getEditDistance()) {
                        suggestionSplitBest = null;
                    }
                }
                if (this.bigramLexicon.containsKey(splitTerm)) {
                    freq = this.bigramLexicon.get(splitTerm).longValue();
                    if (!suggestions.isEmpty()) {
                        if ((suggestions1.get(0).getSuggestion() + suggestions2.get(0).getSuggestion()).equals(word)) {
                            freq = Math.max(freq, suggestions.get(0).getFrequencyOfSuggestionInDict() + 2.0);
                        } else if (suggestions1.get(0).getSuggestion().equals(suggestions.get(0).getSuggestion()) || suggestions2.get(0).getSuggestion().equals(suggestions.get(0).getSuggestion())) {
                            freq = Math.max(freq, suggestions.get(0).getFrequencyOfSuggestionInDict() + 1.0);
                        }
                    } else if ((suggestions1.get(0).getSuggestion() + suggestions2.get(0).getSuggestion()).equals(word)) {
                        freq = Math.max(freq, Math.max(suggestions1.get(0).getFrequencyOfSuggestionInDict(), suggestions2.get(0).getFrequencyOfSuggestionInDict()));
                    }
                } else {
                    freq = Math.min(Long.MAX_VALUE, this.getNaiveBayesProbOfCombination(suggestions1, suggestions2));
                }
                SuggestItem suggestionSplit = new SuggestItem(splitTerm.toString(), splitDistance, freq);
                if (suggestionSplitBest != null && !(suggestionSplit.getFrequencyOfSuggestionInDict() > suggestionSplitBest.getFrequencyOfSuggestionInDict())) continue;
                suggestionSplitBest = suggestionSplit;
            }
            if (suggestionSplitBest != null) {
                suggestionParts.add(suggestionSplitBest);
            } else {
                SuggestItem suggestItem = new SuggestItem(word, editDistanceMax + 1, this.estimatedWordOccurrenceProbability(word));
                suggestionParts.add(suggestItem);
            }
        } else {
            SuggestItem suggestItem = new SuggestItem(word, editDistanceMax + 1, this.estimatedWordOccurrenceProbability(word));
            suggestionParts.add(suggestItem);
        }
    }

    private long getNaiveBayesProbOfCombination(List<SuggestItem> suggestions1, List<SuggestItem> suggestions2) {
        return (long)(suggestions1.get(0).getFrequencyOfSuggestionInDict() / (double)this.n * suggestions2.get(0).getFrequencyOfSuggestionInDict());
    }

    private long estimatedWordOccurrenceProbability(String word) {
        return (long)(10.0 / Math.pow(10.0, word.length()));
    }

    Optional<SuggestItem> combineWords(int editDistanceMax, boolean includeUnknown, String token, String previousToken, SuggestItem suggestItem, SuggestItem secondBestSuggestion) {
        List<SuggestItem> suggestionsCombination = this.lookup(previousToken + token, Verbosity.TOP, editDistanceMax, includeUnknown);
        if (!suggestionsCombination.isEmpty()) {
            SuggestItem best2 = Optional.ofNullable(secondBestSuggestion).orElseGet(() -> new SuggestItem(token, editDistanceMax + 1, this.estimatedWordOccurrenceProbability(token)));
            int distance = suggestItem.getEditDistance() + best2.getEditDistance();
            SuggestItem firstSuggestion = suggestionsCombination.get(0);
            if (distance >= 0 && firstSuggestion.getEditDistance() + 1 < distance || firstSuggestion.getEditDistance() + 1 == distance && firstSuggestion.getFrequencyOfSuggestionInDict() > suggestItem.getFrequencyOfSuggestionInDict() / (double)this.n * best2.getFrequencyOfSuggestionInDict()) {
                return Optional.of(new SuggestItem(firstSuggestion.getSuggestion(), firstSuggestion.getEditDistance(), firstSuggestion.getFrequencyOfSuggestionInDict()));
            }
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Long> getUnigramLexicon() {
        return this.unigramLexicon;
    }

    @Override
    public Map<Bigram, Long> getBigramLexicon() {
        return this.bigramLexicon;
    }

    Map<String, Collection<String>> getDeletes() {
        return this.deletes;
    }

    @Override
    public int getMaxDictionaryEditDistance() {
        return this.maxDictionaryEditDistance;
    }
}

