/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.node;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.io.KtCntxLog;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.node.KtAnyBoxedNode;
import com.whitemagicsoftware.keentype.node.KtBox;
import com.whitemagicsoftware.keentype.node.KtBoxSizes;
import com.whitemagicsoftware.keentype.node.KtGlueSetting;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.node.KtNodeEnum;
import com.whitemagicsoftware.keentype.node.KtNodeList;
import com.whitemagicsoftware.keentype.node.KtSettingContext;
import com.whitemagicsoftware.keentype.node.KtTypesetter;

public abstract class KtAnyBoxNode
extends KtAnyBoxedNode
implements KtBox {
    protected final KtGlueSetting setting;
    protected KtNodeList list;

    public KtAnyBoxNode(KtBoxSizes sizes, KtGlueSetting setting, KtNodeList list) {
        super(sizes);
        this.setting = setting;
        this.list = list;
    }

    public KtGlueSetting getSetting() {
        return this.setting;
    }

    public KtNodeList getList() {
        return this.list;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean isHBox() {
        return false;
    }

    @Override
    public boolean isVBox() {
        return false;
    }

    @Override
    public KtNodeEnum getHorizList() {
        return this.isHBox() ? this.list.nodes() : KtNodeEnum.NULL;
    }

    @Override
    public KtNodeEnum getVertList() {
        return this.isVBox() ? this.list.nodes() : KtNodeEnum.NULL;
    }

    @Override
    public boolean isBox() {
        return true;
    }

    @Override
    public KtBox getBox() {
        return this;
    }

    @Override
    public boolean isCleanBox() {
        return true;
    }

    @Override
    public boolean canBePartOfDiscretionary() {
        return true;
    }

    @Override
    protected boolean allegedlyVisible() {
        return true;
    }

    @Override
    public KtBox pretendingWidth(KtDimen width) {
        return this.getWidth().equals(width) ? this : this.pretendSizesCopy(this.sizes.withWidth(width));
    }

    @Override
    public void typeSet(KtTypesetter setter) {
        this.typeSet(setter, true);
    }

    @Override
    public void typeSet(KtTypesetter setter, KtSettingContext sctx) {
        if (!this.list.isEmpty()) {
            setter.push();
            this.typeSet(setter, sctx.allowIO);
            setter.pop();
        }
    }

    private void typeSet(KtTypesetter setter, boolean allowIO) {
        KtTypesetter.KtMark here = setter.mark();
        KtNodeEnum nodes = this.list.nodes();
        this.moveStart(setter);
        KtSettingContext sctx = new KtSettingContext(this.sizes, this.setting, setter.mark(), allowIO);
        while (nodes.hasMoreNodes()) {
            KtNode node = nodes.nextNode();
            this.movePrev(setter, node);
            node.typeSet(setter, sctx);
            this.movePast(setter, node);
        }
        here.move();
    }

    @Override
    public void syncVertIfBox(KtTypesetter setter) {
        if (!this.list.isEmpty()) {
            setter.syncVert();
        }
    }

    protected abstract void moveStart(KtTypesetter var1);

    protected abstract void movePrev(KtTypesetter var1, KtNode var2);

    protected abstract void movePast(KtTypesetter var1, KtNode var2);

    @Override
    public void addOn(KtLog log, KtCntxLog cntx, KtDimen shift) {
        log.addEsc(this.getDesc()).add(this.sizes).add(this.setting);
        if (shift != KtDimen.NULL && !shift.isZero()) {
            log.add(", shifted ").add(shift.toString());
        }
        cntx.addOn(log, this.list.nodes());
    }

    @Override
    public void addOn(KtLog log, KtCntxLog cntx) {
        this.addOn(log, cntx, KtDimen.NULL);
    }

    @Override
    public void addOn(KtLog log, int maxDepth, int maxCount) {
        KtCntxLog.addItem(log, this, maxDepth, maxCount);
    }

    public void addListShortlyOn(KtLog log) {
        this.list.addShortlyOn(log);
    }

    public abstract String getDesc();

    @Override
    public KtNode reboxedToWidth(KtDimen width) {
        return this.list.isEmpty() ? this.pretendingWidth(width) : super.reboxedToWidth(width);
    }
}

