/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.tex;

import com.whitemagicsoftware.keentype.command.KtTokenList;
import com.whitemagicsoftware.keentype.io.KtLog;
import com.whitemagicsoftware.keentype.io.KtLoggable;
import com.whitemagicsoftware.keentype.tex.KtTeXError;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class KtTeXErrorPool {
    private static final Map<String, KtTeXError> POOL = new HashMap<String, KtTeXError>(199);
    private static String errMessageHelp = "This error message was generated by an \\errmessage\ncommand, so I can't give any explicit help.\nPretend that you're Hercule Poirot: Examine all clues,\nand deduce the truth by order and method.";
    private static final String defaultHelp = "Sorry, I don't know how to help in this situation.\nMaybe you should try asking a human?";
    private static final String helpAfterHelp = "Sorry, I already gave what help I could...\nMaybe you should try asking a human?\nAn error might have occurred before I noticed any problems.\n``If all else fails, read the instructions.''";
    private static final String helpAfterDel = "I have just deleted some text, as you asked.\nYou can now delete more, or insert, or whatever.";

    public static KtTeXError get(String ident) {
        KtTeXError err = POOL.get(ident);
        if (err == null) {
            throw new RuntimeException("TeX error `" + ident + "' not available");
        }
        return err;
    }

    public static Iterator<String> idents() {
        return POOL.keySet().iterator();
    }

    private static void put(String ident, KtTeXError err) {
        POOL.put(ident, err);
    }

    private KtTeXErrorPool() {
        this.defineCantDeleteLastItem("CantDeleteLastSkip", "Try `I\\vskip-\\lastskip' instead");
        this.defineCantDeleteLastItem("CantDeleteLastKern", "Try `I\\kern-\\lastkern' instead");
        this.defineCantDeleteLastItem("CantDeleteLastPenalty", "Perhaps you can make the output routine do it");
        KtTeXErrorPool.defineError("IncompatibleUnbox", "Incompatible list can't be unboxed", "Sorry, Pandora. (You sneaky devil.)\nI refuse to unbox an \\hbox in vertical mode or vice versa.\nAnd I can't open any boxes in math mode.");
        KtTeXErrorPool.defineError("IllegalMathDisc", "Illegal math %1", "Sorry: The third part of a discretionary break must be\nempty, in math formulas. I had to delete your third part.");
        KtTeXErrorPool.defineError("TooLongDisc", "Discretionary list is too long", "Wow---I never thought anybody would tweak me here.\nYou can't seriously need such a huge discretionary list?");
        KtTeXErrorPool.defineError("ImproperDisc", "Improper discretionary list", "Discretionary lists must contain only boxes and kerns.");
        this.defineAllignError("AllignLeftError", "{");
        this.defineAllignError("AllignRightError", "}");
        KtTeXErrorPool.defineError("MisplacedTabMark", "Misplaced %1", "I can't figure out why you would want to use a tab mark\nhere. If you just want an ampersand, the remedy is\nsimple: Just type `I\\&' now. But if some right brace\nup above has ended a previous alignment prematurely,\nyou're probably due for more error messages, and you\nmight try typing `S' now just to see what is salvageable.");
        KtTeXErrorPool.defineError("MisplacedCrSpan", "Misplaced %1", "I can't figure out why you would want to use a tab mark\nor \\cr or \\span just now. If something like a right brace\nup above has ended a previous alignment prematurely,\nyou're probably due for more error messages, and you\nmight try typing `S' now just to see what is salvageable.");
        KtTeXErrorPool.defineError("MisplacedNoalign", "Misplaced %1", "I expect to see \\noalign only after the \\cr of\nan alignment. Proceed, and I'll ignore this case.");
        KtTeXErrorPool.defineError("MisplacedOmit", "Misplaced %1", "I expect to see \\omit only after tab marks or the \\cr of\nan alignment. Proceed, and I'll ignore this case.");
        KtTeXErrorPool.defineError("MissingCr", "Missing %1 inserted", "I'm guessing that you meant to end an alignment here.");
        KtTeXErrorPool.defineError("ExtraEndcsname", "Extra %1", "I'm ignoring this, since I wasn't doing a \\csname.");
        KtTeXErrorPool.defineError("MisplacedLimits", "Limit controls must follow a math operator", "I'm ignoring this misplaced \\limits or \\nolimits command.");
        KtTeXErrorPool.defineError("MissingDelim", "Missing delimiter (. inserted)", "I was expecting to see something like `(' or `\\{' or\n`\\}' here. If you typed, e.g., `{' instead of `\\{', you\nshould probably delete the `{' by typing `1' now, so that\nbraces don't get unbalanced. Otherwise just proceed.\nAcceptable delimiters are characters whose \\delcode is\nnonnegative, or you can use `\\delimiter <delimiter code>'.");
        KtTeXErrorPool.defineError("AccentInMathMode", "Please use %1 for accents in math mode", "I'm changing \\accent to \\mathaccent here; wish me luck.\n(Accents are not the same in formulas as they are in text.)");
        KtTeXErrorPool.defineError("DoubleSuperscript", "Double superscript", "I treat `x^1^2' essentially like `x^1{}^2'.");
        KtTeXErrorPool.defineError("DoubleSubscript", "Double subscript", "I treat `x_1_2' essentially like `x_1{}_2'.");
        KtTeXErrorPool.defineError("AmbiguousFraction", "Ambiguous; you need another { and }", "I'm ignoring this fraction specification, since I don't\nknow whether a construction like `x \\over y \\over z'\nmeans `{x \\over y} \\over z' or `x \\over {y \\over z}'.");
        KtTeXErrorPool.defineError("ExtraRight", "Extra %1", "I'm ignoring a \\right that had no matching \\left.");
        KtTeXErrorPool.defineError("InsufSymFonts", "Math formula deleted: Insufficient symbol fonts", "Sorry, but I can't typeset math unless \\textfont 2\nand \\scriptfont 2 and \\scriptscriptfont 2 have all\nthe \\fontdimen values needed in math symbol fonts.");
        KtTeXErrorPool.defineError("InsufExtFonts", "Math formula deleted: Insufficient extension fonts", "Sorry, but I can't typeset math unless \\textfont 3\nand \\scriptfont 3 and \\scriptscriptfont 3 have all\nthe \\fontdimen values needed in math extension fonts.");
        KtTeXErrorPool.defineError("BadFormulaEnd", "Display math should end with $$", "The `$' that I just saw supposedly matches a previous `$$'.\nSo I shall assume that you typed `$$' both times.");
        KtTeXErrorPool.defineError("MissingFormulaEnd", "Missing $$ inserted", "Displays can use special alignments (like \\eqalignno)\nonly if nothing but the alignment itself is between $$'s.");
        KtTeXErrorPool.defineError("NonPrefixCommand", "You can't use a prefix with `%1'", "I'll pretend you didn't say \\long or \\outer or \\global.");
        KtTeXErrorPool.defineError("NonDefineCommand", "You can't use `%1' or `%2' with `%3'", "I'll pretend you didn't say \\long or \\outer here.");
        KtTeXErrorPool.defineError("MissingCtrlSeq", "Missing control sequence inserted", "Please don't say `\\def cs{...}', say `\\def\\cs{...}'.\nI've inserted an inaccessible control sequence so that your\ndefinition will be completed without mixing me up too badly.\nYou can recover graciously from this error, if you're\ncareful; see exercise 27.2 in The TeXbook.");
        KtTeXErrorPool.defineError("MissingToForRead", "Missing `to' inserted", "You should have said `\\read<number> to \\cs'.\nI'm going to look for the \\cs now.");
        this.defineCodeOut("CodeOutOfRange", "in the range 0..");
        this.defineCodeOut("CodeGreater", "at most ");
        KtTeXErrorPool.defineError("ArithOverflow", "Arithmetic overflow", "I can't carry out that multiplication or division,\nsince the result is out of range.");
        KtTeXErrorPool.defineError("CantUseAfter", "You can't use `%1' after %2", "I'm forgetting what you said and not changing anything.");
        KtTeXErrorPool.defineError("ImproperSetbox", "Improper %1", "Sorry, \\setbox is not allowed after \\halign in a display,\nor between \\accent and an accented character.");
        KtTeXErrorPool.defineError("BadSpaceFactor", "Bad space factor (%1)", "I allow only values in the range %2..%3 here.");
        KtTeXErrorPool.defineError("BadPrevGraf", "Bad %1 (%2)", "I allow only nonnegative values here.");
        KtTeXErrorPool.defineError("CantLoadPatterns", "Patterns can be loaded only by INITEX", null);
        KtTeXErrorPool.defineError("ImproperAt", "Improper `at' size (%1pt), replaced by 10pt", "I can only handle fonts at positive sizes that are\nless than 2048pt, so I've changed what you said to 10pt.");
        KtTeXErrorPool.defineError("ShortShow", null, "This isn't an error message; I'm just \\showing something.\nType `I\\show...' to show more (e.g., \\show\\cs,\n\\showthe\\count10, \\showbox255, \\showlists).");
        KtTeXErrorPool.defineError("LongShow", null, "This isn't an error message; I'm just \\showing something.\nType `I\\show...' to show more (e.g., \\show\\cs,\n\\showthe\\count10, \\showbox255, \\showlists).\nAnd type `I\\tracingonline=1\\show...' to show boxes and\nlists on your terminal as well as in the transcript file.");
        KtTeXErrorPool.defineError("DumpInGroup", "You can't dump inside a group", "`{...\\dump}' is a no-no.");
        KtTeXErrorPool.defineError("UnbalancedWrite", "Unbalanced write command", "On this page there's a \\write with fewer real {'s than }'s.\nI can't handle that very well; good luck.");
        KtTeXErrorPool.defineFatalError("EOFonTerm", "End of file on the terminal!");
        KtTeXErrorPool.defineFatalError("NoEnd", "*** (job aborted, no legal \\end found)");
        KtTeXErrorPool.defineFatalError("NoTermRead", "*** (cannot \\read from terminal in nonstop modes)");
        KtTeXErrorPool.defineFatalError("MissingFile", "*** (job aborted, file error in nonstop mode)");
        KtTeXErrorPool.defineFatalError("IntAlignPre", "(interwoven alignment preambles are not allowed)");
    }

    public static KtTeXError get(final KtTokenList text, final KtTokenList help) {
        return new KtTeXError(){

            @Override
            public void addText(KtLog log, KtLoggable[] params) {
                log.add(text);
            }

            @Override
            public void addHelp(KtLog log, KtLoggable[] params) {
                if (!help.isEmpty()) {
                    log.add(help);
                } else {
                    KtTeXErrorPool.print(log, errMessageHelp, params);
                    log.endLine();
                }
            }

            @Override
            public void addDesc(KtLog log, KtLoggable[] params) {
                if (!help.isEmpty()) {
                    log.endLine().add(help);
                } else {
                    KtTeXErrorPool.print(log.startLine(), errMessageHelp, params);
                    errMessageHelp = "(That was another \\errmessage.)";
                }
            }
        };
    }

    private static void defineError(String ident, final String text, final String help) {
        KtTeXErrorPool.put(ident, new KtTeXError(){

            @Override
            public void addText(KtLog log, KtLoggable[] params) {
                if (text != null) {
                    KtTeXErrorPool.print(log, text, params);
                }
            }

            @Override
            public void addHelp(KtLog log, KtLoggable[] params) {
                if (help != null) {
                    KtTeXErrorPool.print(log, help, params);
                } else {
                    KtTeXErrorPool.print(log, KtTeXErrorPool.defaultHelp, null);
                }
                log.endLine();
            }

            @Override
            public void addDesc(KtLog log, KtLoggable[] params) {
                if (help != null) {
                    KtTeXErrorPool.print(log.startLine(), help, params);
                }
            }
        });
    }

    private static void defineFatalError(String ident, final String desc) {
        KtTeXErrorPool.put(ident, new KtTeXError(){

            @Override
            public void addText(KtLog log, KtLoggable[] params) {
                log.add("Emergency stop");
            }

            @Override
            public void addHelp(KtLog log, KtLoggable[] params) {
                KtTeXErrorPool.print(log, KtTeXErrorPool.defaultHelp, null);
                log.endLine();
            }

            @Override
            public void addDesc(KtLog log, KtLoggable[] params) {
                log.startLine().add(desc);
            }
        });
    }

    public static void addHelpAfterHelp(KtLog log) {
        KtTeXErrorPool.print(log, helpAfterHelp, null);
        log.endLine();
    }

    public static void addHelpAfterDel(KtLog log) {
        KtTeXErrorPool.print(log, helpAfterDel, null);
        log.endLine();
    }

    private static void print(KtLog log, String str, KtLoggable[] params) {
        int i = 0;
        while (i < str.length()) {
            int j;
            char ch;
            if ((ch = str.charAt(i++)) == '\n') {
                log.endLine();
                continue;
            }
            if (ch != '%') {
                log.add(ch);
                continue;
            }
            if (str.charAt(i) == '%') {
                log.add(str.charAt(i++));
                continue;
            }
            for (j = i; j < str.length() && Character.isDigit(str.charAt(j)); ++j) {
            }
            if (j <= i) continue;
            int n = Integer.parseInt(str.substring(i, j));
            if (params == null || 0 >= n || n > params.length) {
                throw new RuntimeException("Error parameter %" + n + " not specified (for:\n" + str + ")");
            }
            log.add(params[n - 1]);
            i = j;
        }
    }

    private static void defineInSkipped(String ident, String what) {
        KtTeXErrorPool.defineError(ident, "Incomplete %1; all text was ignored after line %2", what + " text.\nThis kind of error happens when you say `\\if...' and forget\nthe matching `\\fi'. I've inserted a `\\fi'; this might work.");
    }

    private static void defineRunaway(String ident, String w1, String w2) {
        KtTeXErrorPool.defineError(ident, w1 + " while scanning " + w2 + " of %1", "I suspect you have forgotten a `}', causing me\nto read past where you wanted me to stop.\nI'll try to recover; but if the error is serious,\nyou'd better type `E' or `X' now and fix your file.");
    }

    private static void defineBadTFM(String ident, String what) {
        KtTeXErrorPool.defineError(ident, "Font %1 not loadable: " + what, "I wasn't able to read the size data for this font,\nso I will ignore the font specification.\n[Wizards can fix TFM files using TFtoPL/PLtoTF.]\nYou might try inserting a different font spec;\ne.g., type `I\\font<same font id>=<substitute font name>'.");
    }

    private void defineCantDeleteLastItem(String ident, String what) {
        KtTeXErrorPool.defineError(ident, "You can't use `%1' in %2", "Sorry...I usually can't take things from the current page.\n" + what + ".");
    }

    private void defineAllignError(String ident, String what) {
        KtTeXErrorPool.defineError(ident, "Missing " + what + " inserted", "I've put in what seems to be necessary to fix\nthe current column of the current alignment.\nTry to go on, since this might almost work.");
    }

    private void defineCodeOut(String ident, String what) {
        KtTeXErrorPool.defineError(ident, "Invalid code (%1), should be " + what + "%2", "I'm going to use 0 instead of that illegal code value.");
    }

    static {
        KtTeXErrorPool.defineError("Void", null, null);
        KtTeXErrorPool.defineError("Confusion", "This can't happen (%1)", "I'm broken. Please show this to someone who can fix can fix");
        KtTeXErrorPool.defineError("NextConfusion", "I can't go on meeting you like this", "One of your faux pas seems to have wounded me deeply...\nin fact, I'm barely conscious. Please fix it and try again.");
        KtTeXErrorPool.defineError("Interrupt", "Interruption", "You rang?\nTry to insert some instructions for me (e.g.,`I\\showlists'),\nunless you just want to quit by typing `X'.");
        KtTeXErrorPool.defineError("IncompatMag", "Incompatible magnification (%1);\n the previous value will be retained (%2)", "I can handle only one magnification ratio per job. So I've\nreverted to the magnification you used earlier on this run.");
        KtTeXErrorPool.defineError("IllegalMag", "Illegal magnification has been changed to 1000 (%1)", "The magnification ratio must be between 1 and 32768.");
        KtTeXErrorPool.defineInSkipped("OuterInSkipped", "A forbidden control sequence occurred in skipped");
        KtTeXErrorPool.defineInSkipped("EOFinSkipped", "The file ended while I was skipping conditional");
        KtTeXErrorPool.defineRunaway("OuterInDef", "Forbidden control sequence found", "definition");
        KtTeXErrorPool.defineRunaway("EOFinDef", "File ended", "definition");
        KtTeXErrorPool.defineRunaway("OuterInMatch", "Forbidden control sequence found", "use");
        KtTeXErrorPool.defineRunaway("EOFinMatch", "File ended", "use");
        KtTeXErrorPool.defineRunaway("OuterInPreamble", "Forbidden control sequence found", "preamble");
        KtTeXErrorPool.defineRunaway("EOFinPreamble", "File ended", "preamble");
        KtTeXErrorPool.defineRunaway("OuterInToks", "Forbidden control sequence found", "text");
        KtTeXErrorPool.defineRunaway("EOFinToks", "File ended", "text");
        KtTeXErrorPool.defineError("InvalidChar", "Text line contains an invalid character", "A funny symbol that I can't read has just been input.\nContinue, and I'll forget that it ever happened.");
        KtTeXErrorPool.defineError("UndefinedToken", "KtUndefined control sequence", "The control sequence at the end of the top line\nof your error message was never \\def'ed. If you have\nmisspelled it (e.g., `\\hobx'), type `I' and the correct\nspelling (e.g., `I\\hbox'). Otherwise just continue,\nand I'll forget about whatever was undefined.");
        KtTeXErrorPool.defineError("MissingEndcsname", "Missing %1 inserted", "The control sequence marked <to be read again> should\nnot appear between \\csname and \\endcsname.");
        KtTeXErrorPool.defineError("ExtraRightBrace", "Argument of %1 has an extra }", "I've run across a `}' that doesn't seem to match anything.\nFor example, `\\def\\a#1{...}' and `\\a}' would produce\nthis error. If you simply proceed now, the `\\par' that\nI've just inserted will cause me to report a runaway\nargument that might be the root of the problem. But if\nyour `}' was spurious, just type `2' and it will go away.");
        KtTeXErrorPool.defineError("RunawayArg", "KtParagraph ended before %1 was complete", "I suspect you've forgotten a `}', causing me to apply this\ncontrol sequence to too much text. How can we recover?\nMy plan is to forget the whole thing and hope for the best.");
        KtTeXErrorPool.defineError("UseDoesntMatch", "Use of %1 doesn't match its definition", "If you say, e.g., `\\def\\a1{...}', then you must always\nput `1' after `\\a', since control sequence names are\nmade up of letters only. The macro here has not been\nfollowed by the required stuff, so I'm ignoring it.");
        KtTeXErrorPool.defineError("MissingLeftBrace", "Missing { inserted", "A left brace was mandatory here, so I've put one in.\nYou might want to delete and/or insert some corrections\nso that I will find a matching right brace soon.\n(If you're confused by all this, try typing `I}' now.)");
        KtTeXErrorPool.defineError("MixedGlueUnits", "Incompatible glue units", "I'm going to assume that 1mu=1pt when they're mixed.");
        KtTeXErrorPool.defineError("MissingNumber", "Missing number, treated as zero", "A number should have been here; I inserted `0'.\n(If you can't figure out why I needed to see a number,\nlook up `weird error' in the index to The TeXbook.)");
        KtTeXErrorPool.defineError("ImproperSForPD", "Improper %1", "You can refer to \\spacefactor only in horizontal mode;\nyou can refer to \\prevdepth only in vertical mode; and\nneither of these is meaningful inside \\write. So\nI'm forgetting what you said and using zero instead.");
        KtTeXErrorPool.defineError("CantAfterThe", "You can't use `%1' after %2", "I'm forgetting what you said and using zero instead.");
        KtTeXErrorPool.defineError("BadRegister", "Bad register code (%1)", "A register number must be between %2 and %3.\nI changed this one to zero.");
        KtTeXErrorPool.defineError("BadCharCode", "Bad character code (%1)", "A character number must be between %2 and %3.\nI changed this one to zero.");
        KtTeXErrorPool.defineError("BadFileNum", "Bad number (%1)", "Since I expected to read a number between %2 and %3,\nI changed this one to zero.");
        KtTeXErrorPool.defineError("BadMathCharCode", "Bad mathchar (%1)", "A mathchar number must be between %2 and %3.\nI changed this one to zero.");
        KtTeXErrorPool.defineError("BadDelimiterCode", "Bad delimiter code (%1)", "A numeric delimiter code must be between %2 and 2^{27}-1.\nI changed this one to zero.");
        KtTeXErrorPool.defineError("NonNumericToken", "Improper alphabetic constant", "A one-character control sequence belongs after a ` mark.\nSo I'm essentially inserting \\0 here.");
        KtTeXErrorPool.defineError("NumberTooBig", "Number too big", "I can only go up to 2147483647='17777777777=\"7FFFFFFF,\nso I'm using that number instead of yours.");
        KtTeXErrorPool.defineError("IllegalFil", "Illegal unit of measure (replaced by filll)", "I dddon't go any higher than filll.");
        KtTeXErrorPool.defineError("IllegalMu", "Illegal unit of measure (mu inserted)", "The unit of measurement in math glue must be mu.\nTo recover gracefully from this error, it's best to\ndelete the erroneous units; e.g., type `2' to delete\ntwo letters. (See Chapter 27 of The TeXbook.)");
        KtTeXErrorPool.defineError("IllegalUnit", "Illegal unit of measure (pt inserted)", "Dimensions can be in units of em, ex, in, pt, pc,\ncm, mm, dd, cc, bp, or sp; but yours is a new one!\nI'll assume that you meant to say pt, for printer's points.\nTo recover gracefully from this error, it's best to\ndelete the erroneous units; e.g., type `2' to delete\ntwo letters. (See Chapter 27 of The TeXbook.)");
        KtTeXErrorPool.defineError("DimenTooLarge", "Dimension too large", "I can't work with sizes bigger than about 19 feet.\nContinue and I'll use the largest value I can.");
        KtTeXErrorPool.defineError("MissingLeftDefBrace", "Missing { inserted", "Where was the left brace? You said something like `\\def\\a}',\nwhich I'm going to interpret as `\\def\\a{}'.");
        KtTeXErrorPool.defineError("TooManyParams", "You already have nine parameters", "I'm going to ignore the # sign you just used.");
        KtTeXErrorPool.defineError("NonConseqParams", "Parameters must be numbered consecutively", "I've inserted the digit you should have used after the #.\nType `1' to delete what you did use.");
        KtTeXErrorPool.defineError("IllegalParamNum", "Illegal parameter number in definition of %1", "You meant to type ## instead of #, right?\nOr maybe a } was forgotten somewhere earlier, and things\nare all screwed up? I'm going to assume that you meant ##.");
        KtTeXErrorPool.defineError("EOFinRead", "File ended within %1", "This \\read has unbalanced braces.");
        KtTeXErrorPool.defineError("ExtraOrElseFi", "Extra %1", "I'm ignoring this; it doesn't match any \\if.");
        KtTeXErrorPool.defineError("IllegalIfnumOp", "Missing = inserted for %1", "I was expecting to see `<', `=', or `>'. Didn't.");
        KtTeXErrorPool.defineBadTFM("TFMisBad", "Bad metric (TFM) file");
        KtTeXErrorPool.defineBadTFM("TFMnotFound", "Metric (TFM) file not found");
        KtTeXErrorPool.defineError("NotEnoughRoomForTFM", "Font %1 not loaded: Not enough room left", "I'm afraid I won't be able to make use of this font,\nbecause my memory for character-size data is too small.\nIf you're really stuck, ask a wizard to enlarge me.\nOr maybe try `I\\font<same font id>=<name of loaded font>'.");
        KtTeXErrorPool.defineError("MissingFontIdent", "Missing font identifier", "I was looking for a control sequence whose\ncurrent meaning has been defined by \\font.");
        KtTeXErrorPool.defineError("TooBigFontdimenNum", "Font %1 has only %2 fontdimen parameters", "To increase the number of font parameters, you must\nuse \\fontdimen immediately after the \\font is loaded.");
        KtTeXErrorPool.defineError("PageTooLarge", "Huge page cannot be shipped out", "The page just created is more than 18 feet tall or\nmore than 18 feet wide, so I suspect something went wrong.");
        KtTeXErrorPool.defineError("UndefFamily", "%1 %2 is undefined (character %3)", "Somewhere in the math formula just ended, you used the\nstated character from an undefined font family. For example,\nplain TeX doesn't allow \\it or \\sl in subscripts. Proceed,\nand I'll try to forget that I needed that character.");
        KtTeXErrorPool.defineError("ImproperAlignInFormula", "Improper %1 inside $$'s", "Displays can use special alignments (like \\eqalignno)\nonly if nothing but the alignment itself is between $$'s.\nSo I've deleted the formulas that preceded this alignment.");
        KtTeXErrorPool.defineError("MissingSharp", "Missing # inserted in alignment preamble", "There should be exactly one # between &'s, when an\n\\halign or \\valign is being set up. In this case you had\nnone, so I've put one in; maybe that will work.");
        KtTeXErrorPool.defineError("SecondSharpInTab", "Only one # is allowed per tab", "There should be exactly one # between &'s, when an\n\\halign or \\valign is being set up. In this case you had\nmore than one, so I'm ignoring all but the first.");
        KtTeXErrorPool.defineError("ExtraAlignTab", "Extra alignment tab has been changed to %1", "You have given more \\span or & marks than there were\nin the preamble to the \\halign or \\valign now in progress.\nSo I'll assume that you meant to type \\cr instead.");
        KtTeXErrorPool.defineError("InfShringInPar", "Infinite glue shrinkage found in a paragraph", "The paragraph just ended includes some glue that has\ninfinite shrinkability, e.g., `\\hskip 0pt minus 1fil'.\nSuch glue doesn't belong there---it allows a paragraph\nof any length to fit on one line. But it's safe to proceed,\nsince the offensive shrinkability has been made finite.");
        KtTeXErrorPool.defineError("ImproperHyphen", "Improper %1 will be flushed", "Hyphenation exceptions must contain only letters\nand hyphens. But continue; I'll forgive and forget.");
        KtTeXErrorPool.defineError("NonLetterInHyph", "Not a letter", "Letters in \\hyphenation words must have \\lccode>0.\nProceed; I'll ignore the character I just read.");
        KtTeXErrorPool.defineError("LatePatterns", "Too late for %1", "All patterns must be given before typesetting begins.");
        KtTeXErrorPool.defineError("BadPatterns", "Bad %1", "(See Appendix H.)");
        KtTeXErrorPool.defineError("NonLetter", "Nonletter", "(See Appendix H.)");
        KtTeXErrorPool.defineError("DupPattern", "Duplicate pattern", "(See Appendix H.)");
        KtTeXErrorPool.defineError("InfShrinkInVsplit", "Infinite glue shrinkage found in box being split", "The box you are \\vsplitting contains some infinitely\nshrinkable glue, e.g., `\\vss' or `\\vskip 0pt minus 1fil'.\nSuch glue doesn't belong there; but you can safely proceed,\nsince the offensive shrinkability has been made finite.");
        KtTeXErrorPool.defineError("SplittingNonVbox", "%1 needs a %2", "The box you are trying to split is an \\hbox.\nI can't split such a box, so I'll leave it alone.");
        KtTeXErrorPool.defineError("MisplacedInsert", "Insertions can only be added to a vbox", "Tut tut: You're trying to \\insert into a\n\\box register that now contains an \\hbox.\nProceed, and I'll discard its present contents.");
        KtTeXErrorPool.defineError("InfShrinkInPage", "Infinite glue shrinkage found on current page", "The page about to be output contains some infinitely\nshrinkable glue, e.g., `\\vss' or `\\vskip 0pt minus 1fil'.\nSuch glue doesn't belong there; but you can safely proceed,\nsince the offensive shrinkability has been made finite.");
        KtTeXErrorPool.defineError("InfShrinkInsert", "Infinite glue shrinkage inserted from %1%2", "The correction glue for page breaking with insertions\nmust have finite shrinkability. But you may proceed,\nsince the offensive shrinkability has been made finite.");
        KtTeXErrorPool.defineError("NonEmptyOutBox", "%1%2 is not void", "You shouldn't use \\box255 except in \\output routines.\nProceed, and I'll discard its present contents.");
        KtTeXErrorPool.defineError("TooMuchDead", "Output loop---%1 consecutive dead cycles", "I've concluded that your \\output is awry; it never does a\n\\shipout, so I'm shipping \\box255 out myself. Next time\nincrease \\maxdeadcycles if you want me to be more patient!");
        KtTeXErrorPool.defineError("UnbalancedOutput", "Unbalanced output routine", "Your sneaky output routine has problematic {'s and/or }'s.\nI can't handle that very well; good luck.");
        KtTeXErrorPool.defineError("NonEmptyOutBoxAfter", "Output routine didn't use all of %1%2", "Your \\output commands should empty \\box255,\ne.g., by saying `\\shipout\\box255'.\nProceed; I'll discard its present contents.");
        KtTeXErrorPool.defineError("MissingDollar", "Missing $ inserted", "I've inserted a begin-math/end-math symbol since I think\nyou left one out. Proceed, with fingers crossed.");
        KtTeXErrorPool.defineError("CantUseIn", "You can't use `%1' in %2", "Sorry, but I'm not programmed to handle this case;\nI'll just pretend that you didn't ask for it.\nIf you're in the wrong mode, you might be able to\nreturn to the right one by typing `I}' or `I$' or `I\\par'.");
        KtTeXErrorPool.defineError("MissingInserted", "Missing %1 inserted", "I've inserted something that you may have forgotten.\n(See the <inserted text> above.)\nWith luck, this will get me unwedged. But if you\nreally didn't forget anything, try typing `2' now; then\nmy insertion and my current dilemma will both disappear.");
        KtTeXErrorPool.defineError("ExtraCommand", "Extra %1", "Things are pretty mixed up, but I think the worst is over.");
        KtTeXErrorPool.defineError("TooManyRightBraces", "Too many }'s", "You've closed more groups than you opened.\nSuch booboos are generally harmless, so keep going.");
        KtTeXErrorPool.defineError("ExtraOrForgotten", "Extra }, or forgotten %1", "I've deleted a group-closing symbol because it seems to be\nspurious, as in `$x}$'. But perhaps the } is legitimate and\nyou forgot something else, as in `\\hbox{$x}'. In such cases\nthe way to recover is to insert both the forgotten and the\ndeleted material, e.g., by typing `I$}'.");
        KtTeXErrorPool.defineError("BadGlueAfterLeaders", "KtLeaders not followed by proper glue", "You should say `\\leaders <box or rule><hskip or vskip>'.\nI found the <box or rule>, but there's no suitable\n<hskip or vskip>, so I'm ignoring these leaders.");
        KtTeXErrorPool.defineError("LastBoxIn", "You can't use `%1' in %2", "Sorry; this \\lastbox will be void.\n");
        KtTeXErrorPool.defineError("CantTakeFromPage", "You can't use `%1' in %2", "Sorry...I usually can't take things from the current page.\nThis \\lastbox will therefore be void.");
        KtTeXErrorPool.defineError("MissingToForVsplit", "Missing `to' inserted", "I'm working on `\\vsplit<box number> to <dimen>';\nwill look for the <dimen> next.");
        KtTeXErrorPool.defineError("BoxExpected", "A <box> was supposed to be here", "I was expecting to see \\hbox or \\vbox or \\copy or \\box or\nsomething like that. So you might find something missing in\nyour output. But keep trying; you can fix this later.");
        KtTeXErrorPool.defineError("CantUseHrule", "You can't use `%1' here except with leaders", "To put a horizontal rule in an hbox or an alignment,\nyou should use \\leaders or \\hrulefill (see The TeXbook).");
        KtTeXErrorPool.defineError("CantInsertOutbox", "You can't %1%2", "I'm changing to %1%3; box %2 is special.");
    }
}

