/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.parser;

import com.whitemagicsoftware.keenquotes.lex.FilterType;
import com.whitemagicsoftware.keenquotes.lex.LexerFilter;
import com.whitemagicsoftware.keenquotes.parser.AmbiguityResolver;
import com.whitemagicsoftware.keenquotes.parser.Contractions;
import com.whitemagicsoftware.keenquotes.parser.Token;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;

public class Curler
implements Function<String, String> {
    private final Contractions mContractions;
    private final LexerFilter mFilter;
    private final boolean mEntities;

    public Curler(Contractions c, FilterType filterType, boolean entities) {
        assert (c != null);
        this.mContractions = c;
        this.mEntities = entities;
        this.mFilter = filterType.filter();
    }

    @Override
    public String apply(String text) {
        StringBuilder output = new StringBuilder(text);
        AtomicInteger offset = new AtomicInteger(0);
        AmbiguityResolver.resolve(text, this.mContractions, Curler.replace(output, offset, this.mEntities), this.mFilter);
        return output.toString();
    }

    public static Consumer<Token> replace(StringBuilder output, AtomicInteger offset, boolean entities) {
        return token -> {
            if (!token.isAmbiguous()) {
                String text = token.toString(entities);
                output.replace(token.began() + offset.get(), token.ended() + offset.get(), text);
                offset.addAndGet(text.length() - (token.ended() - token.began()));
            }
        };
    }
}

