/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keenquotes.util;

import java.util.function.Function;

public final class FastCharacterIterator {
    private final String mS;
    private final int mLen;
    private int mPos;

    public FastCharacterIterator(String s) {
        assert (s != null);
        this.mS = s;
        this.mLen = s.length();
    }

    public int index() {
        return this.mPos;
    }

    public char current() {
        try {
            return this.mS.charAt(this.mPos);
        }
        catch (Exception ex) {
            return '\uffff';
        }
    }

    public char advance() {
        try {
            return this.mS.charAt(++this.mPos);
        }
        catch (Exception ex) {
            return '\uffff';
        }
    }

    public char peek() {
        try {
            return this.mS.charAt(this.mPos + 1);
        }
        catch (Exception ex) {
            return '\uffff';
        }
    }

    public void next() {
        ++this.mPos;
    }

    public void prev() {
        --this.mPos;
    }

    public boolean hasNext() {
        return this.mPos < this.mLen;
    }

    public void skip(Function<Character, Boolean> f) {
        assert (f != null);
        while (f.apply(Character.valueOf(this.advance())).booleanValue()) {
        }
        this.prev();
    }

    public String substring(int began, int ended) {
        assert (began >= 0);
        assert (began <= ended);
        assert (ended < this.mLen);
        return this.mS.substring(began, ended);
    }
}

