/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.keentype.typo;

import com.whitemagicsoftware.keentype.base.KtDimen;
import com.whitemagicsoftware.keentype.builder.KtBuilder;
import com.whitemagicsoftware.keentype.command.KtCommand;
import com.whitemagicsoftware.keentype.command.KtPrim;
import com.whitemagicsoftware.keentype.command.KtToken;
import com.whitemagicsoftware.keentype.io.KtCharCode;
import com.whitemagicsoftware.keentype.node.KtAccKernNode;
import com.whitemagicsoftware.keentype.node.KtFontMetric;
import com.whitemagicsoftware.keentype.node.KtHBoxNode;
import com.whitemagicsoftware.keentype.node.KtHShiftNode;
import com.whitemagicsoftware.keentype.node.KtNode;
import com.whitemagicsoftware.keentype.typo.KtAction;
import com.whitemagicsoftware.keentype.typo.KtBuilderPrim;
import com.whitemagicsoftware.keentype.typo.KtTypoCommand;

public class KtAccentPrim
extends KtBuilderPrim {
    public final KtAction NORMAL = new KtAction(){

        @Override
        public void exec(KtBuilder bld, KtToken src) {
            KtCharCode code = KtToken.makeCharCode(KtPrim.scanCharacterCode());
            if (code == KtCharCode.NULL) {
                throw new RuntimeException("no char number scanned");
            }
            KtFontMetric metric = KtTypoCommand.getCurrFontMetric();
            KtNode node = metric.getCharNode(code);
            if (node == KtNode.NULL) {
                KtTypoCommand.charWarning(metric, code);
            } else {
                KtDimen x = metric.getDimenParam(4);
                KtDimen s = metric.getDimenParam(0);
                KtToken tok = 1.nextNonAssignment();
                KtCommand cmd = 1.meaningOf(tok);
                code = cmd.charCodeToAdd();
                if (code == KtCharCode.NULL) {
                    1.backToken(tok);
                } else {
                    KtFontMetric nextMetric = KtTypoCommand.getCurrFontMetric();
                    KtNode nextNode = nextMetric.getCharNode(code);
                    if (nextNode == KtNode.NULL) {
                        KtTypoCommand.charWarning(nextMetric, code);
                    } else {
                        KtDimen h = nextNode.getHeight();
                        if (!h.equals(x)) {
                            node = KtHBoxNode.packedOf(node);
                            node = KtHShiftNode.shiftingDown(node, x.minus(h));
                        }
                        KtDimen a = node.getWidth();
                        KtDimen delta = KtAccentPrim.makeDelta(a, x, s, nextNode.getWidth(), h, nextMetric.getDimenParam(0));
                        bld.addNode(new KtAccKernNode(delta));
                        bld.addNode(node);
                        node = nextNode;
                        bld.addNode(new KtAccKernNode(delta.plus(a).negative()));
                    }
                }
                bld.addNode(node);
                bld.resetSpaceFactor();
            }
        }
    };

    public KtAccentPrim(String name) {
        super(name);
    }

    private static KtDimen makeDelta(KtDimen a, KtDimen x, KtDimen s, KtDimen w, KtDimen h, KtDimen t) {
        return KtDimen.valueOf(w.minus(a).toDouble() / 2.0 + h.toDouble() * t.toDouble() - x.toDouble() * s.toDouble());
    }

    private static int spoints(KtDimen d) {
        return d.toInt(65536);
    }
}

