/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import net.jsign.poi.hpsf.ClassID;
import net.jsign.poi.poifs.filesystem.DirectoryEntry;
import net.jsign.poi.poifs.filesystem.DocumentEntry;
import net.jsign.poi.poifs.filesystem.DocumentNode;
import net.jsign.poi.poifs.filesystem.Entry;
import net.jsign.poi.poifs.filesystem.EntryNode;
import net.jsign.poi.poifs.filesystem.POIFSDocument;
import net.jsign.poi.poifs.filesystem.POIFSDocumentPath;
import net.jsign.poi.poifs.filesystem.POIFSFileSystem;
import net.jsign.poi.poifs.property.DirectoryProperty;
import net.jsign.poi.poifs.property.DocumentProperty;
import net.jsign.poi.poifs.property.Property;

public class DirectoryNode
extends EntryNode
implements Iterable<Entry>,
DirectoryEntry {
    private final Map<String, Entry> _byname = new HashMap<String, Entry>();
    private final ArrayList<Entry> _entries = new ArrayList();
    private final POIFSFileSystem _filesystem;
    private final POIFSDocumentPath _path;

    DirectoryNode(DirectoryProperty property, POIFSFileSystem filesystem, DirectoryNode parent) {
        super(property, parent);
        this._filesystem = filesystem;
        this._path = parent == null ? new POIFSDocumentPath() : new POIFSDocumentPath(parent._path, new String[]{property.getName()});
        Iterator<Property> iter = property.getChildren();
        while (iter.hasNext()) {
            EntryNode childNode;
            Property child = iter.next();
            if (child.isDirectory()) {
                DirectoryProperty childDir = (DirectoryProperty)child;
                childNode = new DirectoryNode(childDir, this._filesystem, this);
            } else {
                childNode = new DocumentNode((DocumentProperty)child, this);
            }
            this._entries.add(childNode);
            this._byname.put(childNode.getName(), childNode);
        }
    }

    public POIFSFileSystem getFileSystem() {
        return this._filesystem;
    }

    DocumentEntry createDocument(POIFSDocument document) throws IOException {
        DocumentProperty property = document.getDocumentProperty();
        DocumentNode rval = new DocumentNode(property, this);
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._filesystem.addDocument(document);
        this._entries.add(rval);
        this._byname.put(property.getName(), rval);
        return rval;
    }

    public Iterator<Entry> getEntries() {
        return this._entries.iterator();
    }

    public boolean hasEntry(String name) {
        return name != null && this._byname.containsKey(name);
    }

    public Entry getEntry(String name) throws FileNotFoundException {
        Entry rval = null;
        if (name != null) {
            rval = this._byname.get(name);
        }
        if (rval == null) {
            if (this._byname.containsKey("Workbook")) {
                throw new IllegalArgumentException("The document is really a XLS file");
            }
            if (this._byname.containsKey("PowerPoint Document")) {
                throw new IllegalArgumentException("The document is really a PPT file");
            }
            if (this._byname.containsKey("VisioDocument")) {
                throw new IllegalArgumentException("The document is really a VSD file");
            }
            throw new FileNotFoundException("no such entry: \"" + name + "\", had: " + this._byname.keySet());
        }
        return rval;
    }

    public DocumentEntry createDocument(String name, InputStream stream) throws IOException {
        return this.createDocument(new POIFSDocument(name, this._filesystem, stream));
    }

    public DocumentEntry createOrUpdateDocument(String name, InputStream stream) throws IOException {
        if (!this.hasEntry(name)) {
            return this.createDocument(name, stream);
        }
        DocumentNode existing = (DocumentNode)this.getEntry(name);
        POIFSDocument nDoc = new POIFSDocument(existing);
        nDoc.replaceContents(stream);
        return existing;
    }

    public ClassID getStorageClsid() {
        return this.getProperty().getStorageClsid();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.getEntries();
    }

    @Override
    public Spliterator<Entry> spliterator() {
        return this._entries.spliterator();
    }
}

